/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.hosted.code.aarch64.AArch64HostedPatcher;
import com.oracle.svm.hosted.code.aarch64.AArch64MovSequenceHostedPatcher;
import com.oracle.svm.hosted.code.aarch64.ADRADDPRELMacroInstructionHostedPatcher;
import com.oracle.svm.hosted.code.aarch64.AdrpAddMacroInstructionHostedPatcher;
import java.util.function.Consumer;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.AArch64.class})
class AArch64HostedPatcherFeature
implements Feature {
    AArch64HostedPatcherFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(PatchConsumerFactory.HostedPatchConsumerFactory.class, (Object)new PatchConsumerFactory.HostedPatchConsumerFactory(){

            @Override
            public Consumer<Assembler.CodeAnnotation> newConsumer(final CompilationResult compilationResult) {
                return new Consumer<Assembler.CodeAnnotation>(){

                    @Override
                    public void accept(Assembler.CodeAnnotation annotation) {
                        if (annotation instanceof AArch64Assembler.OperandDataAnnotation) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AArch64HostedPatcher(annotation.instructionPosition, (AArch64Assembler.OperandDataAnnotation)annotation));
                        } else if (annotation instanceof AArch64Assembler.MovSequenceAnnotation) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AArch64MovSequenceHostedPatcher(annotation.instructionPosition, (AArch64Assembler.MovSequenceAnnotation)annotation));
                        } else if (annotation instanceof AArch64MacroAssembler.ADRADDPRELMacroInstruction) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new ADRADDPRELMacroInstructionHostedPatcher((AArch64MacroAssembler.ADRADDPRELMacroInstruction)annotation));
                        } else if (annotation instanceof AArch64MacroAssembler.AdrpAddMacroInstruction) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AdrpAddMacroInstructionHostedPatcher((AArch64MacroAssembler.AdrpAddMacroInstruction)annotation));
                        }
                    }
                };
            }
        });
    }
}

