/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.WordBase;

class VMThreadCounterOperation
extends VMOperation {
    private Log trace;
    private AtomicBoolean printLaggards;
    private int count;

    VMThreadCounterOperation(Log trace, AtomicBoolean printLaggards) {
        super("VMThreadCounterOperation", VMOperation.CallerEffect.BLOCKS_CALLER, VMOperation.SystemEffect.DOES_NOT_CAUSE_SAFEPOINT);
        this.trace = trace;
        this.printLaggards = printLaggards;
        this.count = 0;
    }

    int getCount() {
        return this.count;
    }

    @Override
    public void operate() {
        this.count = 0;
        IsolateThread isolateThread = VMThreads.firstThread();
        while (VMThreads.isNonNullThread(isolateThread)) {
            ++this.count;
            if (this.printLaggards.get() && this.trace.isEnabled() && isolateThread != this.getQueuingVMThread()) {
                this.trace.string("  laggard isolateThread: ").hex((WordBase)isolateThread);
                Thread thread = JavaThreads.singleton().fromVMThread(isolateThread);
                if (thread != null) {
                    String name = thread.getName();
                    Thread.State status = thread.getState();
                    boolean interruptedStatus = thread.isInterrupted();
                    this.trace.string("  thread.getName(): ").string(name).string("  interruptedStatus: ").bool(interruptedStatus).string("  getState(): ").string(status.name());
                }
                this.trace.newline().flush();
            }
            isolateThread = VMThreads.nextThread(isolateThread);
        }
    }
}

