/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.Target_java_io_FileDescriptor_jni;
import com.oracle.svm.core.posix.Target_java_io_FileInputStream_jni;
import com.oracle.svm.core.posix.Target_java_io_FileOutputStream_jni;
import com.oracle.svm.core.posix.Target_java_io_UnixFileSystem_jni;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={Platform.LINUX.class, InternalPlatform.LINUX_JNI.class, Platform.DARWIN.class, InternalPlatform.DARWIN_JNI.class})
public final class PosixJavaIOSubstitutions {
    private PosixJavaIOSubstitutions() {
    }

    @Platforms(value={InternalPlatform.LINUX_JNI.class, InternalPlatform.DARWIN_JNI.class})
    public static boolean initIDs() {
        try {
            System.loadLibrary("java");
            Target_java_io_FileDescriptor_jni.initIDs();
            Target_java_io_FileInputStream_jni.initIDs();
            Target_java_io_FileOutputStream_jni.initIDs();
            Target_java_io_UnixFileSystem_jni.initIDs();
            System.setIn(new BufferedInputStream(new FileInputStream(FileDescriptor.in)));
            System.setOut(new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true));
            System.setErr(new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true));
            System.loadLibrary("zip");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.log().string("System.loadLibrary failed, " + e).newline();
            return false;
        }
    }
}

