/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.LocalizationSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import sun.util.locale.BaseLocale;

@AutomaticFeature
public final class LocalizationFeature
implements Feature {
    public void afterRegistration(Feature.AfterRegistrationAccess arg0) {
        ImageSingletons.add(LocalizationSupport.class, (Object)new LocalizationSupport());
        if (Options.AddAllCharsets.getValue().booleanValue()) {
            for (Charset c : Charset.availableCharsets().values()) {
                LocalizationFeature.addCharset(c);
            }
        } else {
            LocalizationFeature.addCharset(Charset.defaultCharset());
            LocalizationFeature.addCharset(Charset.forName("US-ASCII"));
            LocalizationFeature.addCharset(Charset.forName("ISO-8859-1"));
            LocalizationFeature.addCharset(Charset.forName("UTF-8"));
            LocalizationFeature.addCharset(Charset.forName("UTF-16BE"));
            LocalizationFeature.addCharset(Charset.forName("UTF-16LE"));
            LocalizationFeature.addCharset(Charset.forName("UTF-16"));
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        LocalizationSupport support = (LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class);
        access.registerAsImmutable((Object)support, LocalizationFeature::isImmutable);
    }

    private static boolean isImmutable(Object object) {
        if (object instanceof BaseLocale || object instanceof Locale) {
            return false;
        }
        return !(object instanceof Map);
    }

    public static void addCharset(Charset charset) {
        Map<String, Charset> charsets = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).charsets;
        charsets.put(charset.name().toLowerCase(), charset);
        for (String name : charset.aliases()) {
            charsets.put(name.toLowerCase(), charset);
        }
        charset.newDecoder();
        if (charset.canEncode()) {
            charset.newEncoder();
        }
    }

    public static final class CharsetNodePlugin
    implements NodePlugin {
        public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if ((method.getName().equals("initc2b") || method.getName().equals("initb2c")) && b.getMetaAccess().lookupJavaType(Charset.class).isAssignableFrom(method.getDeclaringClass())) {
                ResolvedJavaType charsetType = method.getDeclaringClass();
                ResolvedJavaField initializedField = CharsetNodePlugin.findStaticField(charsetType, method.getName().substring(4, 7) + "Initialized");
                if (!b.getConstantReflection().readFieldValue(initializedField, null).asBoolean()) {
                    String charsetName = charsetType.getUnqualifiedName();
                    try {
                        Charset charset = Charset.forName(charsetName);
                        LocalizationFeature.addCharset(charset);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw VMError.shouldNotReachHere("Could not find non-initialized charset " + charsetType.getSourceFileName(), e);
                    }
                }
                return true;
            }
            return false;
        }

        private static ResolvedJavaField findStaticField(ResolvedJavaType declaringClass, String name) {
            for (ResolvedJavaField field : declaringClass.getStaticFields()) {
                if (!field.getName().equals(name)) continue;
                return field;
            }
            throw VMError.shouldNotReachHere();
        }
    }

    public static class Options {
        @Option(help={"Make all hosted charsets available at run time"})
        public static final HostedOptionKey<Boolean> AddAllCharsets = new HostedOptionKey<Boolean>(false);
    }
}

