/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.util.ByteArrayReader;
import org.graalvm.word.Pointer;

public class InstanceReferenceMapDecoder {
    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    public static boolean walkOffsetsFromPointer(Pointer baseAddress, byte[] referenceMapEncoding, long referenceMapIndex, ObjectReferenceVisitor visitor) {
        long entryStart;
        assert (referenceMapIndex >= 0L);
        assert (referenceMapEncoding != null);
        int entryCount = ByteArrayReader.getS4(referenceMapEncoding, referenceMapIndex);
        assert (entryCount >= 0);
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        boolean compressed = ReferenceAccess.singleton().haveCompressedReferences();
        for (long idx = entryStart = referenceMapIndex + 4L; idx < entryStart + (long)(entryCount * 8); idx += 8L) {
            int offset = ByteArrayReader.getS4(referenceMapEncoding, idx);
            long count = ByteArrayReader.getU4(referenceMapEncoding, idx + 4L);
            Pointer objRef = baseAddress.add(offset);
            int c = 0;
            while ((long)c < count) {
                boolean visitResult = visitor.visitObjectReferenceInline(objRef, 0, compressed);
                if (!visitResult) {
                    return false;
                }
                objRef = objRef.add(referenceSize);
                ++c;
            }
        }
        return true;
    }
}

