/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.meta.SharedMethod;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.phases.Phase;

public class RemoveUnwindPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        SharedMethod method = (SharedMethod)graph.method();
        if (method.isDeoptTarget()) {
            return;
        }
        ArrayList<InvokeWithExceptionNode> invocations = new ArrayList<InvokeWithExceptionNode>();
        for (UnwindNode unwindNode : graph.getNodes().filter(UnwindNode.class)) {
            this.walkBack(unwindNode.predecessor(), (Node)unwindNode, invocations);
        }
        for (InvokeWithExceptionNode invokeWithExceptionNode : invocations) {
            invokeWithExceptionNode.replaceWithInvoke();
        }
    }

    protected void walkBack(Node n, Node successor, List<InvokeWithExceptionNode> invocations) {
        if (n instanceof InvokeWithExceptionNode) {
            InvokeWithExceptionNode node = (InvokeWithExceptionNode)n;
            if (node.exceptionEdge() == successor) {
                invocations.add(node);
            }
        } else if (n instanceof MergeNode) {
            MergeNode node = (MergeNode)n;
            for (ValueNode predecessor : node.cfgPredecessors()) {
                this.walkBack((Node)predecessor, (Node)node, invocations);
            }
        } else if (n instanceof EndNode || n instanceof LoopExitNode || n instanceof ExceptionObjectNode) {
            this.walkBack(n.predecessor(), n, invocations);
        }
    }
}

