/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.lir;

import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import java.util.List;
import jdk.vm.ci.code.site.Infopoint;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class DeoptEntryOp
extends LIRInstruction {
    public static final LIRInstructionClass<DeoptEntryOp> TYPE = LIRInstructionClass.create(DeoptEntryOp.class);
    @LIRInstruction.State
    protected LIRFrameState state;

    public DeoptEntryOp(LIRFrameState state) {
        super(TYPE);
        this.state = state;
    }

    public void emitCode(CompilationResultBuilder crb) {
        CompilationResult compilation = crb.compilationResult;
        List infoPoints = compilation.getInfopoints();
        int size = infoPoints.size();
        for (int idx = size - 1; idx >= 0; --idx) {
            Infopoint infopoint = (Infopoint)infoPoints.get(idx);
            int entryOffset = CodeInfoEncoder.getEntryOffset(infopoint);
            if (entryOffset < 0 || entryOffset != crb.asm.position()) continue;
            crb.asm.ensureUniquePC();
            break;
        }
        compilation.addInfopoint((Infopoint)new DeoptEntryInfopoint(crb.asm.position(), this.state.debugInfo()));
        crb.asm.ensureUniquePC();
    }

    public boolean destroysCallerSavedRegisters() {
        return true;
    }
}

