/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.code.AbstractCodeInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.UnsignedWord;

public class ImageCodeInfo
extends AbstractCodeInfo {
    public static final String CODE_INFO_NAME = "image code";

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ImageCodeInfo() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setData(CFunctionPointer codeStart, UnsignedWord codeSize) {
        super.setData((CodePointer)codeStart, codeSize);
    }

    public boolean walkImageCode(MemoryWalker.Visitor visitor) {
        return visitor.visitImageCode(this, (MemoryWalker.ImageCodeAccess)ImageSingletons.lookup(MemoryWalkerAccessImpl.class));
    }

    @Override
    public String getName() {
        return CODE_INFO_NAME;
    }

    public static final class MemoryWalkerAccessImpl
    implements MemoryWalker.ImageCodeAccess<ImageCodeInfo> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected MemoryWalkerAccessImpl() {
        }

        @Override
        public UnsignedWord getStart(ImageCodeInfo imageCodeInfo) {
            return (UnsignedWord)imageCodeInfo.getCodeStart();
        }

        @Override
        public UnsignedWord getSize(ImageCodeInfo imageCodeInfo) {
            return imageCodeInfo.getCodeSize();
        }

        @Override
        public String getRegion(ImageCodeInfo imageCodeInfo) {
            return ImageCodeInfo.CODE_INFO_NAME;
        }
    }
}

