/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.driver.APIOptionHandler;
import com.oracle.svm.driver.DefaultOptionHandler;
import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.MacroOptionHandler;
import com.oracle.svm.driver.NativeImageServer;
import com.oracle.svm.graal.hosted.GraalFeature;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.ResourcesFeature;
import com.oracle.svm.hosted.image.AbstractBootImage;
import com.oracle.svm.hosted.substitute.DeclarativeSubstitutionProcessor;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.proxy.hosted.DynamicProxyFeature;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.ProcessProperties;

public class NativeImage {
    static final boolean IS_AOT = Boolean.getBoolean("com.oracle.graalvm.isaot");
    static final String platform = NativeImage.getPlatform();
    static final String graalvmVersion = System.getProperty("org.graalvm.version", "dev");
    static final String graalvmConfig = System.getProperty("org.graalvm.config", "");
    static final Map<String, String[]> graalCompilerFlags = NativeImage.getCompilerFlags();
    private static final String usageText = NativeImage.getResource("/Usage.txt");
    final APIOptionHandler apiOptionHandler;
    final DefaultOptionHandler defaultOptionHandler;
    public static final String oH = "-H:";
    static final String oR = "-R:";
    final String enablePrintFlags = SubstrateOptions.PrintFlags.getName() + "=";
    final String oHClass = NativeImage.oH(NativeImageOptions.Class);
    final String oHName = NativeImage.oH(NativeImageOptions.Name);
    final String oHPath = NativeImage.oH(SubstrateOptions.Path);
    final String oHKind = NativeImage.oH(NativeImageOptions.Kind);
    final String oHCLibraryPath = NativeImage.oH(SubstrateOptions.CLibraryPath);
    final String oHOptimize = NativeImage.oH(SubstrateOptions.Optimize);
    final String oHFallbackThreshold = NativeImage.oH(FallbackFeature.Options.FallbackThreshold);
    final String oHSubstitutionFiles = NativeImage.oH(DeclarativeSubstitutionProcessor.Options.SubstitutionFiles);
    final String oHReflectionConfigurationFiles = NativeImage.oH(ReflectionFeature.Options.ReflectionConfigurationFiles);
    final String oHDynamicProxyConfigurationFiles = NativeImage.oH(DynamicProxyFeature.Options.DynamicProxyConfigurationFiles);
    final String oHJNIConfigurationFiles = NativeImage.oH(SubstrateOptions.JNIConfigurationFiles);
    final String oHMaxRuntimeCompileMethods = NativeImage.oH(GraalFeature.Options.MaxRuntimeCompileMethods);
    final String oHInspectServerContentPath = NativeImage.oH(PointstoOptions.InspectServerContentPath);
    static final String oXmx = "-Xmx";
    static final String oXms = "-Xms";
    private static final String pKeyNativeImageArgs = "NativeImageArgs";
    private final LinkedHashSet<String> imageBuilderArgs = new LinkedHashSet();
    private final LinkedHashSet<Path> imageBuilderClasspath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageBuilderBootClasspath = new LinkedHashSet();
    private final ArrayList<String> imageBuilderJavaArgs = new ArrayList();
    private final LinkedHashSet<Path> imageClasspath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageProvidedClasspath = new LinkedHashSet();
    private final ArrayList<String> customJavaArgs = new ArrayList();
    private final LinkedHashSet<String> customImageBuilderArgs = new LinkedHashSet();
    private final LinkedHashSet<Path> customImageClasspath = new LinkedHashSet();
    private final ArrayList<OptionHandler<? extends NativeImage>> optionHandlers = new ArrayList();
    protected final BuildConfiguration config;
    private final Map<String, String> userConfigProperties = new HashMap<String, String>();
    private final Map<String, String> propertyFileSubstitutionValues = new HashMap<String, String>();
    private boolean verbose = Boolean.valueOf(System.getenv("VERBOSE_GRAALVM_LAUNCHERS"));
    private boolean jarOptionMode = false;
    private boolean dryRun = false;
    private String queryOption = null;
    final MacroOption.Registry optionRegistry;
    private LinkedHashSet<MacroOption.EnabledOption> enabledLanguages;
    public static final String nativeImagePropertiesFilename = "native-image.properties";
    public static final String nativeImageMetaInf = "META-INF/native-image";
    private String effectiveMainClass;
    private String effectiveImageName;
    private Path effectiveImagePath;
    private LinkedHashSet<Path> effectiveImageClasspath;
    private LinkedHashSet<String> effectiveSystemProperties;
    private static String deletedFileSuffix = ".deleted";

    private static String getPlatform() {
        return (OS.getCurrent().className + "-" + SubstrateUtil.getArchitectureName()).toLowerCase();
    }

    private static Map<String, String[]> getCompilerFlags() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String versionTag : Arrays.asList("1.8", "11")) {
            result.put(versionTag, NativeImage.getResource("/graal-compiler-flags-" + versionTag + ".config").split("\n"));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getResource(String resourceName) {
        try (InputStream input = NativeImage.class.getResourceAsStream(resourceName);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String resourceString = reader.lines().collect(Collectors.joining("\n"));
            String string = resourceString.replace("%pathsep%", File.pathSeparator);
            return string;
        }
        catch (IOException e) {
            VMError.shouldNotReachHere((Throwable)e);
            return null;
        }
    }

    private static <T> String oH(OptionKey<T> option) {
        return oH + option.getName() + "=";
    }

    protected NativeImage(BuildConfiguration config) {
        this.config = config;
        String configFileEnvVarKey = "NATIVE_IMAGE_CONFIG_FILE";
        String configFile = System.getenv(configFileEnvVarKey);
        if (configFile != null && !configFile.isEmpty()) {
            try {
                this.userConfigProperties.putAll(NativeImage.loadProperties(this.canonicalize(Paths.get(configFile, new String[0]))));
            }
            catch (NativeImageError | Exception e) {
                NativeImage.showError("Invalid environment variable " + configFileEnvVarKey, e);
            }
        }
        this.addPlainImageBuilderArg(this.oHPath + config.getWorkingDirectory());
        this.optionRegistry = new MacroOption.Registry();
        this.defaultOptionHandler = new DefaultOptionHandler(this);
        this.registerOptionHandler(this.defaultOptionHandler);
        this.apiOptionHandler = new APIOptionHandler(this);
        this.registerOptionHandler(this.apiOptionHandler);
        this.registerOptionHandler(new MacroOptionHandler(this));
    }

    void addMacroOptionRoot(Path configDir) {
        this.optionRegistry.addMacroOptionRoot(this.canonicalize(configDir));
    }

    protected void registerOptionHandler(OptionHandler<? extends NativeImage> handler) {
        this.optionHandlers.add(handler);
    }

    protected Map<String, String> getUserConfigProperties() {
        return this.userConfigProperties;
    }

    protected Path getUserConfigDir() {
        String envVarKey = "NATIVE_IMAGE_USER_HOME";
        String userHomeStr = System.getenv(envVarKey);
        if (userHomeStr == null || userHomeStr.isEmpty()) {
            return Paths.get(System.getProperty("user.home"), ".native-image");
        }
        return Paths.get(userHomeStr, new String[0]);
    }

    protected static void ensureDirectoryExists(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw NativeImage.showError("File " + dir + " is not a directory");
            }
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw NativeImage.showError("Could not create directory " + dir);
            }
        }
    }

    private void prepareImageBuildArgs() {
        this.config.getBuilderJavaArgs().forEach(xva$0 -> this.addImageBuilderJavaArgs((String)xva$0));
        this.addImageBuilderJavaArgs("-Xss10m");
        this.addImageBuilderJavaArgs(oXms + this.getXmsValue());
        this.addImageBuilderJavaArgs(oXmx + this.getXmxValue(1));
        this.addImageBuilderJavaArgs("-Duser.country=US", "-Duser.language=en");
        this.addImageBuilderJavaArgs("-Dorg.graalvm.version=" + graalvmVersion);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.config=" + graalvmConfig);
        this.addImageBuilderJavaArgs("-Dcom.oracle.graalvm.isaot=true");
        this.config.getBuilderClasspath().forEach(this::addImageBuilderClasspath);
        this.config.getImageProvidedClasspath().forEach(this::addImageProvidedClasspath);
        String clibrariesBuilderArg = this.config.getBuilderCLibrariesPaths().stream().map(path -> this.canonicalize(path.resolve(platform)).toString()).collect(Collectors.joining(",", this.oHCLibraryPath, ""));
        this.addPlainImageBuilderArg(clibrariesBuilderArg);
        if (this.config.getBuilderInspectServerPath() != null) {
            this.addPlainImageBuilderArg(this.oHInspectServerContentPath + this.config.getBuilderInspectServerPath());
        }
        if (this.config.useJavaModules()) {
            String modulePath = this.config.getBuilderModulePath().stream().map(p -> this.canonicalize((Path)p).toString()).collect(Collectors.joining(File.pathSeparator));
            this.addImageBuilderJavaArgs(Arrays.asList("--module-path", modulePath));
            String upgradeModulePath = this.config.getBuilderUpgradeModulePath().stream().map(p -> this.canonicalize((Path)p).toString()).collect(Collectors.joining(File.pathSeparator));
            this.addImageBuilderJavaArgs(Arrays.asList("--upgrade-module-path", upgradeModulePath));
        } else {
            this.config.getBuilderJVMCIClasspath().forEach(this::addImageBuilderClasspath);
            if (!this.config.getBuilderJVMCIClasspathAppend().isEmpty()) {
                String builderJavaArg = this.config.getBuilderJVMCIClasspathAppend().stream().map(path -> this.canonicalize((Path)path).toString()).collect(Collectors.joining(File.pathSeparator, "-Djvmci.class.path.append=", ""));
                this.addImageBuilderJavaArgs(builderJavaArg);
            }
            this.config.getBuilderBootClasspath().forEach(this::addImageBuilderBootClasspath);
        }
        this.config.getImageClasspath().forEach(this::addCustomImageClasspath);
    }

    private void completeOptionArgs() {
        LinkedHashSet<MacroOption.EnabledOption> enabledOptions = this.optionRegistry.getEnabledOptions();
        if (!enabledOptions.isEmpty()) {
            this.addPlainImageBuilderArg(this.oHFallbackThreshold + 0);
        }
        this.enabledLanguages = this.optionRegistry.getEnabledOptions(MacroOption.MacroOptionKind.Language);
        if (this.enabledLanguages.size() > 1) {
            long baseMemRequirements = SubstrateOptionsParser.parseLong((String)"4g");
            long memRequirements = baseMemRequirements + (long)this.enabledLanguages.size() * SubstrateOptionsParser.parseLong((String)"1g");
            this.addImageBuilderJavaArgs(oXmx + memRequirements);
        }
        NativeImage.consolidateListArgs(this.imageBuilderJavaArgs, "-Dpolyglot.engine.PreinitializeContexts=", ",", Function.identity());
    }

    protected static String consolidateSingleValueArg(Collection<String> args, String argPrefix) {
        BiFunction<String, String, String> takeLast = (a, b) -> b;
        return NativeImage.consolidateArgs(args, argPrefix, Function.identity(), Function.identity(), () -> null, takeLast);
    }

    protected static boolean replaceArg(Collection<String> args, String argPrefix, String argSuffix) {
        boolean elementsRemoved = args.removeIf(arg -> arg.startsWith(argPrefix));
        args.add(argPrefix + argSuffix);
        return elementsRemoved;
    }

    private static <T> T consolidateArgs(Collection<String> args, String argPrefix, Function<String, T> fromSuffix, Function<T, String> toSuffix, Supplier<T> init, BiFunction<T, T, T> combiner) {
        Object consolidatedValue = null;
        boolean needsConsolidate = false;
        for (String arg : args) {
            if (!arg.startsWith(argPrefix)) continue;
            if (consolidatedValue == null) {
                consolidatedValue = init.get();
            } else {
                needsConsolidate = true;
            }
            consolidatedValue = combiner.apply(consolidatedValue, fromSuffix.apply(arg.substring(argPrefix.length())));
        }
        if (consolidatedValue != null && needsConsolidate) {
            NativeImage.replaceArg(args, argPrefix, toSuffix.apply(consolidatedValue));
        }
        return consolidatedValue;
    }

    private static LinkedHashSet<String> collectListArgs(Collection<String> args, String argPrefix, String delimiter) {
        LinkedHashSet<String> allEntries = new LinkedHashSet<String>();
        for (String arg : args) {
            String argEntriesRaw;
            if (!arg.startsWith(argPrefix) || (argEntriesRaw = arg.substring(argPrefix.length())).isEmpty()) continue;
            allEntries.addAll(Arrays.asList(argEntriesRaw.split(delimiter)));
        }
        return allEntries;
    }

    private static void consolidateListArgs(Collection<String> args, String argPrefix, String delimiter, Function<String, String> mapFunc) {
        LinkedHashSet<String> allEntries = NativeImage.collectListArgs(args, argPrefix, delimiter);
        if (!allEntries.isEmpty()) {
            NativeImage.replaceArg(args, argPrefix, allEntries.stream().map(mapFunc).collect(Collectors.joining(delimiter)));
        }
    }

    private void processClasspathNativeImageMetaInf(Path classpathEntry) {
        this.processClasspathNativeImageMetaInf(classpathEntry, this::processNativeImageMetaInf);
    }

    private void processClasspathNativeImageMetaInf(Path classpathEntry, NativeImageMetaInfResourceProcessor metaInfProcessor) {
        block19: {
            try {
                if (Files.isDirectory(classpathEntry, new LinkOption[0])) {
                    Path nativeImageMetaInfBase = classpathEntry.resolve(Paths.get(nativeImageMetaInf, new String[0]));
                    this.processNativeImageMetaInf(classpathEntry, nativeImageMetaInfBase, metaInfProcessor);
                    break block19;
                }
                List<Object> jarFileMatches = Collections.emptyList();
                if (classpathEntry.endsWith("$JavaCla$$pathWildcard$ubstitute$")) {
                    try {
                        jarFileMatches = Files.list(classpathEntry.getParent()).filter(p -> p.getFileName().toString().toLowerCase().endsWith(".jar")).collect(Collectors.toList());
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                } else if (Files.isReadable(classpathEntry)) {
                    jarFileMatches = Collections.singletonList(classpathEntry);
                }
                for (Path jarFile : jarFileMatches) {
                    URI jarFileURI = URI.create("jar:" + jarFile.toUri());
                    FileSystem jarFS = FileSystems.newFileSystem(jarFileURI, Collections.emptyMap());
                    Throwable throwable = null;
                    try {
                        Path nativeImageMetaInfBase = jarFS.getPath("/META-INF/native-image", new String[0]);
                        this.processNativeImageMetaInf(jarFile, nativeImageMetaInfBase, metaInfProcessor);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jarFS == null) continue;
                        if (throwable != null) {
                            try {
                                jarFS.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jarFS.close();
                    }
                }
            }
            catch (IOException | FileSystemNotFoundException e) {
                throw NativeImage.showError("Invalid classpath entry " + ImageClassLoader.classpathToString((Path)classpathEntry), e);
            }
        }
    }

    private void processNativeImageMetaInf(Path classpathEntry, Path nativeImageMetaInfBase, NativeImageMetaInfResourceProcessor metaInfProcessor) throws IOException {
        if (Files.isDirectory(nativeImageMetaInfBase, new LinkOption[0])) {
            for (MetaInfFileType fileType : MetaInfFileType.values()) {
                List nativeImageMetaInfFiles = Files.walk(nativeImageMetaInfBase, new FileVisitOption[0]).filter(p -> p.endsWith(fileType.fileName)).collect(Collectors.toList());
                for (Path nativeImageMetaInfFile : nativeImageMetaInfFiles) {
                    Path resourceRoot = nativeImageMetaInfBase.getParent().getParent();
                    Function<String, String> resolver = str -> {
                        Path componentDirectory = resourceRoot.relativize(nativeImageMetaInfFile).getParent();
                        int nameCount = componentDirectory.getNameCount();
                        String optionArg = null;
                        if (nameCount > 2) {
                            String optionArgKey = componentDirectory.subpath(2, nameCount).toString();
                            optionArg = this.propertyFileSubstitutionValues.get(optionArgKey);
                        }
                        return NativeImage.resolvePropertyValue(str, optionArg, componentDirectory.toString());
                    };
                    this.showVerboseMessage(this.isVerbose(), "Apply " + nativeImageMetaInfFile.toUri());
                    try {
                        metaInfProcessor.processMetaInfResource(classpathEntry, resourceRoot, nativeImageMetaInfFile, fileType, resolver);
                    }
                    catch (NativeImageError err) {
                        NativeImage.showError("Processing " + nativeImageMetaInfFile.toUri() + " failed", err);
                    }
                }
            }
        }
    }

    private void processNativeImageMetaInf(Path classpathEntry, Path resourceRoot, Path resourcePath, MetaInfFileType resourceType, Function<String, String> resolver) throws IOException {
        NativeImageArgsProcessor args = new NativeImageArgsProcessor();
        if (resourceType == MetaInfFileType.Properties) {
            Map<String, String> properties = NativeImage.loadProperties(Files.newInputStream(resourcePath, new OpenOption[0]));
            String imageName = properties.get("ImageName");
            if (imageName != null) {
                this.addCustomImageBuilderArgs(this.oHName + resolver.apply(imageName));
            }
            NativeImage.forEachPropertyValue(properties.get("JavaArgs"), xva$0 -> this.addImageBuilderJavaArgs((String)xva$0), resolver);
            NativeImage.forEachPropertyValue(properties.get("Args"), args, resolver);
        } else {
            args.accept(NativeImage.oH(resourceType.optionKey) + resourceRoot.relativize(resourcePath));
        }
        args.apply();
    }

    private int completeImageBuild() {
        Path imagePath;
        List<String> leftoverArgs = this.processNativeImageArgs();
        this.completeOptionArgs();
        if (this.queryOption != null) {
            this.addPlainImageBuilderArg(oH + this.enablePrintFlags + this.queryOption);
            this.addPlainImageBuilderArg(oR + this.enablePrintFlags + this.queryOption);
        }
        if (this.customImageClasspath.isEmpty() && this.queryOption == null) {
            this.addImageProvidedClasspath(Paths.get(".", new String[0]));
        } else {
            this.imageClasspath.addAll(this.customImageClasspath);
        }
        Long xmxValue = NativeImage.consolidateArgs(this.imageBuilderJavaArgs, oXmx, SubstrateOptionsParser::parseLong, String::valueOf, () -> 0L, Math::max);
        Long xmsValue = NativeImage.consolidateArgs(this.imageBuilderJavaArgs, oXms, SubstrateOptionsParser::parseLong, String::valueOf, () -> SubstrateOptionsParser.parseLong((String)this.getXmsValue()), Math::max);
        if (Long.compareUnsigned(xmsValue, xmxValue) > 0) {
            NativeImage.replaceArg(this.imageBuilderJavaArgs, oXms, Long.toUnsignedString(xmxValue));
        }
        this.addImageBuilderJavaArgs(this.customJavaArgs.toArray(new String[0]));
        Function<String, String> canonicalizedPathStr = s -> this.canonicalize(Paths.get(s, new String[0])).toString();
        NativeImage.consolidateArgs(this.imageBuilderArgs, this.oHMaxRuntimeCompileMethods, Integer::parseInt, String::valueOf, () -> 0, Integer::sum);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHCLibraryPath, ",", canonicalizedPathStr);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHSubstitutionFiles, ",", canonicalizedPathStr);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHReflectionConfigurationFiles, ",", canonicalizedPathStr);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHDynamicProxyConfigurationFiles, ",", canonicalizedPathStr);
        NativeImage.consolidateListArgs(this.imageBuilderArgs, this.oHJNIConfigurationFiles, ",", canonicalizedPathStr);
        BiFunction<String, String, String> takeLast = (a, b) -> b;
        String imagePathStr = NativeImage.consolidateArgs(this.imageBuilderArgs, this.oHPath, Function.identity(), canonicalizedPathStr, () -> null, takeLast);
        try {
            imagePath = this.canonicalize(Paths.get(imagePathStr, new String[0]));
        }
        catch (NativeImageError | InvalidPathException e) {
            throw NativeImage.showError("The given " + this.oHPath + imagePathStr + " argument does not specify a valid path", e);
        }
        NativeImage.consolidateArgs(this.imageBuilderArgs, this.oHName, Function.identity(), Function.identity(), () -> null, takeLast);
        String mainClass = NativeImage.consolidateSingleValueArg(this.imageBuilderArgs, this.oHClass);
        String imageKind = NativeImage.consolidateSingleValueArg(this.imageBuilderArgs, this.oHKind);
        boolean buildExecutable = !AbstractBootImage.NativeImageKind.SHARED_LIBRARY.name().equals(imageKind);
        boolean printFlags = this.imageBuilderArgs.stream().anyMatch(arg -> arg.contains(this.enablePrintFlags));
        if (!printFlags) {
            ArrayList<String> extraImageArgs = new ArrayList<String>();
            ListIterator<String> leftoverArgsItr = leftoverArgs.listIterator();
            while (leftoverArgsItr.hasNext()) {
                String leftoverArg = leftoverArgsItr.next();
                if (leftoverArg.startsWith("-")) continue;
                leftoverArgsItr.remove();
                extraImageArgs.add(leftoverArg);
            }
            if (!this.jarOptionMode) {
                boolean explicitMainClass = this.customImageBuilderArgs.stream().anyMatch(arg -> arg.startsWith(this.oHClass));
                if (extraImageArgs.isEmpty()) {
                    if (buildExecutable && (mainClass == null || mainClass.isEmpty())) {
                        NativeImage.showError("Please specify class containing the main entry point method. (see --help)");
                    }
                } else {
                    explicitMainClass = true;
                    mainClass = (String)extraImageArgs.remove(0);
                    NativeImage.replaceArg(this.imageBuilderArgs, this.oHClass, mainClass);
                }
                if (extraImageArgs.isEmpty()) {
                    if (this.customImageBuilderArgs.stream().noneMatch(arg -> arg.startsWith(this.oHName))) {
                        if (explicitMainClass) {
                            NativeImage.replaceArg(this.imageBuilderArgs, this.oHName, mainClass.toLowerCase());
                        } else if (this.imageBuilderArgs.stream().noneMatch(arg -> arg.startsWith(this.oHName))) {
                            throw NativeImage.showError("Missing image-name. Use " + this.oHName + "<imagename> to provide one.");
                        }
                    }
                } else {
                    NativeImage.replaceArg(this.imageBuilderArgs, this.oHName, (String)extraImageArgs.remove(0));
                }
            } else if (!extraImageArgs.isEmpty()) {
                NativeImage.replaceArg(this.imageBuilderArgs, this.oHName, (String)extraImageArgs.remove(0));
            }
            if (!extraImageArgs.isEmpty()) {
                String prefix = "Unknown argument" + (extraImageArgs.size() == 1 ? ": " : "s: ");
                NativeImage.showError(extraImageArgs.stream().collect(Collectors.joining(", ", prefix, "")));
            }
        }
        if (!leftoverArgs.isEmpty()) {
            String prefix = "Unrecognized option" + (leftoverArgs.size() == 1 ? ": " : "s: ");
            NativeImage.showError(leftoverArgs.stream().collect(Collectors.joining(", ", prefix, "")));
        }
        this.effectiveMainClass = NativeImage.consolidateSingleValueArg(this.imageBuilderArgs, this.oHClass);
        this.effectiveImageName = NativeImage.consolidateSingleValueArg(this.imageBuilderArgs, this.oHName);
        this.effectiveImagePath = imagePath;
        this.effectiveImageClasspath = new LinkedHashSet<Path>(this.imageClasspath);
        this.effectiveSystemProperties = this.customJavaArgs.stream().filter(s -> s.startsWith("-D")).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<Path> finalImageClasspath = new LinkedHashSet<Path>(this.imageBuilderBootClasspath);
        finalImageClasspath.addAll(this.imageBuilderClasspath);
        finalImageClasspath.addAll(this.imageProvidedClasspath);
        finalImageClasspath.addAll(this.effectiveImageClasspath);
        return this.buildImage(this.imageBuilderJavaArgs, this.imageBuilderBootClasspath, this.imageBuilderClasspath, this.imageBuilderArgs, finalImageClasspath);
    }

    protected static List<String> createImageBuilderArgs(LinkedHashSet<String> imageArgs, LinkedHashSet<Path> imagecp) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-imagecp");
        result.add(imagecp.stream().map(ImageClassLoader::classpathToString).collect(Collectors.joining(File.pathSeparator)));
        result.addAll(imageArgs);
        return result;
    }

    protected int buildImage(List<String> javaArgs, LinkedHashSet<Path> bcp, LinkedHashSet<Path> cp, LinkedHashSet<String> imageArgs, LinkedHashSet<Path> imagecp) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        List<String> command = pb.command();
        command.add(this.canonicalize(this.config.getJavaExecutable()).toString());
        command.addAll(javaArgs);
        if (!bcp.isEmpty()) {
            command.add(bcp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator, "-Xbootclasspath/a:", "")));
        }
        command.addAll(Arrays.asList("-cp", cp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator))));
        command.add("com.oracle.svm.hosted.NativeImageGeneratorRunner");
        if (IS_AOT && OS.getCurrent().hasProcFS) {
            command.addAll(Arrays.asList("-watchpid", "" + ProcessProperties.getProcessID()));
        }
        command.addAll(NativeImage.createImageBuilderArgs(imageArgs, imagecp));
        this.showVerboseMessage(this.isVerbose() || this.dryRun, "Executing [");
        this.showVerboseMessage(this.isVerbose() || this.dryRun, command.stream().collect(Collectors.joining(" \\\n")));
        this.showVerboseMessage(this.isVerbose() || this.dryRun, "]");
        if (this.dryRun) {
            return 0;
        }
        int exitStatus = 1;
        try {
            Process p = pb.inheritIO().start();
            exitStatus = p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw NativeImage.showError(e.getMessage());
        }
        return exitStatus;
    }

    public static void main(String[] args) {
        try {
            NativeImage.build(new DefaultBuildConfiguration(args));
        }
        catch (NativeImageError e) {
            boolean verbose = Boolean.valueOf(System.getenv("VERBOSE_GRAALVM_LAUNCHERS"));
            NativeImage.show(System.err::println, "Error: " + e.getMessage());
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                NativeImage.show(System.err::println, "Caused by: " + cause);
            }
            if (verbose) {
                e.printStackTrace();
            }
            System.exit(1);
        }
    }

    public static Map<Path, List<String>> extractEmbeddedImageArgs(final Path workDir, String[] imageClasspath) {
        NativeImage nativeImage = new NativeImage(new BuildConfiguration(){

            @Override
            public Path getWorkingDirectory() {
                return workDir;
            }
        });
        HashMap<Path, List<String>> extractionResults = new HashMap<Path, List<String>>();
        NativeImageMetaInfResourceProcessor extractor = (classpathEntry, resourceRoot, resourcePath, resourceType, resolver) -> {
            nativeImage.imageBuilderArgs.clear();
            NativeImageArgsProcessor args = nativeImage.new NativeImageArgsProcessor();
            if (resourceType == MetaInfFileType.Properties) {
                Map<String, String> properties = NativeImage.loadProperties(Files.newInputStream(resourcePath, new OpenOption[0]));
                NativeImage.forEachPropertyValue(properties.get("Args"), args, resolver);
                args.apply();
            } else {
                args.accept(NativeImage.oH(resourceType.optionKey) + resourceRoot.relativize(resourcePath));
                args.apply();
            }
            extractionResults.put(classpathEntry, new ArrayList<String>(nativeImage.imageBuilderArgs));
        };
        for (String entry : imageClasspath) {
            Path classpathEntry2 = nativeImage.canonicalize(ImageClassLoader.stringToClasspath((String)entry), false);
            nativeImage.processClasspathNativeImageMetaInf(classpathEntry2, extractor);
        }
        return extractionResults;
    }

    public static void build(BuildConfiguration config) {
        NativeImage nativeImage;
        NativeImage nativeImage2 = nativeImage = IS_AOT ? NativeImageServer.create(config) : new NativeImage(config);
        if (config.getBuildArgs().isEmpty()) {
            nativeImage.showMessage(usageText);
        } else {
            nativeImage.prepareImageBuildArgs();
            int buildStatus = nativeImage.completeImageBuild();
            if (buildStatus == 2) {
                NativeImage.build(FallbackBuildConfiguration.create(nativeImage));
                NativeImage.showWarning("Image '" + nativeImage.effectiveImageName + "' is a fallback image that requires a JDK for execution (use --no-fallback to suppress fallback image generation).");
            } else if (buildStatus != 0) {
                throw NativeImage.showError("Image build request failed with exit status " + buildStatus);
            }
        }
    }

    Path canonicalize(Path path) {
        return this.canonicalize(path, true);
    }

    Path canonicalize(Path path, boolean strict) {
        Path absolutePath;
        Path path2 = absolutePath = path.isAbsolute() ? path : this.config.getWorkingDirectory().resolve(path);
        if (!strict) {
            return absolutePath;
        }
        boolean hasWildcard = absolutePath.endsWith("$JavaCla$$pathWildcard$ubstitute$");
        if (hasWildcard) {
            absolutePath = absolutePath.getParent();
        }
        try {
            Path realPath = absolutePath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            if (!Files.isReadable(realPath)) {
                NativeImage.showError("Path entry " + ImageClassLoader.classpathToString((Path)path) + " is not readable");
            }
            if (hasWildcard) {
                if (!Files.isDirectory(realPath, new LinkOption[0])) {
                    NativeImage.showError("Path entry with wildcard " + ImageClassLoader.classpathToString((Path)path) + " is not a directory");
                }
                realPath = realPath.resolve("$JavaCla$$pathWildcard$ubstitute$");
            }
            return realPath;
        }
        catch (IOException e) {
            throw NativeImage.showError("Invalid Path entry " + ImageClassLoader.classpathToString((Path)path), e);
        }
    }

    void addImageBuilderClasspath(Path classpath) {
        this.imageBuilderClasspath.add(this.canonicalize(classpath));
    }

    void addImageBuilderBootClasspath(Path classpath) {
        this.imageBuilderBootClasspath.add(this.canonicalize(classpath));
    }

    void addImageBuilderJavaArgs(String ... javaArgs) {
        this.addImageBuilderJavaArgs(Arrays.asList(javaArgs));
    }

    void addImageBuilderJavaArgs(Collection<String> javaArgs) {
        this.imageBuilderJavaArgs.addAll(javaArgs);
    }

    void addPlainImageBuilderArg(String plainArg) {
        assert (plainArg.startsWith(oH) || plainArg.startsWith(oR));
        this.imageBuilderArgs.remove(plainArg);
        this.imageBuilderArgs.add(plainArg);
    }

    void addImageClasspath(Path classpath) {
        Path classpathEntry = this.canonicalize(classpath);
        this.processClasspathNativeImageMetaInf(classpathEntry);
        this.imageClasspath.add(classpathEntry);
    }

    void addImageProvidedClasspath(Path classpath) {
        Path classpathEntry = this.canonicalize(classpath);
        this.processClasspathNativeImageMetaInf(classpathEntry);
        this.imageProvidedClasspath.add(classpathEntry);
    }

    void addCustomImageClasspath(String classpath) {
        this.addCustomImageClasspath(ImageClassLoader.stringToClasspath((String)classpath));
    }

    void addCustomImageClasspath(Path classpath) {
        Path classpathEntry;
        try {
            classpathEntry = this.canonicalize(classpath);
            this.processClasspathNativeImageMetaInf(classpathEntry);
        }
        catch (NativeImageError e) {
            if (this.isVerbose()) {
                NativeImage.showWarning("Invalid classpath entry: " + classpath);
            }
            classpathEntry = this.canonicalize(classpath, false);
        }
        this.customImageClasspath.add(classpathEntry);
    }

    void addCustomJavaArgs(String javaArg) {
        this.customJavaArgs.add(javaArg);
    }

    void addCustomImageBuilderArgs(String plainArg) {
        this.addPlainImageBuilderArg(plainArg);
        this.customImageBuilderArgs.add(plainArg);
    }

    void setVerbose(boolean val) {
        this.verbose = val;
    }

    void setJarOptionMode(boolean val) {
        this.jarOptionMode = val;
    }

    boolean isVerbose() {
        return this.verbose;
    }

    protected void setDryRun(boolean val) {
        this.dryRun = val;
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    public void setQueryOption(String val) {
        this.queryOption = val;
    }

    void showVerboseMessage(boolean show, String message) {
        if (show) {
            NativeImage.show(System.out::println, message);
        }
    }

    void showMessage(String message) {
        NativeImage.show(System.out::println, message);
    }

    void showNewline() {
        System.out.println();
    }

    void showMessagePart(String message) {
        NativeImage.show(s -> {
            System.out.print((String)s);
            System.out.flush();
        }, message);
    }

    public static void showWarning(String message) {
        NativeImage.show(System.err::println, "Warning: " + message);
    }

    public static Error showError(String message) {
        throw new NativeImageError(message);
    }

    public static Error showError(String message, Throwable cause) {
        throw new NativeImageError(message, cause);
    }

    private static void show(Consumer<String> printFunc, String message) {
        printFunc.accept(message);
    }

    static List<Path> getJars(Path dir, String ... jarBaseNames) {
        try {
            return Files.list(dir).filter(p -> {
                String jarFileName = p.getFileName().toString();
                String jarSuffix = ".jar";
                if (!jarFileName.toLowerCase().endsWith(jarSuffix)) {
                    return false;
                }
                List<String> baseNameList = Arrays.asList(jarBaseNames);
                if (baseNameList.isEmpty()) {
                    return true;
                }
                String jarBaseName = jarFileName.substring(0, jarFileName.length() - jarSuffix.length());
                return baseNameList.contains(jarBaseName);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw NativeImage.showError("Unable to use jar-files from directory " + dir, e);
        }
    }

    private List<String> processNativeImageArgs() {
        ArrayList<String> leftoverArgs = new ArrayList<String>();
        ArrayDeque<String> arguments = new ArrayDeque<String>();
        String defaultNativeImageArgs = this.getUserConfigProperties().get(pKeyNativeImageArgs);
        if (defaultNativeImageArgs != null && !defaultNativeImageArgs.isEmpty()) {
            arguments.addAll(Arrays.asList(defaultNativeImageArgs.split(" ")));
        }
        arguments.addAll(this.config.getBuildArgs());
        while (!arguments.isEmpty()) {
            boolean consumed = false;
            for (int index = this.optionHandlers.size() - 1; index >= 0; --index) {
                OptionHandler<? extends NativeImage> handler = this.optionHandlers.get(index);
                int numArgs = arguments.size();
                if (!handler.consume(arguments)) continue;
                assert (arguments.size() < numArgs) : "OptionHandler pretends to consume argument(s) but isn't: " + handler.getClass().getName();
                consumed = true;
                break;
            }
            if (consumed) continue;
            leftoverArgs.add((String)arguments.poll());
        }
        return leftoverArgs;
    }

    protected String getXmsValue() {
        return "1g";
    }

    private static long getPhysicalMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        long totalPhysicalMemorySize = ((com.sun.management.OperatingSystemMXBean)osMXBean).getTotalPhysicalMemorySize();
        return totalPhysicalMemorySize;
    }

    protected String getXmxValue(int maxInstances) {
        Long memMax = Long.divideUnsigned(Long.divideUnsigned(NativeImage.getPhysicalMemorySize(), 10L) * 8L, maxInstances);
        String maxXmx = "14g";
        if (Long.compareUnsigned(memMax, SubstrateOptionsParser.parseLong((String)maxXmx)) >= 0) {
            return maxXmx;
        }
        return Long.toUnsignedString(memMax);
    }

    static Map<String, String> loadProperties(Path propertiesPath) {
        if (Files.isReadable(propertiesPath)) {
            try {
                return NativeImage.loadProperties(Files.newInputStream(propertiesPath, new OpenOption[0]));
            }
            catch (IOException e) {
                throw NativeImage.showError("Could not read properties-file: " + propertiesPath, e);
            }
        }
        return Collections.emptyMap();
    }

    static Map<String, String> loadProperties(InputStream propertiesInputStream) {
        Properties properties = new Properties();
        try {
            InputStream input = propertiesInputStream;
            Object object = null;
            try {
                properties.load(input);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (input != null) {
                    if (object != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
        catch (IOException e) {
            NativeImage.showError("Could not read properties", e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return Collections.unmodifiableMap(map);
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver) {
        return NativeImage.forEachPropertyValue(propertyValue, target, resolver, " ");
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver, String separatorRegex) {
        if (propertyValue != null) {
            for (String propertyValuePart : propertyValue.split(separatorRegex)) {
                target.accept(resolver.apply(propertyValuePart));
            }
            return true;
        }
        return false;
    }

    public void addOptionKeyValue(String key, String value) {
        this.propertyFileSubstitutionValues.put(key, value);
    }

    static String resolvePropertyValue(String val, String optionArg, String componentDirectory) {
        String resultVal = val;
        if (optionArg != null) {
            resultVal = NativeImage.safeSubstitution(resultVal, "${*}", optionArg);
            for (String argNameValue : optionArg.split(",")) {
                String[] splitted = argNameValue.split(":");
                if (splitted.length != 2) continue;
                String argName = splitted[0];
                String argValue = splitted[1];
                if (argName.isEmpty()) continue;
                resultVal = NativeImage.safeSubstitution(resultVal, "${" + argName + "}", argValue);
            }
        }
        resultVal = NativeImage.safeSubstitution(resultVal, "${.}", componentDirectory);
        return resultVal;
    }

    private static String safeSubstitution(String source, CharSequence target, CharSequence replacement) {
        if (replacement == null && source.contains(target)) {
            throw NativeImage.showError("Unable to provide meaningful substitution for \"" + target + "\" in " + source);
        }
        return source.replace(target, replacement);
    }

    protected static boolean isDeletedPath(Path toDelete) {
        return toDelete.getFileName().toString().endsWith(deletedFileSuffix);
    }

    protected void deleteAllFiles(Path toDelete) {
        block3: {
            try {
                Path deletedPath = toDelete;
                if (!NativeImage.isDeletedPath(deletedPath)) {
                    deletedPath = toDelete.resolveSibling(toDelete.getFileName() + deletedFileSuffix);
                    Files.move(toDelete, deletedPath, new CopyOption[0]);
                }
                Files.walk(deletedPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                if (!this.isVerbose()) break block3;
                this.showMessage("Could not recursively delete path: " + toDelete);
                e.printStackTrace();
            }
        }
    }

    public static final class NativeImageError
    extends Error {
        private NativeImageError(String message) {
            super(message);
        }

        private NativeImageError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    class NativeImageArgsProcessor
    implements Consumer<String> {
        ArrayDeque<String> args = new ArrayDeque();

        NativeImageArgsProcessor() {
        }

        @Override
        public void accept(String arg) {
            this.args.add(arg);
        }

        void apply() {
            while (!this.args.isEmpty()) {
                boolean consumed = false;
                consumed = consumed || NativeImage.this.apiOptionHandler.consume(this.args);
                if (consumed = consumed || NativeImage.this.defaultOptionHandler.consume(this.args)) continue;
                NativeImage.showError("Property 'Args' contains invalid entry '" + this.args.peek() + "'");
            }
        }
    }

    static interface NativeImageMetaInfResourceProcessor {
        public void processMetaInfResource(Path var1, Path var2, Path var3, MetaInfFileType var4, Function<String, String> var5) throws IOException;
    }

    static enum MetaInfFileType {
        Properties(null, "native-image.properties"),
        JniConfiguration((OptionKey<?>)SubstrateOptions.JNIConfigurationResources, "jni-config.json"),
        ReflectConfiguration((OptionKey<?>)ReflectionFeature.Options.ReflectionConfigurationResources, "reflect-config.json"),
        ResourceConfiguration((OptionKey<?>)ResourcesFeature.Options.ResourceConfigurationResources, "resource-config.json"),
        ProxyConfiguration((OptionKey<?>)DynamicProxyFeature.Options.DynamicProxyConfigurationResources, "proxy-config.json");

        final OptionKey<?> optionKey;
        final String fileName;

        private MetaInfFileType(OptionKey<?> optionKey, String fileName) {
            this.optionKey = optionKey;
            this.fileName = fileName;
        }
    }

    private static final class FallbackBuildConfiguration
    implements InvocationHandler {
        private final NativeImage original;
        private final ArrayList<String> buildArgs;

        private FallbackBuildConfiguration(NativeImage original) {
            this.original = original;
            this.buildArgs = new ArrayList();
            for (String property : original.effectiveSystemProperties) {
                this.buildArgs.add(NativeImage.oH((OptionKey)FallbackExecutor.Options.FallbackExecutorSystemProperty) + property);
            }
            this.buildArgs.add("-H:+" + SubstrateOptions.ParseRuntimeOptions.getName());
            String classpathString = original.effectiveImageClasspath.stream().map(original.effectiveImagePath::relativize).map(ImageClassLoader::classpathToString).collect(Collectors.joining(File.pathSeparator));
            this.buildArgs.add(original.oHPath + original.effectiveImagePath.toString());
            this.buildArgs.add(NativeImage.oH((OptionKey)FallbackExecutor.Options.FallbackExecutorClasspath) + classpathString);
            this.buildArgs.add(NativeImage.oH((OptionKey)FallbackExecutor.Options.FallbackExecutorMainClass) + original.effectiveMainClass);
            this.buildArgs.add(FallbackExecutor.class.getName());
            this.buildArgs.add(original.effectiveImageName);
        }

        static BuildConfiguration create(NativeImage imageName) {
            FallbackBuildConfiguration handler = new FallbackBuildConfiguration(imageName);
            BuildConfiguration fallback = (BuildConfiguration)Proxy.newProxyInstance(BuildConfiguration.class.getClassLoader(), new Class[]{BuildConfiguration.class}, (InvocationHandler)handler);
            return fallback;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getImageClasspath": {
                    return Collections.emptyList();
                }
                case "getBuildArgs": {
                    return this.buildArgs;
                }
            }
            return method.invoke((Object)this.original.config, args);
        }
    }

    private static class DefaultBuildConfiguration
    implements BuildConfiguration {
        private final Path workDir;
        private final Path rootDir;
        private final String[] args;

        DefaultBuildConfiguration(String[] args) {
            this.args = args;
            this.workDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
            if (IS_AOT) {
                Path executablePath = Paths.get(ProcessProperties.getExecutableName(), new String[0]);
                assert (executablePath != null);
                Path binDir = executablePath.getParent();
                Path rootDirCandidate = binDir.getParent();
                if (rootDirCandidate.endsWith(platform)) {
                    rootDirCandidate = rootDirCandidate.getParent();
                }
                if (rootDirCandidate.endsWith(Paths.get("lib", "svm"))) {
                    rootDirCandidate = rootDirCandidate.getParent().getParent();
                }
                this.rootDir = rootDirCandidate;
            } else {
                String rootDirProperty = "native-image.root";
                String rootDirString = System.getProperty(rootDirProperty);
                if (rootDirString == null) {
                    rootDirString = System.getProperty("java.home");
                }
                this.rootDir = Paths.get(rootDirString, new String[0]);
            }
        }

        @Override
        public Path getWorkingDirectory() {
            return this.workDir;
        }

        @Override
        public Path getJavaExecutable() {
            Path javaHomePath = this.rootDir.getParent();
            Path binJava = Paths.get("bin", OS.getCurrent() == OS.WINDOWS ? "java.exe" : "java");
            if (Files.isExecutable(javaHomePath.resolve(binJava))) {
                return javaHomePath.resolve(binJava);
            }
            String javaHome = System.getenv("JAVA_HOME");
            if (javaHome == null) {
                throw NativeImage.showError("Environment variable JAVA_HOME is not set");
            }
            javaHomePath = Paths.get(javaHome, new String[0]);
            if (!Files.isExecutable(javaHomePath.resolve(binJava))) {
                throw NativeImage.showError("Environment variable JAVA_HOME does not refer to a directory with a " + binJava + " executable");
            }
            return javaHomePath.resolve(binJava);
        }

        @Override
        public List<Path> getBuilderClasspath() {
            ArrayList<Path> result = new ArrayList<Path>();
            if (this.useJavaModules()) {
                result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), "graal-sdk", "graal", "enterprise-graal"));
            }
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm", "builder")), new String[0]));
            return result;
        }

        @Override
        public List<Path> getBuilderCLibrariesPaths() {
            return Collections.singletonList(this.rootDir.resolve(Paths.get("lib", "svm", "clibraries")));
        }

        @Override
        public List<Path> getImageProvidedClasspath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm")), new String[0]);
        }

        @Override
        public Path getBuilderInspectServerPath() {
            Path inspectPath = this.rootDir.resolve(Paths.get("lib", "svm", "inspect"));
            if (Files.isDirectory(inspectPath, new LinkOption[0])) {
                return inspectPath;
            }
            return null;
        }

        @Override
        public List<Path> getBuilderJVMCIClasspath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), new String[0]);
        }

        @Override
        public List<Path> getBuilderJVMCIClasspathAppend() {
            return this.getBuilderJVMCIClasspath().stream().filter(f -> f.getFileName().toString().toLowerCase().endsWith("graal.jar")).collect(Collectors.toList());
        }

        @Override
        public List<Path> getBuilderBootClasspath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "boot")), new String[0]);
        }

        @Override
        public List<Path> getBuilderModulePath() {
            ArrayList<Path> result = new ArrayList<Path>();
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), "graal-sdk", "enterprise-graal"));
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "truffle")), "truffle-api"));
            return result;
        }

        @Override
        public List<Path> getBuilderUpgradeModulePath() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "jvmci")), "graal");
        }

        @Override
        public List<Path> getImageClasspath() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getBuildArgs() {
            if (this.args.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> buildArgs = new ArrayList<String>();
            buildArgs.addAll(Arrays.asList("--configurations-path", this.rootDir.toString()));
            buildArgs.addAll(Arrays.asList("--configurations-path", this.rootDir.resolve(Paths.get("lib", "svm")).toString()));
            buildArgs.addAll(Arrays.asList(this.args));
            return buildArgs;
        }
    }

    public static interface BuildConfiguration {
        public Path getWorkingDirectory();

        default public Path getJavaExecutable() {
            throw VMError.unimplemented();
        }

        default public boolean useJavaModules() {
            try {
                Class.forName("java.lang.Module");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        }

        default public List<Path> getBuilderClasspath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderCLibrariesPaths() {
            throw VMError.unimplemented();
        }

        default public Path getBuilderInspectServerPath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getImageProvidedClasspath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderJVMCIClasspath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderJVMCIClasspathAppend() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderBootClasspath() {
            throw VMError.unimplemented();
        }

        default public List<String> getBuilderJavaArgs() {
            String javaVersion = System.getProperty("java.version");
            javaVersion = javaVersion.startsWith("1.") ? javaVersion.substring(0, 3) : (javaVersion.contains("-") ? javaVersion.split("-")[0] : javaVersion.split("\\.", 2)[0]);
            String[] flagsForVersion = graalCompilerFlags.get(javaVersion);
            if (flagsForVersion == null) {
                NativeImage.showError("Image building not supported for Java version " + javaVersion);
            }
            return Arrays.asList(flagsForVersion);
        }

        default public List<Path> getBuilderModulePath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getBuilderUpgradeModulePath() {
            throw VMError.unimplemented();
        }

        default public List<Path> getImageClasspath() {
            throw VMError.unimplemented();
        }

        default public List<String> getBuildArgs() {
            throw VMError.unimplemented();
        }
    }

    static abstract class OptionHandler<T extends NativeImage> {
        protected final T nativeImage;

        OptionHandler(T nativeImage) {
            this.nativeImage = nativeImage;
        }

        abstract boolean consume(Queue<String> var1);
    }
}

