/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.hosted.ImageClassLoader;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Queue;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.graalvm.compiler.options.OptionType;

class DefaultOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    static final String helpText = NativeImage.getResource("/Help.txt");
    static final String helpExtraText = NativeImage.getResource("/HelpExtra.txt");
    boolean useDebugAttach = false;

    DefaultOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
    }

    @Override
    public boolean consume(Queue<String> args) {
        String headArg;
        switch (headArg = args.peek()) {
            case "--help": {
                args.poll();
                this.nativeImage.showMessage(helpText);
                this.nativeImage.showNewline();
                this.nativeImage.apiOptionHandler.printOptions(this.nativeImage::showMessage);
                this.nativeImage.showNewline();
                this.nativeImage.optionRegistry.showOptions(null, true, this.nativeImage::showMessage);
                this.nativeImage.showNewline();
                System.exit(0);
                return true;
            }
            case "--version": {
                args.poll();
                String message = "GraalVM Version " + NativeImage.graalvmVersion;
                if (!NativeImage.graalvmConfig.isEmpty()) {
                    message = message + " " + NativeImage.graalvmConfig;
                }
                this.nativeImage.showMessage(message);
                System.exit(0);
                return true;
            }
            case "--help-extra": {
                args.poll();
                this.nativeImage.showMessage(helpExtraText);
                this.nativeImage.optionRegistry.showOptions(MacroOption.MacroOptionKind.Macro, true, this.nativeImage::showMessage);
                System.exit(0);
                return true;
            }
            case "-cp": 
            case "-classpath": 
            case "--class-path": {
                args.poll();
                String cpArgs = args.poll();
                if (cpArgs == null) {
                    NativeImage.showError(headArg + " requires class path specification");
                }
                for (String cp : cpArgs.split(File.pathSeparator, Integer.MAX_VALUE)) {
                    String cpEntry = cp.isEmpty() ? "." : cp;
                    this.nativeImage.addCustomImageClasspath(cpEntry);
                }
                return true;
            }
            case "--configurations-path": {
                args.poll();
                String configPath = args.poll();
                if (configPath == null) {
                    NativeImage.showError(headArg + " requires a " + File.pathSeparator + " separated list of directories");
                }
                for (String configDir : configPath.split(File.pathSeparator)) {
                    this.nativeImage.addMacroOptionRoot(this.nativeImage.canonicalize(Paths.get(configDir, new String[0])));
                }
                return true;
            }
            case "-jar": {
                args.poll();
                String jarFilePathStr = args.poll();
                if (jarFilePathStr == null) {
                    NativeImage.showError("-jar requires jar file specification");
                }
                this.handleJarFileArg(this.nativeImage.canonicalize(Paths.get(jarFilePathStr, new String[0])));
                this.nativeImage.setJarOptionMode(true);
                return true;
            }
            case "--verbose": {
                args.poll();
                this.nativeImage.setVerbose(true);
                return true;
            }
            case "--dry-run": {
                args.poll();
                this.nativeImage.setDryRun(true);
                return true;
            }
            case "--expert-options": {
                args.poll();
                this.nativeImage.setQueryOption(OptionType.User.name());
                return true;
            }
            case "--expert-options-all": {
                args.poll();
                this.nativeImage.setQueryOption("");
                return true;
            }
        }
        String debugAttach = "--debug-attach";
        if (headArg.startsWith(debugAttach)) {
            if (this.useDebugAttach) {
                throw NativeImage.showError("The " + debugAttach + " option can only be used once.");
            }
            this.useDebugAttach = true;
            String debugAttachArg = args.poll();
            String portSuffix = debugAttachArg.substring(debugAttach.length());
            int debugPort = 8000;
            if (!portSuffix.isEmpty()) {
                try {
                    debugPort = Integer.parseInt(portSuffix.substring(1));
                }
                catch (NumberFormatException e) {
                    NativeImage.showError("Invalid " + debugAttach + " option: " + debugAttachArg);
                }
            }
            this.nativeImage.addImageBuilderJavaArgs("-Xdebug", "-Xrunjdwp:transport=dt_socket,server=y,address=" + debugPort + ",suspend=y");
            return true;
        }
        if (headArg.startsWith("-H:") || headArg.startsWith("-R:")) {
            args.poll();
            this.nativeImage.addCustomImageBuilderArgs(headArg);
            return true;
        }
        String javaArgsPrefix = "-D";
        if (headArg.startsWith(javaArgsPrefix)) {
            args.poll();
            this.nativeImage.addCustomJavaArgs(headArg);
            return true;
        }
        String optionKeyPrefix = "-V";
        if (headArg.startsWith(optionKeyPrefix)) {
            args.poll();
            String keyValueStr = headArg.substring(optionKeyPrefix.length());
            String[] keyValue = keyValueStr.split("=");
            if (keyValue.length != 2) {
                throw NativeImage.showError("Use " + optionKeyPrefix + "<key>=<value>");
            }
            this.nativeImage.addOptionKeyValue(keyValue[0], keyValue[1]);
            return true;
        }
        if (headArg.startsWith("-J")) {
            args.poll();
            if (headArg.equals("-J")) {
                NativeImage.showError("The -J option should not be followed by a space");
            } else {
                this.nativeImage.addCustomJavaArgs(headArg.substring(2));
            }
            return true;
        }
        String optimizeOption = "-O";
        if (headArg.startsWith(optimizeOption)) {
            args.poll();
            if (headArg.equals(optimizeOption)) {
                NativeImage.showError("The " + optimizeOption + " option should not be followed by a space");
            } else {
                this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHOptimize + headArg.substring(2));
            }
            return true;
        }
        return false;
    }

    private void handleJarFileArg(Path filePath) {
        try (JarFile jarFile = new JarFile(filePath.toFile());){
            String classPath;
            Attributes mainAttributes;
            String mainClass;
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                NativeImage.showError("No manifest in " + filePath);
            }
            if ((mainClass = (mainAttributes = manifest.getMainAttributes()).getValue("Main-Class")) == null) {
                NativeImage.showError("No main manifest attribute, in " + filePath);
            }
            this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHClass + mainClass);
            String jarFileName = filePath.getFileName().toString();
            String jarSuffix = ".jar";
            String jarFileNameBase = jarFileName.endsWith(jarSuffix) ? jarFileName.substring(0, jarFileName.length() - jarSuffix.length()) : jarFileName;
            if (!jarFileNameBase.isEmpty()) {
                this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHName + jarFileNameBase);
            }
            if ((classPath = mainAttributes.getValue("Class-Path")) != null) {
                for (String cp : classPath.split(" +")) {
                    Path manifestClassPath = ImageClassLoader.stringToClasspath((String)cp);
                    if (!manifestClassPath.isAbsolute()) {
                        manifestClassPath = filePath.getParent().resolve(manifestClassPath);
                    }
                    this.nativeImage.addImageProvidedClasspath(manifestClassPath);
                }
            }
            this.nativeImage.addCustomImageClasspath(filePath);
        }
        catch (NativeImage.NativeImageError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw NativeImage.showError("Invalid or corrupt jarfile " + filePath);
        }
    }
}

