/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.builder;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.compiler.nodes.ParameterNode;

public class TypeFlowGraphBuilder {
    private final BigBang bb;
    private final List<TypeFlowBuilder<?>> dataFlowSinkBuilders;
    private static final List<String> waitNotifyHashCodeMethods = new ArrayList<String>();

    public TypeFlowGraphBuilder(BigBang bb) {
        this.bb = bb;
        this.dataFlowSinkBuilders = new ArrayList();
    }

    public void registerSinkBuilder(TypeFlowBuilder<?> sinkBuilder) {
        this.dataFlowSinkBuilders.add(sinkBuilder);
    }

    private static String format(Method m) {
        return m.getDeclaringClass().getName() + "." + m.getName() + "(" + Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.joining(", ")) + ")";
    }

    public void checkFormalParameterBuilder(TypeFlowBuilder<?> paramBuilder) {
        AnalysisMethod method = (AnalysisMethod)((ParameterNode)paramBuilder.getSource()).graph().method();
        String methodFormat = method.format("%H.%n(%P)");
        for (String specialMethodFormat : waitNotifyHashCodeMethods) {
            if (!methodFormat.equals(specialMethodFormat)) continue;
            this.dataFlowSinkBuilders.add(paramBuilder);
        }
    }

    public void build() {
        HashSet<TypeFlowBuilder> processed = new HashSet<TypeFlowBuilder>();
        ArrayDeque workQueue = new ArrayDeque();
        for (TypeFlowBuilder<?> sinkBuilder : this.dataFlowSinkBuilders) {
            if (processed.contains(sinkBuilder)) continue;
            workQueue.addLast(sinkBuilder);
            while (!workQueue.isEmpty()) {
                TypeFlowBuilder builder = (TypeFlowBuilder)workQueue.removeFirst();
                Object flow = builder.get();
                PointsToStats.registerTypeFlowRetainReason(this.bb, flow, (sinkBuilder.isBuildingAnActualParameter() ? "ActualParam=" : "") + sinkBuilder.getFlowClass().getSimpleName());
                processed.add(builder);
                for (TypeFlowBuilder<?> useDependency : builder.getUseDependencies()) {
                    if (!processed.contains(useDependency)) {
                        workQueue.addLast(useDependency);
                    }
                    Object useFlow = useDependency.get();
                    ((TypeFlow)useFlow).addOriginalUse(this.bb, (TypeFlow<?>)flow);
                }
                for (TypeFlowBuilder<?> observerDependency : builder.getObserverDependencies()) {
                    if (!processed.contains(observerDependency)) {
                        workQueue.addLast(observerDependency);
                    }
                    Object observerFlow = observerDependency.get();
                    ((TypeFlow)observerFlow).addOriginalObserver(this.bb, (TypeFlow<?>)flow);
                }
            }
        }
    }

    static {
        try {
            Method wait = Object.class.getMethod("wait", Long.TYPE);
            waitNotifyHashCodeMethods.add(TypeFlowGraphBuilder.format(wait));
            Method notify = Object.class.getMethod("notify", new Class[0]);
            waitNotifyHashCodeMethods.add(TypeFlowGraphBuilder.format(notify));
            Method notifyAll = Object.class.getMethod("notifyAll", new Class[0]);
            waitNotifyHashCodeMethods.add(TypeFlowGraphBuilder.format(notifyAll));
            Method hashCode = System.class.getMethod("identityHashCode", Object.class);
            waitNotifyHashCodeMethods.add(TypeFlowGraphBuilder.format(hashCode));
        }
        catch (NoSuchMethodException e) {
            throw AnalysisError.shouldNotReachHere(e);
        }
    }
}

