/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.http4;

import com.netflix.servo.monitor.DynamicCounter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFHttpMethodRetryHandler
extends DefaultHttpRequestRetryHandler {
    private static final String RETRY_COUNTER = "PLATFORM:NFttpClient:Retries:";
    private Logger logger = LoggerFactory.getLogger(NFHttpMethodRetryHandler.class);
    private int sleepTimeFactorMs;
    private String httpClientName;

    public NFHttpMethodRetryHandler(String httpClientName, int retryCount, boolean requestSentRetryEnabled, int sleepTimeFactorMs) {
        super(retryCount, requestSentRetryEnabled);
        this.httpClientName = httpClientName;
        this.sleepTimeFactorMs = sleepTimeFactorMs;
    }

    @SuppressWarnings(value={"ICAST_INTEGER_MULTIPLY_CAST_TO_LONG"})
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (super.retryRequest(exception, executionCount, context)) {
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            String methodName = request.getRequestLine().getMethod();
            String path = "UNKNOWN_PATH";
            if (request instanceof HttpUriRequest) {
                HttpUriRequest uriReq = (HttpUriRequest)request;
                path = uriReq.getURI().toString();
            }
            try {
                Thread.sleep(executionCount * this.sleepTimeFactorMs);
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while sleep before retrying http method " + methodName + " " + path, (Throwable)e);
            }
            DynamicCounter.increment((String)(RETRY_COUNTER + methodName + ":" + path), (String[])new String[0]);
            return true;
        }
        return false;
    }
}

