/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.service;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.mycila.inject.annotation.OverrideModule;
import java.util.LinkedList;
import java.util.ServiceLoader;

public class ServiceModules {
    private ServiceModules() {
    }

    public static Module loadFromClasspath() {
        return ServiceModules.loadFromClasspath(Module.class);
    }

    public static Module loadFromClasspath(Class<? extends Module> moduleType) {
        LinkedList<Module> runtime = new LinkedList<Module>();
        LinkedList<Module> overrides = new LinkedList<Module>();
        for (Module module : ServiceLoader.load(moduleType)) {
            if (module.getClass().isAnnotationPresent(OverrideModule.class)) {
                overrides.add(module);
                continue;
            }
            runtime.add(module);
        }
        return overrides.isEmpty() ? Modules.combine(runtime) : Modules.override(runtime).with(overrides);
    }
}

