/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.io;

import com.mycila.inject.internal.guava.annotations.Beta;
import com.mycila.inject.internal.guava.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@Beta
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    public boolean accept(File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

