/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.base;

import com.mycila.inject.internal.guava.annotations.Beta;
import com.mycila.inject.internal.guava.annotations.GwtCompatible;

@Beta
@GwtCompatible
public final class Ascii {
    private Ascii() {
    }

    public static String toLowerCase(String string) {
        int length = string.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(Ascii.toLowerCase(string.charAt(i)));
        }
        return builder.toString();
    }

    public static char toLowerCase(char c) {
        return Ascii.isUpperCase(c) ? (char)(c ^ 0x20) : c;
    }

    public static String toUpperCase(String string) {
        int length = string.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(Ascii.toUpperCase(string.charAt(i)));
        }
        return builder.toString();
    }

    public static char toUpperCase(char c) {
        return Ascii.isLowerCase(c) ? (char)(c & 0x5F) : c;
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }
}

