/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject;

import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeListener;
import com.mycila.inject.injector.AnnotatedMemberHandler;
import com.mycila.inject.injector.AnnotatedMemberHandlerTypeListener;
import com.mycila.inject.injector.FieldHandler;
import com.mycila.inject.injector.FieldHandlerTypeListener;
import com.mycila.inject.injector.KeyProvider;
import com.mycila.inject.injector.MemberInjectorTypeListener;
import com.mycila.inject.injector.MethodHandler;
import com.mycila.inject.injector.MethodHandlerTypeListener;
import com.mycila.inject.scope.ConcurrentSingleton;
import com.mycila.inject.scope.ExpiringSingleton;
import com.mycila.inject.scope.RenewableSingleton;
import com.mycila.inject.scope.ResetScope;
import com.mycila.inject.scope.ResetSingleton;
import com.mycila.inject.scope.SoftSingleton;
import com.mycila.inject.scope.WeakSingleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.inject.Qualifier;
import org.aopalliance.intercept.MethodInterceptor;

public final class MycilaGuice {
    private final Binder binder;

    private MycilaGuice(Binder binder) {
        this.binder = binder;
    }

    public MycilaGuice bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        for (MethodInterceptor interceptor : interceptors) {
            this.inject(interceptor);
        }
        this.binder.bindInterceptor(classMatcher, methodMatcher, interceptors);
        return this;
    }

    public Scope expiringSingleton(long expirity, TimeUnit unit) {
        return this.inject(new ExpiringSingleton(expirity, unit));
    }

    public Scope renewableSingleton(long expirity, TimeUnit unit) {
        return this.inject(new RenewableSingleton(expirity, unit));
    }

    public Scope weakSingleton() {
        return this.inject(new WeakSingleton());
    }

    public Scope softSingleton() {
        return this.inject(new SoftSingleton());
    }

    public Scope concurrentSingleton() {
        return this.inject(new ConcurrentSingleton(10L, TimeUnit.SECONDS));
    }

    public Scope concurrentSingleton(long expirity, TimeUnit unit) {
        return this.inject(new ConcurrentSingleton(expirity, unit));
    }

    public ResetScope resetSingleton() {
        return this.inject(new ResetSingleton());
    }

    public <A extends Annotation> MycilaGuice bindAnnotationInjector(Class<A> annotationType, Class<? extends KeyProvider<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.inject(new MemberInjectorTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MycilaGuice handleMethodAfterInjection(Class<A> annotationType, Class<? extends MethodHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.inject(new MethodHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MycilaGuice handleFieldAfterInjection(Class<A> annotationType, Class<? extends FieldHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.inject(new FieldHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MycilaGuice handleAfterInjection(Class<A> annotationType, Class<? extends AnnotatedMemberHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), (TypeListener)this.inject(new AnnotatedMemberHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <T> MycilaGuice bind(Class<T> type, T instance) {
        this.binder.bind(type).toInstance(this.inject(instance));
        return this;
    }

    public MycilaGuice install(Module module) {
        this.binder.install(this.inject(module));
        return this;
    }

    public <T> T inject(T object) {
        this.binder.requestInjection(object);
        return object;
    }

    public static MycilaGuice in(Binder binder) {
        return new MycilaGuice(binder);
    }

    public static boolean isBindingAnnotation(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(BindingAnnotation.class) || annotationType.isAnnotationPresent(Qualifier.class);
    }
}

