/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpHeader;
import com.microsoft.rest.v2.http.HttpHeaders;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;

public class AddHeadersPolicyFactory
implements RequestPolicyFactory {
    private final HttpHeaders headers;

    public AddHeadersPolicyFactory(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new AddHeadersPolicy(next);
    }

    private final class AddHeadersPolicy
    implements RequestPolicy {
        private final RequestPolicy next;

        private AddHeadersPolicy(RequestPolicy next) {
            this.next = next;
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            for (HttpHeader header : AddHeadersPolicyFactory.this.headers) {
                request.withHeader(header.name(), header.value());
            }
            return this.next.sendAsync(request);
        }
    }
}

