/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.credentials.ServiceClientCredentials;
import com.microsoft.rest.v2.http.HttpClient;
import com.microsoft.rest.v2.http.HttpPipeline;
import com.microsoft.rest.v2.http.HttpPipelineLogger;
import com.microsoft.rest.v2.http.HttpPipelineOptions;
import com.microsoft.rest.v2.policy.CookiePolicyFactory;
import com.microsoft.rest.v2.policy.CredentialsPolicyFactory;
import com.microsoft.rest.v2.policy.DecodingPolicyFactory;
import com.microsoft.rest.v2.policy.HostPolicyFactory;
import com.microsoft.rest.v2.policy.HttpLogDetailLevel;
import com.microsoft.rest.v2.policy.HttpLoggingPolicyFactory;
import com.microsoft.rest.v2.policy.ProxyAuthenticationPolicyFactory;
import com.microsoft.rest.v2.policy.RequestIdPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RetryPolicyFactory;
import com.microsoft.rest.v2.policy.TimeoutPolicyFactory;
import com.microsoft.rest.v2.policy.UserAgentPolicyFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class HttpPipelineBuilder {
    private HttpPipelineOptions options;
    private final List<RequestPolicyFactory> requestPolicyFactories;

    public HttpPipelineBuilder() {
        this(null);
    }

    public HttpPipelineBuilder(HttpPipelineOptions options) {
        this.options = options;
        this.requestPolicyFactories = new ArrayList<RequestPolicyFactory>();
    }

    List<RequestPolicyFactory> requestPolicyFactories() {
        return this.requestPolicyFactories;
    }

    HttpPipelineOptions options() {
        return this.options;
    }

    public HttpPipelineBuilder withHttpClient(HttpClient httpClient) {
        if (this.options == null) {
            this.options = new HttpPipelineOptions();
        }
        this.options.withHttpClient(httpClient);
        return this;
    }

    public HttpPipelineBuilder withLogger(HttpPipelineLogger logger) {
        if (this.options == null) {
            this.options = new HttpPipelineOptions();
        }
        this.options.withLogger(logger);
        return this;
    }

    public HttpPipelineBuilder withRequestPolicy(RequestPolicyFactory requestPolicyFactory) {
        return this.withRequestPolicy(this.requestPolicyFactories.size(), requestPolicyFactory);
    }

    public HttpPipelineBuilder withRequestPolicy(int index, RequestPolicyFactory requestPolicyFactory) {
        int insertIndex = this.requestPolicyFactories.size() - index;
        this.requestPolicyFactories.add(insertIndex, requestPolicyFactory);
        return this;
    }

    public HttpPipelineBuilder withRequestPolicies(RequestPolicyFactory ... requestPolicyFactories) {
        for (RequestPolicyFactory factory : requestPolicyFactories) {
            this.withRequestPolicy(factory);
        }
        return this;
    }

    public HttpPipelineBuilder withCookiePolicy() {
        return this.withRequestPolicy(new CookiePolicyFactory());
    }

    public HttpPipelineBuilder withCredentialsPolicy(ServiceClientCredentials credentials) {
        return this.withRequestPolicy(new CredentialsPolicyFactory(credentials));
    }

    public HttpPipelineBuilder withDecodingPolicy() {
        return this.withRequestPolicy(new DecodingPolicyFactory());
    }

    public HttpPipelineBuilder withHostPolicy(String host) {
        return this.withRequestPolicy(new HostPolicyFactory(host));
    }

    public HttpPipelineBuilder withHttpLoggingPolicy(HttpLogDetailLevel level) {
        return this.withHttpLoggingPolicy(level, false);
    }

    public HttpPipelineBuilder withHttpLoggingPolicy(HttpLogDetailLevel level, boolean prettyPrintJSON) {
        return this.withRequestPolicy(new HttpLoggingPolicyFactory(level, prettyPrintJSON));
    }

    public HttpPipelineBuilder withProxyAuthenticationPolicy(String username, String password) {
        return this.withRequestPolicy(new ProxyAuthenticationPolicyFactory(username, password));
    }

    public HttpPipelineBuilder withRequestIdPolicy() {
        return this.withRequestPolicy(new RequestIdPolicyFactory());
    }

    public HttpPipelineBuilder withRetryPolicy(int maxRetries, long delayTime, TimeUnit timeUnit) {
        return this.withRequestPolicy(new RetryPolicyFactory(maxRetries, delayTime, timeUnit));
    }

    public HttpPipelineBuilder withTimeoutPolicy(long timeout, TimeUnit unit) {
        return this.withRequestPolicy(new TimeoutPolicyFactory(timeout, unit));
    }

    public HttpPipelineBuilder withUserAgentPolicy(String userAgent) {
        return this.withRequestPolicy(new UserAgentPolicyFactory(userAgent));
    }

    public HttpPipeline build() {
        int requestPolicyCount = this.requestPolicyFactories.size();
        RequestPolicyFactory[] requestPolicyFactoryArray = new RequestPolicyFactory[requestPolicyCount];
        return new HttpPipeline(this.requestPolicyFactories.toArray(requestPolicyFactoryArray), this.options);
    }
}

