/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2;

import com.microsoft.rest.v2.Base64Url;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.EncodedParameter;
import com.microsoft.rest.v2.MissingRequiredAnnotationException;
import com.microsoft.rest.v2.RestException;
import com.microsoft.rest.v2.RestResponse;
import com.microsoft.rest.v2.Substitution;
import com.microsoft.rest.v2.UnixTime;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.DELETE;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HEAD;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Headers;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PATCH;
import com.microsoft.rest.v2.annotations.POST;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.PathParam;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.ReturnValueWireType;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import com.microsoft.rest.v2.http.HttpHeader;
import com.microsoft.rest.v2.http.HttpHeaders;
import com.microsoft.rest.v2.http.HttpMethod;
import com.microsoft.rest.v2.protocol.SerializerAdapter;
import com.microsoft.rest.v2.util.TypeUtil;
import com.microsoft.rest.v2.util.escapers.PercentEscaper;
import com.microsoft.rest.v2.util.escapers.UrlEscapers;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SwaggerMethodParser {
    private final SerializerAdapter<?> serializer;
    private final String rawHost;
    private final String fullyQualifiedMethodName;
    private HttpMethod httpMethod;
    private String relativePath;
    private final List<Substitution> hostSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> pathSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> querySubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> headerSubstitutions = new ArrayList<Substitution>();
    private final HttpHeaders headers = new HttpHeaders();
    private Integer bodyContentMethodParameterIndex;
    private String bodyContentType;
    private Type bodyJavaType;
    private int[] expectedStatusCodes;
    private Type returnType;
    private Type returnValueWireType;
    private Class<? extends RestException> exceptionType;
    private Class<?> exceptionBodyType;

    SwaggerMethodParser(Method swaggerMethod, SerializerAdapter<?> serializer, String rawHost) {
        UnexpectedResponseExceptionType unexpectedResponseExceptionType;
        ExpectedResponses expectedResponses;
        this.serializer = serializer;
        this.rawHost = rawHost;
        Class<?> swaggerInterface = swaggerMethod.getDeclaringClass();
        this.fullyQualifiedMethodName = swaggerInterface.getName() + "." + swaggerMethod.getName();
        if (swaggerMethod.isAnnotationPresent(GET.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.GET, swaggerMethod.getAnnotation(GET.class).value());
        } else if (swaggerMethod.isAnnotationPresent(PUT.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.PUT, swaggerMethod.getAnnotation(PUT.class).value());
        } else if (swaggerMethod.isAnnotationPresent(HEAD.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.HEAD, swaggerMethod.getAnnotation(HEAD.class).value());
        } else if (swaggerMethod.isAnnotationPresent(DELETE.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.DELETE, swaggerMethod.getAnnotation(DELETE.class).value());
        } else if (swaggerMethod.isAnnotationPresent(POST.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.POST, swaggerMethod.getAnnotation(POST.class).value());
        } else if (swaggerMethod.isAnnotationPresent(PATCH.class)) {
            this.setHttpMethodAndRelativePath(HttpMethod.PATCH, swaggerMethod.getAnnotation(PATCH.class).value());
        } else {
            ArrayList<Class<? extends Annotation>> requiredAnnotationOptions = new ArrayList<Class<? extends Annotation>>();
            requiredAnnotationOptions.add(GET.class);
            requiredAnnotationOptions.add(PUT.class);
            requiredAnnotationOptions.add(HEAD.class);
            requiredAnnotationOptions.add(DELETE.class);
            requiredAnnotationOptions.add(POST.class);
            requiredAnnotationOptions.add(PATCH.class);
            throw new MissingRequiredAnnotationException(requiredAnnotationOptions, swaggerMethod);
        }
        this.returnType = swaggerMethod.getGenericReturnType();
        ReturnValueWireType returnValueWireTypeAnnotation = swaggerMethod.getAnnotation(ReturnValueWireType.class);
        if (returnValueWireTypeAnnotation != null) {
            Class<?> returnValueWireType = returnValueWireTypeAnnotation.value();
            if (returnValueWireType == Base64Url.class || returnValueWireType == UnixTime.class || returnValueWireType == DateTimeRfc1123.class) {
                this.returnValueWireType = returnValueWireType;
            } else if (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, List.class)) {
                this.returnValueWireType = returnValueWireType.getGenericInterfaces()[0];
            }
        }
        if (swaggerMethod.isAnnotationPresent(Headers.class)) {
            String[] headers;
            Headers headersAnnotation = swaggerMethod.getAnnotation(Headers.class);
            for (String header : headers = headersAnnotation.value()) {
                String headerValue;
                String headerName;
                int colonIndex = header.indexOf(":");
                if (colonIndex < 0 || (headerName = header.substring(0, colonIndex).trim()).isEmpty() || (headerValue = header.substring(colonIndex + 1).trim()).isEmpty()) continue;
                this.headers.set(headerName, headerValue);
            }
        }
        if ((expectedResponses = swaggerMethod.getAnnotation(ExpectedResponses.class)) != null) {
            this.expectedStatusCodes = expectedResponses.value();
        }
        this.exceptionType = (unexpectedResponseExceptionType = swaggerMethod.getAnnotation(UnexpectedResponseExceptionType.class)) == null ? RestException.class : unexpectedResponseExceptionType.value();
        try {
            Method exceptionBodyMethod = this.exceptionType.getDeclaredMethod("body", new Class[0]);
            this.exceptionBodyType = exceptionBodyMethod.getReturnType();
        }
        catch (NoSuchMethodException e) {
            this.exceptionBodyType = Object.class;
        }
        Annotation[][] allParametersAnnotations = swaggerMethod.getParameterAnnotations();
        for (int parameterIndex = 0; parameterIndex < allParametersAnnotations.length; ++parameterIndex) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = swaggerMethod.getParameterAnnotations()[parameterIndex]) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.equals(HostParam.class)) {
                    HostParam hostParamAnnotation = (HostParam)annotation;
                    this.hostSubstitutions.add(new Substitution(hostParamAnnotation.value(), parameterIndex, !hostParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(PathParam.class)) {
                    PathParam pathParamAnnotation = (PathParam)annotation;
                    this.pathSubstitutions.add(new Substitution(pathParamAnnotation.value(), parameterIndex, !pathParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(QueryParam.class)) {
                    QueryParam queryParamAnnotation = (QueryParam)annotation;
                    this.querySubstitutions.add(new Substitution(queryParamAnnotation.value(), parameterIndex, !queryParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(HeaderParam.class)) {
                    HeaderParam headerParamAnnotation = (HeaderParam)annotation;
                    this.headerSubstitutions.add(new Substitution(headerParamAnnotation.value(), parameterIndex, false));
                    continue;
                }
                if (!annotationType.equals(BodyParam.class)) continue;
                BodyParam bodyParamAnnotation = (BodyParam)annotation;
                this.bodyContentMethodParameterIndex = parameterIndex;
                this.bodyContentType = bodyParamAnnotation.value();
                this.bodyJavaType = swaggerMethod.getGenericParameterTypes()[parameterIndex];
            }
        }
    }

    public String fullyQualifiedMethodName() {
        return this.fullyQualifiedMethodName;
    }

    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    public int[] expectedStatusCodes() {
        return this.expectedStatusCodes;
    }

    public String scheme(Object[] swaggerMethodArguments) {
        String substitutedHost = this.applySubstitutions(this.rawHost, this.hostSubstitutions, swaggerMethodArguments, UrlEscapers.PATH_ESCAPER);
        String[] substitutedHostParts = substitutedHost.split("://");
        return substitutedHostParts.length < 1 ? null : substitutedHostParts[0];
    }

    public String host(Object[] swaggerMethodArguments) {
        String substitutedHost = this.applySubstitutions(this.rawHost, this.hostSubstitutions, swaggerMethodArguments, UrlEscapers.PATH_ESCAPER);
        String[] substitutedHostParts = substitutedHost.split("://");
        return substitutedHostParts.length < 2 ? substitutedHost : substitutedHost.split("://")[1];
    }

    public String path(Object[] methodArguments) {
        return this.applySubstitutions(this.relativePath, this.pathSubstitutions, methodArguments, UrlEscapers.PATH_ESCAPER);
    }

    public Iterable<EncodedParameter> encodedQueryParameters(Object[] swaggerMethodArguments) {
        ArrayList<EncodedParameter> result = new ArrayList<EncodedParameter>();
        if (this.querySubstitutions != null) {
            PercentEscaper escaper = UrlEscapers.QUERY_ESCAPER;
            for (Substitution querySubstitution : this.querySubstitutions) {
                Object methodArgument;
                String parameterValue;
                int parameterIndex = querySubstitution.methodParameterIndex();
                if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length || (parameterValue = this.serialize(methodArgument = swaggerMethodArguments[querySubstitution.methodParameterIndex()])) == null) continue;
                if (querySubstitution.shouldEncode() && escaper != null) {
                    parameterValue = escaper.escape(parameterValue);
                }
                result.add(new EncodedParameter(querySubstitution.urlParameterName(), parameterValue));
            }
        }
        return result;
    }

    public Iterable<HttpHeader> headers(Object[] swaggerMethodArguments) {
        HttpHeaders result = new HttpHeaders(this.headers);
        if (this.headerSubstitutions != null) {
            for (Substitution headerSubstitution : this.headerSubstitutions) {
                int parameterIndex = headerSubstitution.methodParameterIndex();
                if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length) continue;
                Object methodArgument = swaggerMethodArguments[headerSubstitution.methodParameterIndex()];
                if (methodArgument instanceof Map) {
                    Map headerCollection = (Map)methodArgument;
                    String headerCollectionPrefix = headerSubstitution.urlParameterName();
                    for (Map.Entry headerCollectionEntry : headerCollection.entrySet()) {
                        String headerName = headerCollectionPrefix + (String)headerCollectionEntry.getKey();
                        String headerValue = this.serialize(headerCollectionEntry.getValue());
                        result.set(headerName, headerValue);
                    }
                    continue;
                }
                String headerName = headerSubstitution.urlParameterName();
                String headerValue = this.serialize(methodArgument);
                result.set(headerName, headerValue);
            }
        }
        return result;
    }

    public Context context(Object[] swaggerMethodArguments) {
        Object firstArg;
        Object object = firstArg = swaggerMethodArguments != null && swaggerMethodArguments.length > 0 ? swaggerMethodArguments[0] : null;
        if (firstArg instanceof Context) {
            return (Context)firstArg;
        }
        return null;
    }

    public boolean isExpectedResponseStatusCode(int responseStatusCode) {
        return this.isExpectedResponseStatusCode(responseStatusCode, null);
    }

    public boolean isExpectedResponseStatusCode(int responseStatusCode, int[] additionalAllowedStatusCodes) {
        boolean result = this.expectedStatusCodes == null ? responseStatusCode < 400 : SwaggerMethodParser.contains(this.expectedStatusCodes, responseStatusCode) || SwaggerMethodParser.contains(additionalAllowedStatusCodes, responseStatusCode);
        return result;
    }

    private static boolean contains(int[] values, int searchValue) {
        boolean result = false;
        if (values != null && values.length > 0) {
            for (int value : values) {
                if (searchValue != value) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Class<? extends RestException> exceptionType() {
        return this.exceptionType;
    }

    public Class<?> exceptionBodyType() {
        return this.exceptionBodyType;
    }

    public Object body(Object[] swaggerMethodArguments) {
        Object result = null;
        if (this.bodyContentMethodParameterIndex != null && swaggerMethodArguments != null && 0 <= this.bodyContentMethodParameterIndex && this.bodyContentMethodParameterIndex < swaggerMethodArguments.length) {
            result = swaggerMethodArguments[this.bodyContentMethodParameterIndex];
        }
        return result;
    }

    public String bodyContentType() {
        return this.bodyContentType;
    }

    public Type returnType() {
        return this.returnType;
    }

    public Type bodyJavaType() {
        return this.bodyJavaType;
    }

    public Type returnValueWireType() {
        return this.returnValueWireType;
    }

    public boolean expectsResponseBody() {
        boolean result = true;
        if (TypeUtil.isTypeOrSubTypeOf(this.returnType, Void.class)) {
            result = false;
        } else if (TypeUtil.isTypeOrSubTypeOf(this.returnType, Single.class) || TypeUtil.isTypeOrSubTypeOf(this.returnType, Observable.class)) {
            ParameterizedType asyncReturnType = (ParameterizedType)this.returnType;
            Type syncReturnType = asyncReturnType.getActualTypeArguments()[0];
            if (TypeUtil.isTypeOrSubTypeOf(syncReturnType, Void.class)) {
                result = false;
            } else if (TypeUtil.isTypeOrSubTypeOf(syncReturnType, RestResponse.class)) {
                result = SwaggerMethodParser.restResponseTypeExpectsBody((ParameterizedType)TypeUtil.getSuperType(syncReturnType, RestResponse.class));
            }
        } else if (TypeUtil.isTypeOrSubTypeOf(this.returnType, RestResponse.class)) {
            result = SwaggerMethodParser.restResponseTypeExpectsBody((ParameterizedType)TypeUtil.getSuperType(this.returnType, RestResponse.class));
        }
        return result;
    }

    private static boolean restResponseTypeExpectsBody(ParameterizedType restResponseReturnType) {
        boolean result = true;
        Type[] restResponseTypeArguments = restResponseReturnType.getActualTypeArguments();
        Type restResponseBodyType = restResponseTypeArguments[1];
        if (restResponseBodyType == Void.class) {
            result = false;
        }
        return result;
    }

    private void setHttpMethodAndRelativePath(HttpMethod httpMethod, String relativePath) {
        this.httpMethod = httpMethod;
        this.relativePath = relativePath;
    }

    String serialize(Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof String ? (String)value : this.serializer.serializeRaw(value);
        }
        return result;
    }

    private String applySubstitutions(String originalValue, Iterable<Substitution> substitutions, Object[] methodArguments, PercentEscaper escaper) {
        String result = originalValue;
        if (methodArguments != null) {
            for (Substitution substitution : substitutions) {
                int substitutionParameterIndex = substitution.methodParameterIndex();
                if (0 > substitutionParameterIndex || substitutionParameterIndex >= methodArguments.length) continue;
                Object methodArgument = methodArguments[substitutionParameterIndex];
                String substitutionValue = this.serialize(methodArgument);
                if (substitutionValue != null && !substitutionValue.isEmpty() && substitution.shouldEncode() && escaper != null) {
                    substitutionValue = escaper.escape(substitutionValue);
                }
                result = result.replace("{" + substitution.urlParameterName() + "}", substitutionValue);
            }
        }
        return result;
    }
}

