/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.Utility;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

final class UploadFromNRFBufferPool {
    private final BlockingQueue<ByteBuffer> buffers;
    private final int maxBuffs;
    private int numBuffs = 0;
    private final int buffSize;
    private ByteBuffer currentBuf;

    UploadFromNRFBufferPool(int numBuffs, int buffSize) {
        Utility.assertInBounds("numBuffs", numBuffs, 2L, Integer.MAX_VALUE);
        this.maxBuffs = numBuffs;
        this.buffers = new LinkedBlockingQueue<ByteBuffer>(numBuffs);
        Utility.assertInBounds("buffSize", buffSize, 1L, 0x6400000L);
        this.buffSize = buffSize;
        this.buffers.add(ByteBuffer.allocate(this.buffSize));
        this.buffers.add(ByteBuffer.allocate(this.buffSize));
        this.numBuffs = 2;
    }

    public Flowable<ByteBuffer> write(ByteBuffer buf) {
        Flowable result;
        if (this.currentBuf == null) {
            this.currentBuf = this.getBuffer();
        }
        if (this.currentBuf.remaining() >= buf.remaining()) {
            this.currentBuf.put(buf);
            if (this.currentBuf.remaining() == 0) {
                this.currentBuf.position(0);
                result = Flowable.just((Object)this.currentBuf);
                this.currentBuf = null;
            } else {
                result = Flowable.empty();
            }
        } else {
            int oldLimit = buf.limit();
            buf.limit(buf.position() + this.currentBuf.remaining());
            this.currentBuf.put(buf);
            buf.limit(oldLimit);
            this.currentBuf.position(0);
            result = Flowable.just((Object)this.currentBuf);
            this.currentBuf = this.getBuffer();
            this.currentBuf.put(buf);
        }
        return result;
    }

    private ByteBuffer getBuffer() {
        ByteBuffer result;
        if (this.buffers.isEmpty() && this.numBuffs < this.maxBuffs) {
            result = ByteBuffer.allocate(this.buffSize);
            ++this.numBuffs;
        } else {
            try {
                result = this.buffers.take();
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException("UploadFromStream thread interrupted. Thread:" + Thread.currentThread().getId());
            }
        }
        return result;
    }

    Flowable<ByteBuffer> flush() {
        if (this.currentBuf != null) {
            this.currentBuf.flip();
            ByteBuffer last = this.currentBuf;
            this.currentBuf = null;
            return Flowable.just((Object)last);
        }
        return Flowable.empty();
    }

    void returnBuffer(ByteBuffer b) {
        b.position(0);
        b.limit(b.capacity());
        try {
            this.buffers.put(b);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("UploadFromStream thread interrupted.");
        }
    }
}

