/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.TelemetryOptions;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.util.Locale;

public final class TelemetryFactory
implements RequestPolicyFactory {
    private final String userAgent;

    public TelemetryFactory(TelemetryOptions telemetryOptions) {
        telemetryOptions = telemetryOptions == null ? new TelemetryOptions() : telemetryOptions;
        String userAgentPrefix = telemetryOptions.userAgentPrefix() == null ? "" : telemetryOptions.userAgentPrefix();
        this.userAgent = String.valueOf(userAgentPrefix) + ' ' + "Azure-Storage" + '/' + "11.0.0" + String.format(Locale.ROOT, " (JavaJRE %s; %s %s)", System.getProperty("java.version"), System.getProperty("os.name").replaceAll(" ", ""), System.getProperty("os.version"));
    }

    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new TelemetryPolicy(next, options);
    }

    private final class TelemetryPolicy
    implements RequestPolicy {
        private final RequestPolicy nextPolicy;

        private TelemetryPolicy(RequestPolicy nextPolicy, RequestPolicyOptions options) {
            this.nextPolicy = nextPolicy;
        }

        public Single<HttpResponse> sendAsync(HttpRequest request) {
            request.headers().set("User-Agent", TelemetryFactory.this.userAgent);
            return this.nextPolicy.sendAsync(request);
        }
    }
}

