/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.DirFilter;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.util.TreeSet;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class PhotoAlbum
extends AbstractTool {
    public PhotoAlbum() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcdir", "The directory containing the image files", false, new DirFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("PhotoAlbum", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== PhotoAlbum OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcdir") == null) {
                throw new InstantiationException("You need to choose a source directory");
            }
            File directory = (File)this.getValue("srcdir");
            if (directory.isFile()) {
                directory = directory.getParentFile();
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File pdf_file = (File)this.getValue("destfile");
            Document document = new Document();
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(pdf_file));
            writer.setViewerPreferences(256);
            PdfPageLabels pageLabels = new PdfPageLabels();
            TreeSet<File> images = new TreeSet<File>();
            File[] files = directory.listFiles();
            if (files == null) {
                throw new NullPointerException("listFiles() returns null");
            }
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                images.add(files[i]);
            }
            for (File image : images) {
                System.out.println("Testing image: " + image.getName());
                try {
                    int dpiY;
                    Image img = Image.getInstance(image.getAbsolutePath());
                    String caption = "";
                    int dpiX = img.getDpiX();
                    if (dpiX == 0) {
                        dpiX = 72;
                    }
                    if ((dpiY = img.getDpiY()) == 0) {
                        dpiY = 72;
                    }
                    float imgWidthPica = 72.0f * img.getPlainWidth() / (float)dpiX;
                    float imgHeightPica = 72.0f * img.getPlainHeight() / (float)dpiY;
                    img.scaleAbsolute(imgWidthPica, imgHeightPica);
                    document.setPageSize(new Rectangle(imgWidthPica, imgHeightPica));
                    if (document.isOpen()) {
                        document.newPage();
                    } else {
                        document.open();
                    }
                    img.setAbsolutePosition(0.0f, 0.0f);
                    document.add(img);
                    BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", false);
                    PdfGState gs1 = new PdfGState();
                    gs1.setBlendMode(PdfGState.BM_OVERLAY);
                    PdfContentByte cb = writer.getDirectContent();
                    cb.saveState();
                    cb.setGState(gs1);
                    cb.beginText();
                    cb.setFontAndSize(bf, 40.0f);
                    cb.setTextMatrix(50.0f, 50.0f);
                    cb.showText(caption);
                    cb.endText();
                    cb.restoreState();
                    String label = image.getName();
                    if (label.lastIndexOf(46) > 0) {
                        label = label.substring(0, label.lastIndexOf(46));
                    }
                    pageLabels.addPageLabel(writer.getPageNumber(), 5, label);
                    System.out.println("Added image: " + image.getName());
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            if (document.isOpen()) {
                writer.setPageLabels(pageLabels);
                document.close();
            } else {
                System.err.println("No images were found in directory " + directory.getAbsolutePath());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        PhotoAlbum tool = new PhotoAlbum();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        PhotoAlbum.addVersion("$Id: PhotoAlbum.java 3451 2008-05-26 02:56:13Z xlv $");
    }
}

