/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class PRIndirectReference
extends PdfIndirectReference {
    protected PdfReader reader;
    protected PdfObject hardReference;

    PRIndirectReference(PdfReader pdfReader, int n, int n2) {
        this.type = 10;
        this.number = n;
        this.generation = n2;
        this.reader = pdfReader;
    }

    PRIndirectReference(PdfReader pdfReader, int n) {
        this(pdfReader, n, 0);
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        int n = pdfWriter.getNewObjectNumber(this.reader, this.number, this.generation);
        outputStream.write(PdfEncodings.convertToBytes(n + " 0 R", null));
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public void setNumber(int n, int n2) {
        this.number = n;
        this.generation = n2;
        this.hardReference = null;
        this.reffedObj = null;
    }

    public PdfObject getDirectObject() {
        PdfObject pdfObject = this.getInternalObject();
        if (pdfObject == null) {
            pdfObject = this.reader.getPdfObject(this.number);
            if (this.reader.isPartial()) {
                this.reffedObj = new WeakReference<PdfObject>(pdfObject);
                this.reader.releaseLastXrefPartial();
                this.hardReference = null;
            } else {
                this.reffedObj = null;
                this.hardReference = pdfObject;
            }
        }
        return pdfObject;
    }

    private PdfObject getInternalObject() {
        if (this.hardReference == null && (this.reffedObj == null || this.reffedObj.get() == null)) {
            return null;
        }
        return this.hardReference != null ? this.hardReference : (PdfObject)this.reffedObj.get();
    }

    public void setDirectObject(PdfObject pdfObject) {
    }
}

