/*
 * Decompiled with CFR 0.152.
 */
package com.lostjs.wx4j.transporter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lostjs.wx4j.context.WxContext;
import com.lostjs.wx4j.data.request.BaseRequest;
import com.lostjs.wx4j.data.response.BaseResponse;
import com.lostjs.wx4j.data.response.WxResponse;
import com.lostjs.wx4j.exception.InvalidResponseException;
import com.lostjs.wx4j.transporter.WxTransporter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class BasicWxTransporter
implements WxTransporter {
    public static final long RETRY_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    public static final int MAX_RETRY = 10;
    public static final String USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Safari/602.1.50";
    public static final int REQUEST_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(60L);
    protected final WxContext context;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public BasicWxTransporter(WxContext context) {
        this.context = context;
    }

    @Override
    public WxContext getContext() {
        return this.context;
    }

    @Override
    public String get(String api) {
        return this.get(api, Collections.emptyList());
    }

    @Override
    public String get(String api, List<NameValuePair> params) {
        URI uri;
        String url = this.getUrl(api);
        List<NameValuePair> targetParams = this.getRequestParams(params);
        try {
            uri = new URIBuilder(url).addParameters(targetParams).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpGet get = new HttpGet(uri);
        return this.execute(uri, (HttpRequest)get);
    }

    @Override
    public <T extends WxResponse> T get(String api, List<NameValuePair> params, TypeReference<T> responseType) {
        String responseBody = this.get(api, params);
        return this.convertResponse(responseType, responseBody);
    }

    @Override
    public <T extends WxResponse> T get(String api, TypeReference<T> responseType) {
        String responseBody = this.get(api);
        return this.convertResponse(responseType, responseBody);
    }

    @Override
    public String post(String api) {
        return this.post(api, Collections.emptyList(), Collections.emptyMap());
    }

    @Override
    public String post(String api, List<NameValuePair> params) {
        return this.post(api, params, Collections.emptyMap());
    }

    @Override
    public String post(String api, Map<String, Object> dataMap) {
        return this.post(api, new ArrayList<NameValuePair>(), dataMap);
    }

    @Override
    public <T extends WxResponse> T post(String api, TypeReference<T> responseType) {
        return this.post(api, Collections.emptyList(), Collections.emptyMap(), responseType);
    }

    @Override
    public <T extends WxResponse> T post(String api, Map<String, Object> dataMap, TypeReference<T> responseType) {
        return this.post(api, Collections.emptyList(), dataMap, responseType);
    }

    @Override
    public <T extends WxResponse> T post(String api, List<NameValuePair> params, TypeReference<T> responseType) {
        return this.post(api, params, Collections.emptyMap(), responseType);
    }

    @Override
    public <T extends WxResponse> T post(String api, List<NameValuePair> params, Map<String, Object> dataMap, TypeReference<T> responseType) {
        String responseBody = this.post(api, params, dataMap);
        return this.convertResponse(responseType, responseBody);
    }

    @Override
    public String post(String api, List<NameValuePair> params, Map<String, Object> dataMap) {
        String body;
        URI uri;
        String url = this.getUrl(api);
        List<NameValuePair> targetParams = this.getRequestParams(params);
        HashMap<String, Object> targetMap = new HashMap<String, Object>();
        targetMap.putAll(dataMap);
        targetMap.put("BaseRequest", new BaseRequest(this.context));
        try {
            uri = new URIBuilder(url).addParameters(targetParams).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpPost httpPost = new HttpPost(uri);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            body = objectMapper.writeValueAsString(targetMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        httpPost.setEntity((HttpEntity)new StringEntity(body, Charset.forName("UTF-8")));
        try {
            String responseBody = this.execute(new URI(url), (HttpRequest)httpPost);
            return responseBody;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("e");
        }
    }

    private HttpClient getHttpClient() {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("Content-Type", "charset=UTF-8"));
        headers.add(new BasicHeader("User-Agent", USER_AGENT));
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(REQUEST_TIMEOUT).build();
        return HttpClientBuilder.create().setDefaultCookieStore((CookieStore)this.context).setDefaultHeaders(headers).setDefaultRequestConfig(defaultRequestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(10, true)).setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                boolean retry;
                int statusCode = response.getStatusLine().getStatusCode();
                boolean success = statusCode == 200;
                boolean bl = retry = !success && executionCount < 10;
                if (retry) {
                    BasicWxTransporter.this.LOG.info("retry, statusCode={}, executionCount = {}", (Object)statusCode, (Object)executionCount);
                }
                return retry;
            }

            public long getRetryInterval() {
                return RETRY_INTERVAL;
            }
        }).build();
    }

    private <T extends WxResponse> T convertResponse(TypeReference<T> responseType, String responseBody) {
        WxResponse responseObject;
        this.LOG.debug("response: \n{}", (Object)responseBody);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            responseObject = (WxResponse)objectMapper.readValue(responseBody, responseType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.checkResponse(responseObject);
        return (T)responseObject;
    }

    private String getUrl(String api) {
        Pattern pattern = Pattern.compile("^https?://");
        Matcher matcher = pattern.matcher(api);
        return matcher.find() ? api : this.context.getBaseUrl() + api;
    }

    private List<NameValuePair> getRequestParams(List<NameValuePair> params) {
        ArrayList<NameValuePair> targetParams = new ArrayList<NameValuePair>();
        targetParams.addAll(params);
        targetParams.add((NameValuePair)new BasicNameValuePair("r", String.valueOf(RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE))));
        targetParams.add((NameValuePair)new BasicNameValuePair("lang", "zh_CN"));
        targetParams.add((NameValuePair)new BasicNameValuePair("pass_ticket", this.context.getPassTicket()));
        targetParams.add((NameValuePair)new BasicNameValuePair("skey", this.context.getSkey()));
        return targetParams;
    }

    private void checkResponse(WxResponse response) {
        BaseResponse baseResponse = response.getBaseResponse();
        if (baseResponse == null) {
            throw new RuntimeException("no BaseResponse");
        }
        if (baseResponse.getRet() > 0) {
            throw new InvalidResponseException(baseResponse.getRet(), baseResponse.getErrMsg());
        }
    }

    private String execute(URI uri, HttpRequest request) {
        String responseBody;
        InputStream content;
        HttpResponse httpResponse;
        HttpClient client = this.getHttpClient();
        try {
            httpResponse = client.execute(new HttpHost(uri.getHost()), request);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode != 200) {
            throw new RuntimeException("invalid http status code, status=" + String.valueOf(statusCode));
        }
        HttpEntity entity = httpResponse.getEntity();
        try {
            content = entity.getContent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            responseBody = StreamUtils.copyToString((InputStream)content, (Charset)Charset.forName("utf-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return responseBody;
    }
}

