/*
 * Decompiled with CFR 0.152.
 */
package com.lostjs.wx4j.context;

import com.lostjs.wx4j.context.AbstractPersistentWxContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class FileWxContext
extends AbstractPersistentWxContext {
    private Logger LOG = LoggerFactory.getLogger(this.getClass());
    private String filePath;

    private FileWxContext() {
    }

    public FileWxContext(String filePath) {
        this.filePath = filePath;
    }

    @Override
    protected void write() {
        this.LOG.debug("write context to {}", (Object)this.filePath);
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.filePath), "utf-8"));
            writer.write(this.dumpToString());
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void read() {
        FileInputStream fileInputStream = null;
        File file = new File(this.filePath);
        try {
            if (!file.isFile()) {
                file.createNewFile();
            }
            fileInputStream = new FileInputStream(file);
            String string = StreamUtils.copyToString((InputStream)fileInputStream, (Charset)Charset.forName("UTF-8"));
            this.loadFromString(string);
        }
        catch (IOException e) {
            this.LOG.error("", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    protected void internalClear() {
        new File(this.filePath).delete();
    }
}

