/*
 * Decompiled with CFR 0.152.
 */
package com.lostjs.wx4j.context;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lostjs.wx4j.context.BasicWxContext;
import com.lostjs.wx4j.context.WxContext;
import com.lostjs.wx4j.data.SyncKey;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.cookie.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistentWxContext
implements WxContext {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected WxContext internalContext = new BasicWxContext();
    private boolean loaded = false;

    @Override
    public String getSkey() {
        this.lazyLoad();
        return this.internalContext.getSkey();
    }

    @Override
    public void setSkey(String skey) {
        this.lazyLoad();
        this.internalContext.setSkey(skey);
        this.write();
    }

    @Override
    public String getSid() {
        this.lazyLoad();
        return this.internalContext.getSid();
    }

    @Override
    public void setSid(String sid) {
        this.lazyLoad();
        this.internalContext.setSid(sid);
        this.write();
    }

    @Override
    public String getUin() {
        this.lazyLoad();
        return this.internalContext.getUin();
    }

    @Override
    public void setUin(String uin) {
        this.lazyLoad();
        this.internalContext.setUin(uin);
        this.write();
    }

    @Override
    public String getPassTicket() {
        this.lazyLoad();
        return this.internalContext.getPassTicket();
    }

    @Override
    public void setPassTicket(String passTicket) {
        this.lazyLoad();
        this.internalContext.setPassTicket(passTicket);
        this.write();
    }

    @Override
    public String getBaseUrl() {
        this.lazyLoad();
        return this.internalContext.getBaseUrl();
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.lazyLoad();
        this.internalContext.setBaseUrl(baseUrl);
        this.write();
    }

    @Override
    public List<SyncKey> getSyncKeys() {
        this.lazyLoad();
        return this.internalContext.getSyncKeys();
    }

    @Override
    public void setSyncKeys(List<SyncKey> syncKeys) {
        this.lazyLoad();
        this.internalContext.setSyncKeys(syncKeys);
        this.write();
    }

    @Override
    public String getUserName() {
        this.lazyLoad();
        return this.internalContext.getUserName();
    }

    @Override
    public void setUserName(String userName) {
        this.lazyLoad();
        this.internalContext.setUserName(userName);
        this.write();
    }

    @Override
    public List<Cookie> getCookies() {
        this.lazyLoad();
        return this.internalContext.getCookies();
    }

    @Override
    public void setCookies(List<Cookie> cookies) {
        this.lazyLoad();
        this.internalContext.setCookies(cookies);
        this.write();
    }

    public void addCookie(Cookie cookie) {
        this.lazyLoad();
        this.internalContext.addCookie(cookie);
        this.write();
    }

    public boolean clearExpired(Date date) {
        this.lazyLoad();
        boolean success = this.internalContext.clearExpired(date);
        if (success) {
            this.write();
        }
        return success;
    }

    public void clear() {
        this.internalContext.clear();
        this.write();
        this.internalClear();
    }

    protected abstract void write();

    protected abstract void read();

    protected void loadFromString(String string) {
        WxContext webContext;
        if (StringUtils.isBlank((CharSequence)string)) {
            this.LOG.warn("skip load empty context");
            return;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            webContext = (WxContext)objectMapper.readValue(string, BasicWxContext.class);
        }
        catch (IOException e) {
            this.LOG.error("can't load context, use empty context instead");
            this.LOG.debug("", (Throwable)e);
            return;
        }
        this.internalContext.setPassTicket(webContext.getPassTicket());
        this.internalContext.setBaseUrl(webContext.getBaseUrl());
        this.internalContext.setSid(webContext.getSid());
        this.internalContext.setSkey(webContext.getSkey());
        this.internalContext.setSyncKeys(webContext.getSyncKeys());
        this.internalContext.setUin(webContext.getUin());
        this.internalContext.setUserName(webContext.getUserName());
    }

    protected String dumpToString() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writeValueAsString((Object)this.internalContext);
    }

    protected abstract void internalClear();

    private void lazyLoad() {
        if (!this.loaded) {
            this.loaded = true;
            try {
                this.read();
            }
            catch (RuntimeException e) {
                this.clear();
                throw e;
            }
        }
    }
}

