/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.route.strategy;

import com.lenovo.vctl.dal.dao.DaoRecord;
import com.lenovo.vctl.dal.dao.config.GroupConfig;
import com.lenovo.vctl.dal.dao.config.helper.DaoHelper;
import com.lenovo.vctl.dal.dao.config.helper.GroupHelper;
import com.lenovo.vctl.dal.dao.config.model.dao.DbStrategyItem;
import com.lenovo.vctl.dal.dao.config.model.dao.PatternItem;
import com.lenovo.vctl.dal.dao.config.model.group.GroupItem;
import com.lenovo.vctl.dal.dao.exception.StrategyException;
import com.lenovo.vctl.dal.dao.model.LsCacheInfo;
import com.lenovo.vctl.dal.dao.model.MapInfo;
import com.lenovo.vctl.dal.dao.route.strategy.IStrategy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.log4j.Logger;

public class DefaultStrategy
implements IStrategy {
    private static Logger logger = Logger.getLogger(DefaultStrategy.class);
    private static ThreadLocal<Integer> groupIndex = new ThreadLocal();

    @Override
    public Object ListShardingStrategy(String listName, Object account, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByListName(listName);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        if (dbStrategyItem != null) {
            return this.getReadDs(dbStrategyItem, account);
        }
        throw new StrategyException("don't find the DbStrategy!");
    }

    @Override
    public Object ObjectShardingStrategy(Class clazz, Object account, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByClass(clazz);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        if (dbStrategyItem != null) {
            switch (rw) {
                case 1: {
                    return this.getReadDs(dbStrategyItem, account);
                }
                case 2: {
                    return this.getWriteDs(dbStrategyItem, account);
                }
            }
        } else {
            throw new StrategyException("don't find the DbStrategy!");
        }
        return null;
    }

    private String getReadDs(DbStrategyItem dbStrategyItem, Object account) throws StrategyException {
        Map<String, PatternItem> patternMap = dbStrategyItem.getPatternItemMap();
        PatternItem patternItem = this.findPatternItem(patternMap, account);
        return this.getReadDsByPatternItem(patternItem);
    }

    private String getReadDsByPatternItem(PatternItem patternItem) throws StrategyException {
        String groupName;
        GroupItem groupItem;
        Object ds = null;
        if (patternItem != null && (groupItem = GroupHelper.getGroupItem(groupName = patternItem.getGroup())) != null) {
            String dsSalves = groupItem.getSlave();
            if (StringUtils.isEmpty((String)dsSalves)) {
                ds = groupItem.getMaster();
            } else {
                Object[] dss = StringUtils.splitPreserveAllTokens((String)dsSalves, (String)GroupConfig.DASNAME_SEPARATOR);
                if (!ArrayUtils.isEmpty((Object[])dss)) {
                    ds = dss[RandomUtils.nextInt((int)dss.length)];
                }
            }
        }
        if (StringUtils.isEmpty(ds)) {
            throw new StrategyException("don't find the read datasources!");
        }
        return ds;
    }

    private String getWriteDs(DbStrategyItem dbStrategyItem, Object account) throws StrategyException {
        Map<String, PatternItem> patternMap = dbStrategyItem.getPatternItemMap();
        PatternItem patternItem = this.findPatternItem(patternMap, account);
        return this.getWriteDsByPatternItem(patternItem);
    }

    private String getWriteDsByPatternItem(PatternItem patternItem) throws StrategyException {
        String groupName;
        GroupItem groupItem;
        String master = null;
        if (patternItem != null && (groupItem = GroupHelper.getGroupItem(groupName = patternItem.getGroup())) != null) {
            master = groupItem.getMaster();
        }
        if (StringUtils.isEmpty(master)) {
            throw new StrategyException("don't find the write datasources!");
        }
        return master;
    }

    private PatternItem findPatternItem(Map<String, PatternItem> patternMap, Object account) {
        PatternItem patternItem = null;
        if (MapUtils.isNotEmpty(patternMap)) {
            Collection<PatternItem> patternItems = patternMap.values();
            if (patternMap.size() == 1 || account == null) {
                patternItem = patternItems.iterator().next();
            } else {
                for (PatternItem item : patternItems) {
                    Pattern pattern;
                    String value;
                    if (item == null || !StringUtils.isNotEmpty((String)(value = item.getValue())) || !(pattern = Pattern.compile(value)).matcher(ObjectUtils.toString((Object)account)).find()) continue;
                    patternItem = item;
                    break;
                }
            }
        }
        return patternItem;
    }

    @Override
    public Object MapShardingStrategy(String mapName, Object account, int rw) throws StrategyException {
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByMapName(mapName);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        String dsname = null;
        if (dbStrategyItem == null) {
            throw new StrategyException("don't find the DbStrategy!");
        }
        dsname = this.getReadDs(dbStrategyItem, account);
        return dsname;
    }

    @Override
    public boolean isReadWrite(Class clazz, Object account) throws StrategyException {
        String groupName;
        GroupItem groupItem;
        Map<String, PatternItem> patternMap;
        PatternItem patternItem;
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByClass(clazz);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        if (dbStrategyItem != null && (patternItem = this.findPatternItem(patternMap = dbStrategyItem.getPatternItemMap(), account)) != null && (groupItem = GroupHelper.getGroupItem(groupName = patternItem.getGroup())) != null && groupItem.getSlave() != null) {
            return groupItem.getMaster() != groupItem.getSlave();
        }
        return false;
    }

    @Override
    public Object NextListShardingStrategy(String listName, int rw) throws StrategyException {
        Integer gIndex = groupIndex.get();
        gIndex = gIndex == null ? 0 : gIndex;
        String ds = null;
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByListName(listName);
        if (dbStrategyItem == null) {
            dbStrategyItem = DaoHelper.getDefaultDbStrategyItem();
        }
        if (dbStrategyItem != null) {
            List<PatternItem> patternList = dbStrategyItem.getPatternItemList();
            if (patternList != null && patternList.size() > gIndex) {
                PatternItem patternItem = patternList.get(gIndex);
                gIndex = gIndex + 1;
                groupIndex.set(gIndex);
                ds = this.getReadDsByPatternItem(patternItem);
            } else {
                groupIndex.remove();
            }
        }
        return ds;
    }

    @Override
    public Object ListShardingStrategy(String listName, Object account, Object[] params, int rw) throws StrategyException {
        int temp_rw = rw == 2 ? rw : (this.isMasterForList(listName, params) ? 2 : rw);
        return this.ListShardingStrategy(listName, account, temp_rw);
    }

    @Override
    public Object MapShardingStrategy(String mapingName, Object account, Object[] params, int rw) throws StrategyException {
        int temp_rw = rw == 2 ? rw : (this.isMasterForMap(mapingName, params) ? 2 : rw);
        return this.MapShardingStrategy(mapingName, account, temp_rw);
    }

    @Override
    public Object ObjectShardingStrategy(Class clazz, Object account, Object id, int rw) throws StrategyException {
        int temp_rw = rw == 2 ? rw : (this.isMasterForObject(clazz, id) ? 2 : rw);
        return this.ObjectShardingStrategy(clazz, account, temp_rw);
    }

    private boolean isMasterForList(String listName, Object[] params) {
        LsCacheInfo lsInfo;
        DaoRecord record = DaoRecord.getInstance();
        return record.hasNewObjectAddToList(lsInfo = new LsCacheInfo(listName, params)) || record.hasObjectRemoveFromList(lsInfo);
    }

    private boolean isMasterForObject(Class clazz, Object id) {
        String identity;
        String entityName;
        DaoRecord record = DaoRecord.getInstance();
        return record.isNowDeleted(entityName = clazz.getName(), identity = ObjectUtils.toString((Object)id)) || record.isNowSaved(entityName, identity) || record.isNowUpdate(entityName, identity);
    }

    private boolean isMasterForMap(String mappingName, Object[] params) {
        DaoRecord record = DaoRecord.getInstance();
        MapInfo info = new MapInfo(mappingName, params);
        return record.isMappingChange(info);
    }
}

