/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.impl;

import com.lenovo.vctl.dal.dao.DBAgent;
import com.lenovo.vctl.dal.dao.config.helper.DaoHelper;
import com.lenovo.vctl.dal.dao.exception.DaoException;
import com.lenovo.vctl.dal.dao.model.ScalarInfo;
import com.lenovo.vctl.dal.dao.model.SqlInfo;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class DBAgentHibernateImpl
implements DBAgent {
    Log log = LogFactory.getLog(DBAgentHibernateImpl.class);
    private static DBAgent dbAgent;
    public static final int DEFAULT_SIZE = 5000;
    private SessionFactory sessionFactory = DaoHelper.getSessionFactory();
    private HibernateTemplate hibernateTemplate = new HibernateTemplate(this.sessionFactory);

    private DBAgentHibernateImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBAgent getInstance() {
        if (dbAgent != null) return dbAgent;
        Class<DBAgentHibernateImpl> clazz = DBAgentHibernateImpl.class;
        synchronized (DBAgentHibernateImpl.class) {
            dbAgent = new DBAgentHibernateImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbAgent;
        }
    }

    @Override
    public Serializable save(Object account_id, Object object) throws Exception {
        Serializable id = null;
        id = this.hibernateTemplate.save(object);
        if (id != null && id.toString().equals("0")) {
            this.log.error((Object)("save object error " + object.getClass().getName() + ",id=" + id));
        }
        return id;
    }

    @Override
    public Map save(Object account_id, final List obs) throws Exception {
        Map map = (Map)this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HashMap idObjMap = new HashMap();
                Transaction trans = session.beginTransaction();
                try {
                    Serializable id = null;
                    for (Object obj : obs) {
                        id = session.save(obj);
                        idObjMap.put(id, obj);
                    }
                    session.flush();
                    session.clear();
                    trans.commit();
                }
                catch (Exception e) {
                    trans.rollback();
                }
                return idObjMap;
            }
        });
        return map;
    }

    @Override
    public boolean update(Object account_id, Object object) throws Exception {
        this.hibernateTemplate.update(object);
        return true;
    }

    @Override
    public boolean delete(Object account_id, Object obj) throws Exception {
        this.hibernateTemplate.delete(obj);
        return true;
    }

    @Override
    public int count(Object account_id, String listName, final SqlInfo sqlInfo) throws Exception {
        Object count = this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery query = session.createSQLQuery(sqlInfo.getSql());
                if (sqlInfo.getParams() != null && sqlInfo.getParams().length > 0) {
                    int i = 0;
                    Object[] objectArray = sqlInfo.getParams();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object id = objectArray[n2];
                        if (id != null) {
                            query.setParameter(i++, id);
                        }
                        ++n2;
                    }
                }
                return query.uniqueResult();
            }
        });
        if (count == null) {
            return 0;
        }
        return new Long("" + count).intValue();
    }

    @Override
    public Object get(Object account_id, Class clazz, Serializable id) throws DaoException {
        return this.hibernateTemplate.get(clazz, id);
    }

    @Override
    public List getIdList(Object account_id, String listName, final SqlInfo sqlInfo, final Integer start, final Integer count) throws Exception {
        ArrayList list = null;
        list = (ArrayList)this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery query = session.createSQLQuery(sqlInfo.getSql());
                if (sqlInfo.getScalarList() != null && sqlInfo.getScalarList().size() > 0) {
                    for (ScalarInfo scaInfo : sqlInfo.getScalarList()) {
                        if (scaInfo.getColumnType() == null) {
                            query.addScalar(scaInfo.getColumnName());
                            continue;
                        }
                        query.addScalar(scaInfo.getColumnName(), scaInfo.getColumnType());
                    }
                }
                if (sqlInfo.getParams() != null && sqlInfo.getParams().length > 0) {
                    int i = 0;
                    Object[] objectArray = sqlInfo.getParams();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object id = objectArray[n2];
                        if (id != null) {
                            query.setParameter(i++, id);
                        }
                        ++n2;
                    }
                }
                query.setFirstResult(start.intValue());
                query.setMaxResults(count.intValue());
                return query.list();
            }
        });
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    @Override
    public Object getMapping(Object account_id, String listName, final SqlInfo sqlInfo) throws Exception {
        return this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery query = session.createSQLQuery(sqlInfo.getSql());
                if (sqlInfo.getScalarList() != null && sqlInfo.getScalarList().size() > 0) {
                    for (ScalarInfo scaInfo : sqlInfo.getScalarList()) {
                        if (scaInfo.getColumnType() == null) {
                            query.addScalar(scaInfo.getColumnName());
                            continue;
                        }
                        query.addScalar(scaInfo.getColumnName(), scaInfo.getColumnType());
                    }
                }
                if (sqlInfo.getParams() != null && sqlInfo.getParams().length > 0) {
                    int i = 0;
                    Object[] objectArray = sqlInfo.getParams();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object id = objectArray[n2];
                        if (id != null) {
                            query.setParameter(i++, id);
                        }
                        ++n2;
                    }
                }
                return query.uniqueResult();
            }
        });
    }

    @Override
    public List getObjectList(Object account_id, String listName, final SqlInfo sqlInfo) throws Exception {
        ArrayList list = (ArrayList)this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery query = session.createSQLQuery(sqlInfo.getSql());
                if (sqlInfo.getScalarList() != null && sqlInfo.getScalarList().size() > 0) {
                    for (ScalarInfo scaInfo : sqlInfo.getScalarList()) {
                        if (scaInfo.getColumnType() == null) {
                            query.addScalar(scaInfo.getColumnName());
                            continue;
                        }
                        query.addScalar(scaInfo.getColumnName(), scaInfo.getColumnType());
                    }
                }
                if (sqlInfo.getParams() != null && sqlInfo.getParams().length > 0) {
                    int i = 0;
                    Object[] objectArray = sqlInfo.getParams();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object id = objectArray[n2];
                        if (id != null) {
                            query.setParameter(i++, id);
                        }
                        ++n2;
                    }
                }
                return query.list();
            }
        });
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    @Override
    public List getEntityList(Object account_id, final Class cls, final SqlInfo sqlInfo, int strategy) throws DaoException {
        ArrayList list = (ArrayList)this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery query = session.createSQLQuery(sqlInfo.getSql()).addEntity(cls);
                if (sqlInfo.getParams() != null && sqlInfo.getParams().length > 0) {
                    int i = 0;
                    Object[] objectArray = sqlInfo.getParams();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object id = objectArray[n2];
                        if (id != null) {
                            query.setParameter(i++, id);
                        }
                        ++n2;
                    }
                }
                return query.list();
            }
        });
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    private void processException(Exception e) throws DaoException {
        if (e instanceof MappingException) {
            throw new DaoException(401, e);
        }
        if (e instanceof NullPointerException) {
            throw new DaoException(303, e);
        }
        if (e instanceof SQLException) {
            throw new DaoException(500, e);
        }
        if (e instanceof HibernateException) {
            throw new DaoException(400, e);
        }
        if (e instanceof DaoException) {
            throw (DaoException)e;
        }
        throw new DaoException(e);
    }
}

