/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.impl;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.MaxIdHolder;
import com.lenovo.vctl.dal.cache.NullObjectContent;
import com.lenovo.vctl.dal.dao.Dao;
import com.lenovo.vctl.dal.dao.DaoRecord;
import com.lenovo.vctl.dal.dao.Listener;
import com.lenovo.vctl.dal.dao.config.helper.DaoHelper;
import com.lenovo.vctl.dal.dao.exception.DaoException;
import com.lenovo.vctl.dal.dao.helper.LogHelper;
import com.lenovo.vctl.dal.dao.impl.HibernateDaoImpl;
import com.lenovo.vctl.dal.dao.listener.DefaultListener;
import com.lenovo.vctl.dal.dao.model.LsCacheInfo;
import com.lenovo.vctl.dal.dao.model.MapInfo;
import com.lenovo.vctl.dal.dao.util.CacheHelper;
import com.lenovo.vctl.dal.dao.util.DalAssert;
import com.lenovo.vctl.dal.dao.util.ObjectUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.type.TypeFactory;

public class CompositeDaoImpl
implements Dao {
    private static final int singleUsedTime = 15;
    private static final int lotsUsedTime = 50;
    private Log permLog = LogFactory.getLog((String)"DalPerformance");
    private Log log = LogFactory.getLog(CompositeDaoImpl.class);
    private Dao dao = new HibernateDaoImpl();
    private Listener listener = new DefaultListener();
    DaoRecord record = DaoRecord.getInstance();

    public CompositeDaoImpl() {
        this.listener = new DefaultListener();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public Serializable save(Object account_id, Object object) throws DaoException {
        Serializable id;
        block15: {
            DalAssert.assertObjectNotNull(object);
            DalAssert.assertObjectIllegal(account_id, object);
            id = null;
            this.listener.onSaveBegin(account_id, object);
            id = this.dao.save(account_id, object);
            if (id != null) break block15;
            LogHelper.savedError(this.log, object);
            Serializable serializable = id;
            try {
                this.listener.onSaveEnd(account_id, id, object);
            }
            catch (Exception e) {
                this.processException(e);
            }
            return serializable;
        }
        try {
            try {
                if (id.toString().equals("0")) {
                    Class<?> c = null;
                    if (object != null) {
                        c = object.getClass();
                    }
                    this.log.error((Object)("error:save object id =" + id + ",class=" + c));
                }
                this.listener.onSaveCompleted((Serializable)account_id, object.getClass(), id, object);
            }
            catch (Exception e) {
                this.listener.onSaveError(account_id, id, object);
                this.processException(e);
                try {
                    this.listener.onSaveEnd(account_id, id, object);
                }
                catch (Exception e2) {
                    this.processException(e2);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                this.listener.onSaveEnd(account_id, id, object);
            }
            catch (Exception e) {
                this.processException(e);
            }
            throw throwable;
        }
        try {
            this.listener.onSaveEnd(account_id, id, object);
        }
        catch (Exception e) {
            this.processException(e);
        }
        return id;
    }

    @Override
    public Serializable save(Object object) throws DaoException {
        return this.save(null, object);
    }

    @Override
    public List save(Object account_id, List objects) throws DaoException {
        DalAssert.assertObjectNotNull(objects);
        DalAssert.assertListIllegal(account_id, objects);
        ArrayList objList = new ArrayList();
        for (Object obj : objects) {
            if (obj == null) continue;
            this.save(account_id, obj);
            objList.add(obj);
        }
        return objList;
    }

    @Override
    public List save(List objects) throws DaoException {
        return this.save(null, objects);
    }

    @Override
    public List batchSave(Object account_id, List objList) throws DaoException {
        DalAssert.assertObjectNotNull(objList);
        ArrayList<Object> resList = new ArrayList<Object>();
        Map<Serializable, Object> idObjMap = null;
        try {
            try {
                this.listener.onBatchSaveBegin(account_id, objList);
                idObjMap = ((HibernateDaoImpl)this.dao).batchSaveReturnMap(account_id, objList);
                for (Map.Entry<Serializable, Object> entry : idObjMap.entrySet()) {
                    Serializable id = entry.getKey();
                    resList.add(idObjMap.get(id));
                }
                this.listener.onBatchSaveCompleted((Serializable)account_id, objList.get(0).getClass(), idObjMap);
            }
            catch (Exception e) {
                this.processException(e);
                this.listener.onBatchSaveEnd(account_id, objList);
            }
        }
        finally {
            this.listener.onBatchSaveEnd(account_id, objList);
        }
        return resList;
    }

    @Override
    public List batchSave(List objList) throws DaoException {
        return this.batchSave(null, objList);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean update(Object account_id, Object object) throws DaoException {
        block27: {
            block26: {
                block25: {
                    DalAssert.assertObjectNotNull(object);
                    DalAssert.assertObjectIllegal(account_id, object);
                    t1 = System.currentTimeMillis();
                    bUpdated = true;
                    bLock = false;
                    oldObject = null;
                    objectId = null;
                    objectId = ObjectUtil.getObjectId(object);
                    if (objectId != null) break block25;
                    LogHelper.failedGetObjectId(this.log, object);
                    var11_8 = bUpdated;
                    try {
                        if (bLock) {
                            this.listener.onUpdateEnd(account_id, objectId, object, oldObject);
                        }
                    }
                    catch (Exception e) {
                        this.processException(e);
                    }
                    return var11_8;
                }
                oldObject = this.get(account_id, object.getClass(), objectId);
                if (oldObject != null) break block26;
                LogHelper.failedGetObjectById(this.log, account_id, object.getClass(), objectId);
                var11_9 = bUpdated;
                try {
                    if (bLock) {
                        this.listener.onUpdateEnd(account_id, objectId, object, oldObject);
                    }
                }
                catch (Exception e) {
                    this.processException(e);
                }
                return var11_9;
            }
            bLock = true;
            this.listener.onUpdateBegin(account_id, objectId, object, oldObject);
            bUpdated = this.dao.update(account_id, object);
            if (bUpdated) break block27;
            LogHelper.updateError(this.log, object);
            var11_10 = bUpdated;
            try {
                if (bLock) {
                    this.listener.onUpdateEnd(account_id, objectId, object, oldObject);
                }
            }
            catch (Exception e) {
                this.processException(e);
            }
            return var11_10;
        }
        try {
            try {
                this.listener.onUpdateCompleted(account_id, objectId, object, oldObject);
            }
            catch (Exception e) {
                this.listener.onUpdateError(account_id, objectId, object, oldObject);
                this.processException(e);
                try {
                    if (!bLock) ** GOTO lbl78
                    this.listener.onUpdateEnd(account_id, objectId, object, oldObject);
                }
                catch (Exception e) {
                    this.processException(e);
                }
            }
        }
        catch (Throwable var10_19) {
            try {
                if (bLock) {
                    this.listener.onUpdateEnd(account_id, objectId, object, oldObject);
                }
            }
            catch (Exception e) {
                this.processException(e);
            }
            throw var10_19;
        }
        try {
            if (bLock) {
                this.listener.onUpdateEnd(account_id, objectId, object, oldObject);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
lbl78:
        // 5 sources

        if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: update region: " + object.getClass().getName() + " params: " + objectId + " time: " + usedTime));
        }
        return bUpdated;
    }

    @Override
    public boolean update(Object object) throws DaoException {
        return this.update(null, object);
    }

    @Override
    public boolean batchUpdate(Object account_id, List objects) throws DaoException {
        DalAssert.assertObjectNotNull(objects);
        DalAssert.assertListIllegal(account_id, objects);
        boolean bUpdated = true;
        try {
            for (Object obj : objects) {
                this.update(account_id, obj);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return bUpdated;
    }

    @Override
    public boolean batchUpdate(List objects) throws DaoException {
        return this.batchUpdate(null, objects);
    }

    @Override
    public boolean delete(Object account_id, Class clazz, Serializable id) throws DaoException {
        return this.realDelete(account_id, clazz, id, true);
    }

    @Override
    public boolean delete(Class clazz, Serializable id) throws DaoException {
        return this.delete(null, clazz, id);
    }

    @Override
    public boolean fakeDelete(Object account_id, Class clazz, Serializable id) throws DaoException {
        return this.realDelete(account_id, clazz, id, false);
    }

    @Override
    public boolean fakeDelete(Class clazz, Serializable id) throws DaoException {
        return this.fakeDelete(null, clazz, id);
    }

    private boolean realDelete(Object account_id, Class clazz, Serializable id, boolean delFlag) throws DaoException {
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(id);
        long t1 = System.currentTimeMillis();
        boolean bDeleted = true;
        Object obj = null;
        try {
            obj = this.get(account_id, clazz, id);
            if (obj == null) {
                LogHelper.failedGetObjectById(this.log, account_id, clazz, id);
                return bDeleted;
            }
            this.listener.onDeleteBegin(account_id, id, obj);
            bDeleted = delFlag ? this.dao.delete(account_id, clazz, id) : this.dao.fakeDelete(account_id, clazz, id);
            if (!bDeleted) {
                LogHelper.deleteError(this.log, clazz, account_id, id, delFlag);
                return delFlag;
            }
            this.listener.onDeleteCompleted(account_id, id, obj);
        }
        catch (Exception e) {
            this.listener.onDeleteError(account_id, id, obj);
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: realDelete region: " + clazz.getName() + " params: " + id + " time: " + usedTime));
        }
        return bDeleted;
    }

    private boolean realDeleteList(Object account_id, Class clazz, List ids, boolean delFlag) throws DaoException {
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(ids);
        boolean bDeleted = true;
        try {
            for (Object id : ids) {
                this.realDelete(account_id, clazz, (Serializable)id, delFlag);
            }
        }
        catch (Exception e) {
            bDeleted = false;
            this.processException(e);
        }
        return bDeleted;
    }

    @Override
    public boolean deleteList(Object account_id, Class clazz, List ids) throws DaoException {
        return this.realDeleteList(account_id, clazz, ids, true);
    }

    @Override
    public boolean deleteList(Class clazz, List ids) throws DaoException {
        return this.deleteList(null, clazz, ids);
    }

    @Override
    public boolean fakeDeleteList(Object account_id, Class clazz, List ids) throws DaoException {
        return this.realDeleteList(account_id, clazz, ids, false);
    }

    @Override
    public boolean fakeDeleteList(Class clazz, List ids) throws DaoException {
        return this.fakeDeleteList(null, clazz, ids);
    }

    @Override
    public boolean deleteList(Object account_id, String list_name, Object[] params) throws DaoException {
        boolean res;
        block3: {
            String clsName;
            List idList;
            block4: {
                DalAssert.assertObjectNotNull(list_name);
                DalAssert.assertObjectNotNull(params);
                res = true;
                idList = this.getIdList(account_id, list_name, params);
                if (idList == null || idList.size() <= 0) break block3;
                clsName = DaoHelper.getObjectNameByListName(list_name);
                if (!StringUtils.isEmpty((String)clsName)) break block4;
                this.log.error((Object)("find class name is empty or null by list name" + StringUtils.defaultIfEmpty((String)list_name, (String)"")));
                return true;
            }
            try {
                res = this.deleteList(account_id, Class.forName(clsName), idList);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        return res;
    }

    @Override
    public boolean deleteList(String list_name, Object[] params) throws DaoException {
        return this.deleteList((Object)null, list_name, params);
    }

    @Override
    public boolean deleteList(Object account_id, String list_name, Object param) throws DaoException {
        if (param == null) {
            return this.deleteList(account_id, list_name, new Object[0]);
        }
        return this.deleteList(account_id, list_name, new Object[]{param});
    }

    @Override
    public boolean deleteList(String list_name, Object param) throws DaoException {
        return this.deleteList(null, list_name, param);
    }

    @Override
    public boolean fakeDeleteList(Object account_id, String list_name, Object[] params) throws DaoException {
        boolean res;
        block3: {
            String clsName;
            List idList;
            block4: {
                DalAssert.assertObjectNotNull(list_name);
                DalAssert.assertObjectNotNull(params);
                res = true;
                idList = this.getIdList(account_id, list_name, params);
                if (idList == null || idList.size() <= 0) break block3;
                clsName = DaoHelper.getObjectNameByListName(list_name);
                if (!StringUtils.isEmpty((String)clsName)) break block4;
                this.log.error((Object)("find class name is empty or null by " + StringUtils.defaultIfEmpty((String)list_name, (String)"")));
                return true;
            }
            try {
                res = this.realDeleteList(account_id, Class.forName(clsName), idList, false);
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        return res;
    }

    @Override
    public boolean fakeDeleteList(String list_name, Object[] params) throws DaoException {
        return this.fakeDeleteList((Object)null, list_name, params);
    }

    @Override
    public boolean fakeDeleteList(Object account_id, String list_name, Object param) throws DaoException {
        if (param == null) {
            return this.fakeDeleteList(account_id, list_name, new Object[0]);
        }
        return this.fakeDeleteList(account_id, list_name, new Object[]{param});
    }

    @Override
    public boolean fakeDeleteList(String list_name, Object param) throws DaoException {
        return this.fakeDeleteList(null, list_name, param);
    }

    @Override
    public Object get(Object account_id, Class clazz, Serializable id) throws DaoException {
        Object obj;
        long t1;
        block9: {
            block10: {
                DalAssert.assertClassTypeNotNull(clazz);
                DalAssert.assertObjectNotNull(id);
                t1 = System.currentTimeMillis();
                obj = null;
                Cache cache = CacheHelper.getClassCache(clazz);
                if (cache == null) {
                    obj = this.dao.get(account_id, clazz, id);
                    break block9;
                }
                if (!CacheHelper.isDelete(clazz.getName(), "" + id)) break block10;
                LogHelper.objectHasBeenDeleted(this.log, clazz, id);
                return null;
            }
            try {
                obj = CacheHelper.get(clazz.getName(), "" + id);
                if (obj == null) {
                    Long maxId = MaxIdHolder.getMaxId((String)("MaxId_" + clazz.getName()));
                    Long newId = new Long("" + id);
                    if (!(newId > maxId && maxId >= 0L || NullObjectContent.isNull((String)("NULL_" + clazz.getName() + newId)))) {
                        obj = this.dao.get(account_id, clazz, id);
                        if (obj != null) {
                            CacheHelper.put(clazz.getName(), "" + id, obj);
                        } else {
                            NullObjectContent.setNull((String)("NULL_" + clazz.getName() + newId));
                        }
                    }
                }
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: get region: " + clazz.getName() + " params: " + id + " time: " + usedTime));
        }
        return obj;
    }

    @Override
    public Object get(Class clazz, Serializable id) throws DaoException {
        return this.get(null, clazz, id);
    }

    @Override
    public Object getMapping(Object account_id, String mappingName, Object[] params) throws DaoException {
        long usedTime;
        DalAssert.assertObjectNotNull(mappingName);
        DalAssert.assertObjectNotNull(params);
        long t1 = System.currentTimeMillis();
        Object obj = null;
        try {
            Cache cache = CacheHelper.getListCache(mappingName);
            if (cache == null) {
                return this.dao.getMapping(account_id, mappingName, params);
            }
            MapInfo info = new MapInfo(mappingName, params);
            obj = CacheHelper.get(info.getRegion(), info.getKey());
            if (obj == null && !NullObjectContent.isNull((String)("NULL__" + info.getRegion() + "_" + info.getKey()))) {
                obj = this.dao.getMapping(account_id, mappingName, params);
                if (obj != null) {
                    CacheHelper.put(info.getRegion(), info.getKey(), obj);
                } else {
                    NullObjectContent.setNull((String)("NULL__" + info.getRegion() + "_" + info.getKey()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.processException(e);
        }
        if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: getRealMapping region: " + mappingName + " size: " + params.length + " time: " + usedTime));
        }
        return obj;
    }

    @Override
    public Object getMapping(String mappingName, Object[] keys) throws DaoException {
        return this.getMapping((Object)null, mappingName, keys);
    }

    @Override
    public Object getMapping(Object account_id, String mappingName, Object key) throws DaoException {
        if (key == null) {
            return this.getMapping(account_id, mappingName, new Object[0]);
        }
        return this.getMapping(account_id, mappingName, new Object[]{key});
    }

    @Override
    public Object getMapping(String mappingName, Object key) throws DaoException {
        return this.getMapping(null, mappingName, key);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int count(Object account_id, String listName, Object[] params) throws DaoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 22[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int count(String list_name, Object[] params) throws DaoException {
        return this.count((Object)null, list_name, params);
    }

    @Override
    public int count(Object account_id, String list_name, Object param) throws DaoException {
        if (param == null) {
            return this.count(account_id, list_name, new Object[0]);
        }
        return this.count(account_id, list_name, new Object[]{param});
    }

    @Override
    public int count(String list_name, Object param) throws DaoException {
        return this.count(null, list_name, param);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List getIdList(Object account_id, String listName, Object[] params, Integer start, Integer count) throws DaoException {
        block44: {
            block40: {
                block43: {
                    block41: {
                        block42: {
                            block38: {
                                block39: {
                                    block36: {
                                        block37: {
                                            block34: {
                                                block35: {
                                                    DalAssert.assertObjectNotNull(listName);
                                                    DalAssert.assertObjectNotNull(params);
                                                    DalAssert.assertObjectNotNull(start);
                                                    DalAssert.assertObjectNotNull(count);
                                                    idList = null;
                                                    cache = null;
                                                    key = null;
                                                    lock = null;
                                                    toIndex = start + count;
                                                    lsInfo = new LsCacheInfo(listName, params);
                                                    type = TypeFactory.basic((String)DaoHelper.getListItemValueClass(listName).getName());
                                                    bLoadUsingDB = true;
                                                    listItem = DaoHelper.getListItemByListName(listName);
                                                    cache = CacheHelper.getListCache(listName);
                                                    if (cache == null || CollectionUtils.isNotEmpty(idList = cache.lrange(key = lsInfo.getKey(), start.intValue(), start + count)) && ObjectUtils.equals((Object)idList.size(), (Object)count)) ** GOTO lbl97
                                                    iCount = this.count(account_id, listName, params);
                                                    if (iCount != 0) break block34;
                                                    var19_19 = new ArrayList<E>();
                                                    if (lock == null) break block35;
                                                    try {
                                                        this.record.endListLoading(lsInfo, lock);
                                                    }
                                                    catch (Exception e) {
                                                        e.printStackTrace(System.out);
                                                    }
                                                }
                                                return var19_19;
                                            }
                                            if (start <= iCount) break block36;
                                            var19_20 = new ArrayList<E>();
                                            if (lock == null) break block37;
                                            try {
                                                this.record.endListLoading(lsInfo, lock);
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace(System.out);
                                            }
                                        }
                                        return var19_20;
                                    }
                                    if (toIndex >= iCount) {
                                        toIndex = iCount;
                                    }
                                    if (start < toIndex) break block38;
                                    var19_21 = new ArrayList<E>();
                                    if (lock == null) break block39;
                                    try {
                                        this.record.endListLoading(lsInfo, lock);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace(System.out);
                                    }
                                }
                                return var19_21;
                            }
                            if (!CollectionUtils.isEmpty(idList)) break block40;
                            if (cache.get(key) != null || (lock = this.record.checkListLoading(lsInfo)) == null) ** GOTO lbl97
                            totalList = this.dao.getIdList(account_id, listName, params, (Integer)0, (Integer)listItem.getInitLen());
                            if (!CollectionUtils.isEmpty((Collection)totalList)) break block41;
                            this.log.warn((Object)("[id list is empty] listName:" + listName + "  key:" + key));
                            var19_22 = new ArrayList<E>();
                            if (lock == null) break block42;
                            try {
                                this.record.endListLoading(lsInfo, lock);
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                            }
                        }
                        return var19_22;
                    }
                    cache.setList(key, totalList);
                    if (totalList.size() < toIndex) ** GOTO lbl97
                    subList = new ArrayList<E>();
                    subList.addAll(totalList.subList(start, toIndex));
                    var19_23 = subList;
                    if (lock == null) break block43;
                    try {
                        this.record.endListLoading(lsInfo, lock);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
                return var19_23;
            }
            try {
                try {
                    if (toIndex > cache.lsize(key)) {
                        idList = null;
                    }
lbl97:
                    // 6 sources

                    if (CollectionUtils.isNotEmpty(idList)) {
                        if (type == Hibernate.LONG) {
                            resList = new ArrayList<Long>();
                            for (E idObj : idList) {
                                resList.add(Long.parseLong("" + idObj));
                            }
                            idList = resList;
                            break block44;
                        }
                        if (type != Hibernate.INTEGER) break block44;
                        resList = new ArrayList<Long>();
                        for (E idObj : idList) {
                            resList.add(Long.parseLong("" + idObj));
                        }
                        idList = resList;
                        break block44;
                    }
                    idList = this.dao.getIdList(account_id, listName, params, start, count);
                }
                catch (Exception e) {
                    this.processException(e);
                    if (lock == null) ** GOTO lbl143
                    try {
                        this.record.endListLoading(lsInfo, lock);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            catch (Throwable var18_36) {
                if (lock != null) {
                    try {
                        this.record.endListLoading(lsInfo, lock);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
                throw var18_36;
            }
        }
        if (lock != null) {
            try {
                this.record.endListLoading(lsInfo, lock);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
lbl143:
        // 7 sources

        if (idList == null) {
            idList = new ArrayList<E>();
        }
        return idList;
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object[] params) throws DaoException {
        Integer totalCount = this.count(account_id, list_name, params);
        return this.getIdList(account_id, list_name, params, (Integer)0, totalCount);
    }

    @Override
    public List getIdList(String list_name, Object[] params) throws DaoException {
        return this.getIdList((Object)null, list_name, params);
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object param) throws DaoException {
        if (param == null) {
            return this.getIdList(account_id, list_name, new Object[0]);
        }
        return this.getIdList(account_id, list_name, new Object[]{param});
    }

    @Override
    public List getIdList(String list_name, Object param) throws DaoException {
        return this.getIdList(null, list_name, param);
    }

    @Override
    public List getIdList(String list_name, Object[] params, Integer start, Integer count) throws DaoException {
        return this.getIdList((Object)null, list_name, params, start, count);
    }

    @Override
    public List getIdList(Object account_id, String list_name, Object param, Integer start, Integer count) throws DaoException {
        if (param == null) {
            return this.getIdList(account_id, list_name, new Object[0], start, count);
        }
        return this.getIdList(account_id, list_name, new Object[]{param}, start, count);
    }

    @Override
    public List getIdList(String list_name, Object param, Integer start, Integer count) throws DaoException {
        return this.getIdList(null, list_name, param, start, count);
    }

    @Override
    public List getIdList(Object accountId, String mapName, List<Object[]> paramsList) throws DaoException {
        List list = this.getMappings(accountId, mapName, paramsList);
        int i = 0;
        while (i < list.size()) {
            list.remove(i);
            ++i;
        }
        return list;
    }

    @Override
    public List getIdList(String mapName, List<Object[]> paramsList) throws DaoException {
        return this.getIdList(null, mapName, paramsList);
    }

    @Override
    public List<List> getAggrIdList(Object account_id, String list_name, List<Object[]> paramsList, int start, int count) throws DaoException {
        List<List<List>> objList;
        block12: {
            objList = new ArrayList<List>();
            if (paramsList == null || paramsList.size() < 1) {
                this.log.warn((Object)" paramsList is empty");
                return objList;
            }
            try {
                Cache cache = CacheHelper.getListCache(list_name);
                if (cache == null) {
                    objList = this.dao.getAggrIdList(account_id, list_name, paramsList, start, count);
                    break block12;
                }
                ArrayList<Object[]> unExistList = new ArrayList<Object[]>();
                ArrayList<Integer> indexLs = new ArrayList<Integer>();
                Object[] keyArray = new Object[paramsList.size()];
                Object[] startArray = new Object[paramsList.size()];
                Object[] countArray = new Object[paramsList.size()];
                int i = 0;
                while (i < paramsList.size()) {
                    LsCacheInfo lsInfo = new LsCacheInfo(list_name, paramsList.get(i));
                    keyArray[i] = lsInfo.getKey();
                    startArray[i] = start;
                    countArray[i] = count;
                    ++i;
                }
                Object obs = null;
                int i2 = 0;
                while (i2 < (obs).length) {
                    void object = obs[i2];
                    if (object == null) {
                        indexLs.add(i2);
                        unExistList.add(paramsList.get(i2));
                    }
                    ++i2;
                }
                if (unExistList.size() > 0) {
                    i2 = 0;
                    while (i2 < unExistList.size()) {
                        List newIdList = this.dao.getIdList(account_id, list_name, (Object[])unExistList.get(i2), (Integer)start, (Integer)count);
                        if (newIdList.size() > 0) {
                            obs[((Integer)indexLs.get((int)i2)).intValue()] = newIdList;
                        }
                        ++i2;
                    }
                }
                if (obs != null && (obs).length > 0) {
                    Object var17_21 = obs;
                    int n = (var17_21).length;
                    int n2 = 0;
                    while (n2 < n) {
                        void obj = var17_21[n2];
                        objList.add((List)obj);
                        ++n2;
                    }
                    return objList;
                }
                return objList;
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        return objList;
    }

    @Override
    public List getList(Object account_id, Class clazz, List ids) throws DaoException {
        DalAssert.assertClassTypeNotNull(clazz);
        DalAssert.assertObjectNotNull(ids);
        long t1 = System.currentTimeMillis();
        List<Object> objList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            this.log.warn((Object)" id list is empty");
            return objList;
        }
        try {
            Cache cache = CacheHelper.getClassCache(clazz);
            if (cache == null) {
                objList = this.dao.getList(account_id, clazz, ids);
            } else {
                List newObjLs;
                Object value;
                ArrayList<String> idStrList = new ArrayList<String>();
                ArrayList daoIds = new ArrayList();
                HashMap indexIdMap = new HashMap();
                for (Object id : ids) {
                    idStrList.add("" + id);
                }
                Object[] obs = cache.get(idStrList.toArray(new String[idStrList.size()]));
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                int i = 0;
                while (i < obs.length) {
                    value = obs[i];
                    String idStr = (String)idStrList.get(i);
                    resultMap.put(idStr, value);
                    if (value == null && !NullObjectContent.isNull((String)("NULL_" + clazz.getName() + idStr))) {
                        daoIds.add(ids.get(i));
                    }
                    ++i;
                }
                if (CollectionUtils.isNotEmpty(daoIds) && CollectionUtils.isNotEmpty((Collection)(newObjLs = this.dao.getList(account_id, clazz, daoIds)))) {
                    Cache objCache = CacheHelper.getClassCache(clazz);
                    for (Object object : newObjLs) {
                        if (object == null) continue;
                        Long id = (Long)ObjectUtil.getObjectId(object);
                        if (id != null) {
                            resultMap.put(id.toString(), object);
                            objCache.put(id.toString(), object);
                            continue;
                        }
                        this.log.error((Object)("don't find the id for " + object.getClass()));
                    }
                }
                i = 0;
                while (i < idStrList.size()) {
                    value = resultMap.get(idStrList.get(i));
                    if (value != null) {
                        objList.add(value);
                    }
                    ++i;
                }
            }
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: getList region: " + clazz.getName() + " size: " + ids.size() + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return objList;
    }

    @Override
    public List getList(Class clazz, List ids) throws DaoException {
        return this.getList(null, clazz, ids);
    }

    @Override
    public List getMappings(Object accountId, String mapName, List<Object[]> paramsList) throws DaoException {
        DalAssert.assertObjectNotNull(mapName);
        DalAssert.assertObjectNotNull(paramsList);
        long t1 = System.currentTimeMillis();
        try {
            long usedTime;
            List newObjLs;
            Object[] obs2;
            Cache cache = CacheHelper.getListCache(mapName);
            if (cache == null) {
                return this.dao.getMappings(accountId, mapName, paramsList);
            }
            ArrayList<Object[]> unExistList = new ArrayList<Object[]>();
            ArrayList<String> mapKeyList = new ArrayList<String>();
            ArrayList<Integer> indexLs = new ArrayList<Integer>();
            for (Object[] obs2 : paramsList) {
                MapInfo mapInfo = new MapInfo(mapName, obs2);
                mapKeyList.add(mapInfo.getKey());
            }
            obs2 = cache.get(mapKeyList.toArray(new String[mapKeyList.size()]));
            if (obs2 == null || 1 == obs2.length) {
                int j = 0;
                while (j < paramsList.size()) {
                    indexLs.add(j);
                    unExistList.add(paramsList.get(j));
                    ++j;
                }
            } else {
                int i = 0;
                while (i < obs2.length) {
                    Object object = obs2[i];
                    if (object == null) {
                        indexLs.add(i);
                        unExistList.add(paramsList.get(i));
                    }
                    ++i;
                }
            }
            if (unExistList.size() > 0 && (newObjLs = this.dao.getMappings(accountId, mapName, unExistList)).size() > 0) {
                if (newObjLs.size() == unExistList.size()) {
                    int j = 0;
                    while (j < newObjLs.size()) {
                        Object object = newObjLs.get(j);
                        if (object != null) {
                            Object[] params = (Object[])unExistList.get(j);
                            MapInfo mapInfo = new MapInfo(mapName, params);
                            cache.put(mapInfo.getKey(), object);
                            obs2[((Integer)indexLs.get((int)j)).intValue()] = object;
                        }
                        ++j;
                    }
                } else {
                    LogHelper.failedLoadMapsLsByParams(this.log, mapName, paramsList);
                }
            }
            ArrayList<Object> objList = new ArrayList<Object>();
            if (obs2 != null && obs2.length > 0) {
                Object[] objectArray = obs2;
                int n = obs2.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    objList.add(obj);
                    ++n2;
                }
            }
            if ((usedTime = System.currentTimeMillis() - t1) >= 15L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: getMappings region: " + mapName + " size: " + paramsList.size() + " time: " + usedTime));
            }
            return objList;
        }
        catch (Exception e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public List getMapList(List accountIdList, String mapname, List<Object[]> paramsList) throws DaoException {
        ArrayList resList;
        block14: {
            DalAssert.assertObjectNotNull(accountIdList);
            DalAssert.assertObjectNotNull(mapname);
            DalAssert.assertObjectNotNull(paramsList);
            resList = new ArrayList();
            try {
                int i;
                Object[] obs2;
                Cache cache = CacheHelper.getListCache(mapname);
                if (cache == null) {
                    this.dao.getMapList(accountIdList, mapname, paramsList);
                    break block14;
                }
                ArrayList<Object[]> unExistList = new ArrayList<Object[]>();
                ArrayList<String> mapKeyList = new ArrayList<String>();
                ArrayList<Integer> indexLs = new ArrayList<Integer>();
                for (Object[] obs2 : paramsList) {
                    MapInfo mapInfo = new MapInfo(mapname, obs2);
                    mapKeyList.add(mapInfo.getKey());
                }
                obs2 = cache.get(mapKeyList.toArray(new String[mapKeyList.size()]));
                if (obs2 == null || 1 == obs2.length) {
                    int j = 0;
                    while (j < paramsList.size()) {
                        indexLs.add(j);
                        unExistList.add(paramsList.get(j));
                        ++j;
                    }
                } else {
                    i = 0;
                    while (i < obs2.length) {
                        Object object = obs2[i];
                        if (object == null) {
                            indexLs.add(i);
                            unExistList.add(paramsList.get(i));
                        }
                        ++i;
                    }
                }
                if (unExistList.size() > 0) {
                    i = 0;
                    while (i < unExistList.size()) {
                        int oldIndex = (Integer)indexLs.get(i);
                        Object obj = ((HibernateDaoImpl)this.dao).getExtendMapping(accountIdList.get(oldIndex), mapname, (Object[])unExistList.get(i));
                        if (obj != null) {
                            obs2[oldIndex] = obj;
                        }
                        ++i;
                    }
                }
                ArrayList<Object> objList = new ArrayList<Object>();
                if (obs2 != null && obs2.length > 0) {
                    Object[] objectArray = obs2;
                    int n = obs2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        objList.add(obj);
                        ++n2;
                    }
                }
                return objList;
            }
            catch (Exception e) {
                this.processException(e);
            }
        }
        return resList;
    }

    private void processException(Exception e) throws DaoException {
        e.printStackTrace(System.out);
        if (e instanceof MappingException) {
            throw new DaoException(401, e);
        }
        if (e instanceof NullPointerException) {
            throw new DaoException(303, e);
        }
        if (e instanceof SQLException) {
            throw new DaoException(500, e);
        }
        if (e instanceof HibernateException) {
            throw new DaoException(400, e);
        }
        if (e instanceof DaoException) {
            throw (DaoException)e;
        }
        throw new DaoException(e);
    }
}

