/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.id.util;

import com.lenovo.vctl.dal.dao.config.helper.GroupHelper;
import com.lenovo.vctl.dal.dao.id.dao.SequenceDao;
import com.lenovo.vctl.dal.dao.id.util.IdCenterHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequenceService {
    private Log log = LogFactory.getLog(SequenceService.class);
    protected SequenceDao dao = new SequenceDao(GroupHelper.getDataSource(IdCenterHelper.getIDCenterDataSourceName()));
    private static SequenceService service;
    protected Map<String, ConcurrentLinkedQueue<Long>> queueMap = new HashMap<String, ConcurrentLinkedQueue<Long>>();
    protected ConcurrentHashMap<String, Integer> spanMap = new ConcurrentHashMap();

    private SequenceService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SequenceService getInstance() {
        if (service != null) return service;
        Class<SequenceService> clazz = SequenceService.class;
        synchronized (SequenceService.class) {
            if (service != null) return service;
            service = new SequenceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Long nextValue(String seqName) {
        if (seqName == null || StringUtils.isEmpty((String)seqName)) {
            this.log.info((Object)"Attention: Sequence's name is null\r\n");
            return null;
        }
        ConcurrentLinkedQueue<Long> queue = this.getQueue(seqName);
        int size = queue.size();
        if (size <= 100) {
            Map ids = this.dao.getSeqIds(seqName);
            if (ids != null && ids.size() > 0) {
                Integer span = this.spanMap.get(seqName);
                if (span == null) {
                    String string = seqName;
                    synchronized (string) {
                        span = this.dao.getSeqSpan(seqName);
                        this.spanMap.put(seqName, span);
                    }
                }
                Random random = new Random();
                Long minId = (Long)ids.get("oldValue");
                Long maxId = (Long)ids.get("newValue");
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("MinId :" + minId));
                    this.log.info((Object)("MaxId :" + maxId));
                }
                long i = minId;
                while ((i += (long)(random.nextInt(span) + 1)) <= maxId) {
                    queue.add(i);
                }
            } else {
                this.log.error((Object)("Error: Cant' get sequence : " + seqName + " from DB \r\n"));
            }
        }
        Long returnId = null;
        returnId = queue.poll();
        if (returnId == null) {
            this.log.error((Object)("Error : Failed to get sequence :" + seqName + " from queue \r\n"));
        }
        return returnId;
    }

    public ConcurrentLinkedQueue<Long> getQueue(String seqName) {
        ConcurrentLinkedQueue<Long> queue = this.queueMap.get(seqName);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue();
            this.queueMap.put(seqName, queue);
        }
        return queue;
    }
}

