/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.config.helper;

import com.lenovo.vctl.dal.dao.config.DaoConfig;
import com.lenovo.vctl.dal.dao.config.model.dao.DbStrategyItem;
import com.lenovo.vctl.dal.dao.config.model.dao.IdCenterDsItem;
import com.lenovo.vctl.dal.dao.config.model.dao.ListItem;
import com.lenovo.vctl.dal.dao.config.model.dao.MapItem;
import com.lenovo.vctl.dal.dao.config.model.dao.ObjectItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public final class DaoHelper {
    private static Logger logger = Logger.getLogger(DaoHelper.class);

    public static ObjectItem getObjectItemByObjectName(String objectName) {
        if (StringUtils.isEmpty((String)objectName)) {
            return null;
        }
        return DaoConfig.getInstance().getObjectItem(objectName);
    }

    public static Method getDelPropertyMethod(String objectName) {
        ObjectItem item = DaoHelper.getObjectItemByObjectName(objectName);
        return item == null ? null : item.getDelPropertyMethod();
    }

    public static Object getDelValue(String objectName) {
        ObjectItem item = DaoHelper.getObjectItemByObjectName(objectName);
        return item == null ? null : item.getDelValueObject();
    }

    public static DbStrategyItem getDefaultDbStrategyItem() {
        return DaoConfig.getInstance().getDefaultDbStrategyItem();
    }

    public static DbStrategyItem getDbStrategyItemByObjectName(String objectName) {
        if (StringUtils.isEmpty((String)objectName)) {
            return null;
        }
        ObjectItem objectItem = DaoHelper.getObjectItemByObjectName(objectName);
        return objectItem == null ? null : (objectItem.getDbStrategyItem() != null ? objectItem.getDbStrategyItem() : DaoHelper.getDefaultDbStrategyItem());
    }

    public static DbStrategyItem getDbStrategyItemByClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return DaoHelper.getDbStrategyItemByObjectName(clazz.getName());
    }

    public static int getCountDaoGroupByClass(Class clazz) {
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByObjectName(clazz.getName());
        return dbStrategyItem == null ? 0 : dbStrategyItem.getPatternItemList().size();
    }

    public static DbStrategyItem getDbStrategyItemByListName(String listName) {
        ListItem item = DaoHelper.getListItemByListName(listName);
        return item == null ? null : DaoHelper.getDbStrategyItemByObjectName(item.getObjectName());
    }

    public static int getCountDaoGroupByListName(String listName) {
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByListName(listName);
        return dbStrategyItem == null ? 0 : dbStrategyItem.getPatternItemList().size();
    }

    public static DbStrategyItem getDbStrategyItemByMapName(String mapName) {
        MapItem item = DaoHelper.getMapItemByMapName(mapName);
        return item == null ? null : DaoHelper.getDbStrategyItemByObjectName(item.getObjectName());
    }

    public static int getCountDaoGroupByMapName(String mapName) {
        DbStrategyItem dbStrategyItem = DaoHelper.getDbStrategyItemByMapName(mapName);
        return dbStrategyItem == null ? 0 : dbStrategyItem.getPatternItemList().size();
    }

    public static Method getStrategyPropertyMethod(String objectName) {
        if (StringUtils.isEmpty((String)objectName)) {
            return null;
        }
        ObjectItem objectItem = DaoHelper.getObjectItemByObjectName(objectName);
        return objectItem == null ? null : objectItem.getStrategyPropertyMethod();
    }

    public static List<ListItem> getListItemsByObjectName(String objectName) {
        if (StringUtils.isEmpty((String)objectName)) {
            return null;
        }
        ObjectItem objectItem = DaoConfig.getInstance().getObjectItem(objectName);
        ArrayList<ListItem> list = null;
        if (objectItem != null && MapUtils.isNotEmpty(objectItem.getListMap())) {
            Map<String, ListItem> listItems = objectItem.getListMap();
            list = new ArrayList<ListItem>();
            for (ListItem listItem : listItems.values()) {
                list.add(listItem);
            }
        }
        return list;
    }

    public static ListItem getListItemByListName(String listName) {
        if (StringUtils.isEmpty((String)listName)) {
            return null;
        }
        return DaoConfig.getInstance().getListItem(listName);
    }

    public static String getObjectNameByListName(String listName) {
        ListItem item = DaoHelper.getListItemByListName(listName);
        return item == null ? null : item.getObjectName();
    }

    public static Method[] getListItemKeyMethod(String listName) {
        if (StringUtils.isEmpty((String)listName)) {
            return null;
        }
        ListItem item = DaoHelper.getListItemByListName(listName);
        if (item != null) {
            return item.getKeyMethod();
        }
        return null;
    }

    public static Method getListItemValueMethod(String listName) {
        if (StringUtils.isEmpty((String)listName)) {
            return null;
        }
        ListItem item = DaoHelper.getListItemByListName(listName);
        return item == null ? null : item.getValueMethod();
    }

    public static List<MapItem> getMapItemsByObjectName(String objectName) {
        if (StringUtils.isEmpty((String)objectName)) {
            return null;
        }
        ObjectItem objectItem = DaoConfig.getInstance().getObjectItem(objectName);
        ArrayList<MapItem> list = null;
        if (objectItem != null && MapUtils.isNotEmpty(objectItem.getMapMap())) {
            Map<String, MapItem> mapItems = objectItem.getMapMap();
            list = new ArrayList<MapItem>();
            for (MapItem mapItem : mapItems.values()) {
                list.add(mapItem);
            }
        }
        return list;
    }

    public static MapItem getMapItemByMapName(String mapName) {
        if (StringUtils.isEmpty((String)mapName)) {
            return null;
        }
        return DaoConfig.getInstance().getMapItem(mapName);
    }

    public static Method[] getMapItemKeyMethod(String mapName) {
        if (StringUtils.isEmpty((String)mapName)) {
            return null;
        }
        MapItem item = DaoHelper.getMapItemByMapName(mapName);
        if (item != null) {
            return item.getKeyMethod();
        }
        return null;
    }

    public static Method getMapItemValueMethod(String mapName) {
        if (StringUtils.isEmpty((String)mapName)) {
            return null;
        }
        MapItem item = DaoHelper.getMapItemByMapName(mapName);
        return item == null ? null : item.getValueMethod();
    }

    public static IdCenterDsItem getIdCenterDsItem() {
        return DaoConfig.getInstance().getIdCenterDsItem();
    }

    public static String getIdCenterDsName() {
        IdCenterDsItem centerDsItem = DaoConfig.getInstance().getIdCenterDsItem();
        if (centerDsItem == null) {
            logger.error((Object)"Please set idCenter datasource in dao.xml");
            return null;
        }
        return centerDsItem.getDs();
    }

    public static Class getListItemValueClass(String listName) {
        if (StringUtils.isEmpty((String)listName)) {
            return null;
        }
        ListItem item = DaoHelper.getListItemByListName(listName);
        Method method = item == null ? null : item.getValueMethod();
        return method == null ? null : method.getReturnType();
    }

    public static Class getMapItemValueClass(String mapName) {
        if (StringUtils.isEmpty((String)mapName)) {
            return null;
        }
        MapItem item = DaoHelper.getMapItemByMapName(mapName);
        Method method = item == null ? null : item.getValueMethod();
        return method == null ? null : method.getReturnType();
    }

    public static String getListItemValueColumnName(String listName) {
        if (StringUtils.isEmpty((String)listName)) {
            return null;
        }
        ListItem item = DaoHelper.getListItemByListName(listName);
        return item == null ? null : item.getColumnName();
    }

    public static String getMapItemValueColumnName(String mapName) {
        if (StringUtils.isEmpty((String)mapName)) {
            return null;
        }
        MapItem item = DaoHelper.getMapItemByMapName(mapName);
        return item == null ? null : item.getColumnName();
    }

    public static SessionFactory getSessionFactory() {
        return DaoConfig.getInstance().getSessionFactory();
    }

    public static Method getIdMethod(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ObjectItem objectItem = DaoHelper.getObjectItemByObjectName(clazz.getName());
        return objectItem == null ? null : objectItem.getIdMethod();
    }
}

