/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao.config;

import com.lenovo.vctl.dal.dao.config.model.group.DataSourceItem;
import com.lenovo.vctl.dal.dao.config.model.group.GroupItem;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public final class GroupConfig {
    private static String CONFIG_FILE = "/group.xml";
    private static Logger logger = Logger.getLogger(GroupConfig.class);
    private Map<Object, Object> dataSourceItemMap = new HashMap<Object, Object>();
    private Map<String, GroupItem> groupItemMap = new HashMap<String, GroupItem>();
    private Map<String, List<DataSource>> slaveDatasourceMap = new HashMap<String, List<DataSource>>();
    private static GroupConfig config;
    public static String DASNAME_SEPARATOR;

    static {
        DASNAME_SEPARATOR = ",";
    }

    private GroupConfig() {
        try {
            this.init(this.getClass().getResourceAsStream(CONFIG_FILE));
            this.datasourceAssign();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.out);
            }
            logger.error((Object)("init config file " + CONFIG_FILE + " error: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GroupConfig getInstance() {
        if (config != null) return config;
        Class<GroupConfig> clazz = GroupConfig.class;
        synchronized (GroupConfig.class) {
            if (config != null) return config;
            config = new GroupConfig();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    config.close();
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    public void close() {
        if (MapUtils.isNotEmpty(this.dataSourceItemMap)) {
            Collection<Object> dataSources = this.dataSourceItemMap.values();
            for (DataSource dataSource : dataSources) {
                if (dataSource == null) continue;
                try {
                    ((BasicDataSource)dataSource).close();
                    logger.info((Object)("close datasource complete " + ((BasicDataSource)dataSource).getUrl()));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private void init(InputStream groupConfigFile) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("root", ArrayList.class);
        digester.addObjectCreate("root/datasources", ArrayList.class.getName());
        digester.addSetNext("root/datasources", "add");
        digester.addObjectCreate("root/datasources/ds", DataSourceItem.class.getName());
        digester.addSetProperties("root/datasources/ds");
        digester.addSetNext("root/datasources/ds", "add");
        digester.addObjectCreate("root/groups", ArrayList.class.getName());
        digester.addSetNext("root/groups", "add");
        digester.addObjectCreate("root/groups/group", GroupItem.class.getName());
        digester.addSetProperties("root/groups/group");
        digester.addSetNext("root/groups/group", "add");
        try {
            Object root = digester.parse(groupConfigFile);
            if (root != null && root instanceof ArrayList) {
                List list = (List)root;
                for (List list_item : list) {
                    if (!CollectionUtils.isNotEmpty((Collection)list_item)) continue;
                    for (Object entityObject : list_item) {
                        if (entityObject == null) continue;
                        if (entityObject instanceof GroupItem) {
                            this.addGroupItem((GroupItem)entityObject);
                            continue;
                        }
                        if (!(entityObject instanceof DataSourceItem)) continue;
                        this.addDataSourceItem((DataSourceItem)entityObject);
                    }
                }
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            } else {
                logger.error((Object)("init error: " + e.getMessage()));
            }
        }
        catch (SAXException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace(System.err);
            }
            logger.error((Object)("init parse fail : " + e.getMessage()));
        }
    }

    private void datasourceAssign() {
        if (MapUtils.isNotEmpty(this.groupItemMap)) {
            Collection<GroupItem> groupitems = this.groupItemMap.values();
            for (GroupItem groupItem : groupitems) {
                ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
                String dataSourceName = groupItem.getSlave();
                if (StringUtils.isEmpty((String)dataSourceName)) {
                    logger.info((Object)(String.valueOf(StringUtils.defaultIfEmpty((String)groupItem.getName(), (String)"")) + " slave name don't set! please check group.xml file"));
                    continue;
                }
                String[] names = StringUtils.splitPreserveAllTokens((String)dataSourceName, (String)DASNAME_SEPARATOR);
                int i = 0;
                while (i < names.length) {
                    if (StringUtils.isNotEmpty((String)names[i])) {
                        DataSource dataSource = this.getDataSource(names[i]);
                        if (dataSource != null) {
                            dataSources.add(dataSource);
                        } else {
                            logger.info((Object)(String.valueOf(StringUtils.defaultIfEmpty((String)names[i], (String)"")) + " don't exist datasources"));
                        }
                    }
                    ++i;
                }
                this.slaveDatasourceMap.put(groupItem.getName(), dataSources);
            }
        }
    }

    private void addDataSourceItem(DataSourceItem dataSourceItem) {
        if (dataSourceItem != null && StringUtils.isNotEmpty((String)dataSourceItem.getName())) {
            if (!this.dataSourceItemMap.containsKey(dataSourceItem.getName())) {
                BasicDataSource ds = new BasicDataSource();
                ds.setDriverClassName(dataSourceItem.getDriverClassName());
                ds.setUsername(dataSourceItem.getUsername());
                ds.setPassword(dataSourceItem.getPassword());
                ds.setUrl(dataSourceItem.getUrl());
                ds.setMaxActive(NumberUtils.toInt((String)dataSourceItem.getMaxActive(), (int)8));
                ds.setMaxIdle(NumberUtils.toInt((String)dataSourceItem.getMaxIdle(), (int)8));
                ds.setMaxWait(NumberUtils.toLong((String)dataSourceItem.getMaxWait(), (long)-1L));
                this.dataSourceItemMap.put(dataSourceItem.getName(), ds);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("datasource " + dataSourceItem.getName() + " created ok"));
                }
            } else {
                logger.error((Object)("same <" + dataSourceItem.getName() + "> name datasource exist!"));
            }
        } else {
            logger.error((Object)"DataSourceItem must has value and name");
        }
    }

    private void addGroupItem(GroupItem groupItem) {
        if (groupItem != null && StringUtils.isNotEmpty((String)groupItem.getName())) {
            if (!this.groupItemMap.containsKey(groupItem.getName())) {
                this.groupItemMap.put(groupItem.getName(), groupItem);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(String.valueOf(groupItem.getName()) + " parser ok."));
                }
            } else {
                logger.error((Object)("same <" + groupItem.getName() + ">name GroupItem exist!"));
            }
        } else {
            logger.error((Object)"groupitem must has value and has name");
        }
    }

    public DataSource getDataSource(String dataSourceName) {
        if (StringUtils.isNotEmpty((String)dataSourceName)) {
            return (DataSource)this.dataSourceItemMap.get(dataSourceName);
        }
        return null;
    }

    public GroupItem getGroupItem(String groupItemName) {
        if (StringUtils.isNotEmpty((String)groupItemName)) {
            return this.groupItemMap.get(groupItemName);
        }
        return null;
    }

    public List<DataSource> getSlaveDataSources(String groupName) {
        return this.slaveDatasourceMap.get(groupName);
    }

    public DataSource getMasterDataSource(String groupName) {
        GroupItem groupItem = this.getGroupItem(groupName);
        DataSource dataSource = null;
        if (groupItem != null) {
            String dataSourceName = groupItem.getMaster();
            if (StringUtils.isEmpty((String)dataSourceName)) {
                logger.info((Object)(String.valueOf(StringUtils.defaultIfEmpty((String)groupItem.getName(), (String)"")) + " master name don't set! please check group.xml file"));
            } else {
                dataSource = this.getDataSource(dataSourceName);
            }
        } else {
            logger.info((Object)(String.valueOf(StringUtils.defaultIfEmpty((String)groupName, (String)"")) + " do'nt exist! please check group.xml file"));
        }
        return dataSource;
    }

    public Map<Object, Object> getDataSourceItemMap() {
        return this.dataSourceItemMap;
    }
}

