/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.dao;

import com.lenovo.vctl.dal.dao.model.LsCacheInfo;
import com.lenovo.vctl.dal.dao.model.MapInfo;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DaoRecord {
    private static Logger logger = Logger.getLogger(DaoRecord.class);
    public static long useful_limt = 60000L;
    private static final long maxSpan = 30000L;
    public static Map<String, Long> entity_save_completed = Collections.synchronizedMap(new LRUMap(2500));
    public static Map<String, Long> entity_updated_completed = Collections.synchronizedMap(new LRUMap(2500));
    public static Map<String, Long> entity_deleted_completed = Collections.synchronizedMap(new LRUMap(2500));
    public static Map<String, Long> list_add_new_object = Collections.synchronizedMap(new LRUMap(2500));
    public static Map<String, Long> list_remove_old_object = Collections.synchronizedMap(new LRUMap(2500));
    public static Map<String, Long> mapping_changed_completed = Collections.synchronizedMap(new LRUMap(5000));
    public static Map<String, Long> mapping_add_new_object = Collections.synchronizedMap(new LRUMap(2500));
    public static ConcurrentHashMap<String, Long> lsChangeInfo = new ConcurrentHashMap();
    private static DaoRecord instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DaoRecord getInstance() {
        if (instance == null) {
            Class<DaoRecord> clazz = DaoRecord.class;
            synchronized (DaoRecord.class) {
                if (instance == null) {
                    instance = new DaoRecord();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
        return instance;
    }

    private DaoRecord() {
    }

    public void NotifyEntitySaveComplete(String entityName, String identity) {
        if (StringUtils.isBlank((String)entityName) || StringUtils.isBlank((String)identity)) {
            logger.error((Object)" listName and listKey is null or empty");
            return;
        }
        String key = String.valueOf(entityName) + "_" + identity;
        entity_save_completed.put(key, System.currentTimeMillis());
    }

    public boolean isNowSaved(String entityName, String identity) {
        if (StringUtils.isBlank((String)entityName) || StringUtils.isBlank((String)identity)) {
            logger.error((Object)" listName and listKey is null or empty");
            return false;
        }
        String key = String.valueOf(entityName) + "_" + identity;
        Long saveTime = entity_save_completed.get(key);
        return saveTime != null && System.currentTimeMillis() - saveTime <= useful_limt;
    }

    public void NotifyEntityUpdateCompleted(String entityName, String identity) {
        String key = String.valueOf(entityName) + "_" + identity;
        entity_updated_completed.put(key, System.currentTimeMillis());
    }

    public boolean isNowUpdate(String entityName, String identity) {
        if (StringUtils.isBlank((String)entityName) || StringUtils.isBlank((String)identity)) {
            logger.error((Object)" entityName and identity is null or empty");
            return false;
        }
        String key = String.valueOf(entityName) + "_" + identity;
        Long updateTime = entity_updated_completed.get(key);
        return updateTime != null && System.currentTimeMillis() - updateTime <= useful_limt;
    }

    public void NotifyEntityDeleteComplated(String entityName, String identity) {
        String key = String.valueOf(entityName) + "_" + identity;
        entity_deleted_completed.put(key, System.currentTimeMillis());
    }

    public boolean isNowDeleted(String entityName, String identity) {
        if (StringUtils.isBlank((String)entityName) || StringUtils.isBlank((String)identity)) {
            logger.error((Object)" entityName and identity is null or empty");
            return false;
        }
        String key = String.valueOf(entityName) + "_" + identity;
        Long deletedTime = entity_deleted_completed.get(key);
        return deletedTime != null && System.currentTimeMillis() - deletedTime <= useful_limt;
    }

    public void NotifyListAddNewObject(LsCacheInfo lsInfo) {
        list_add_new_object.put(lsInfo.getKey(), System.currentTimeMillis());
    }

    public boolean hasNewObjectAddToList(LsCacheInfo lsInfo) {
        Long saveTime = list_add_new_object.get(lsInfo.getKey());
        return saveTime != null && System.currentTimeMillis() - saveTime >= useful_limt;
    }

    public void NotifyListRemoveObject(LsCacheInfo lsInfo) {
        list_remove_old_object.put(lsInfo.getKey(), System.currentTimeMillis());
    }

    public boolean hasObjectRemoveFromList(LsCacheInfo lsInfo) {
        Long saveTime = list_remove_old_object.get(lsInfo.getKey());
        return saveTime != null && System.currentTimeMillis() - saveTime >= useful_limt;
    }

    public void NotifyMappingChangeComplated(MapInfo info) {
        mapping_changed_completed.put(info.getKey(), System.currentTimeMillis());
    }

    public boolean isMappingChange(MapInfo info) {
        Long changeTime = mapping_changed_completed.get(info.getKey());
        return changeTime != null && System.currentTimeMillis() - changeTime <= useful_limt;
    }

    public void NotifyMappingAddNewObject(MapInfo mapInfo) {
        mapping_add_new_object.put(mapInfo.getKey(), System.currentTimeMillis());
    }

    public boolean hasNewObjectAddToMapping(MapInfo info) {
        Long saveTime = mapping_add_new_object.get(info.getKey());
        return saveTime != null && System.currentTimeMillis() - saveTime >= useful_limt;
    }

    public boolean isCntListLoading(LsCacheInfo lsInfo) {
        return lsChangeInfo.containsKey(lsInfo.getListCntKey());
    }

    public Long checkCntListLoading(LsCacheInfo lsInfo) throws Exception {
        Long lockedValue = null;
        Long currTime = System.currentTimeMillis();
        Long oldTime = lsChangeInfo.putIfAbsent(lsInfo.getListCntKey(), currTime);
        if (oldTime == null) {
            lockedValue = currTime;
        } else if (currTime - oldTime >= 30000L && lsChangeInfo.replace(lsInfo.getListCntKey(), oldTime, currTime)) {
            lockedValue = currTime;
        }
        return lockedValue;
    }

    public boolean endCntListLoading(LsCacheInfo lsInfo, Object value) throws Exception {
        return lsChangeInfo.remove(lsInfo.getListCntKey(), value);
    }

    public boolean isListLoading(LsCacheInfo lsInfo) {
        return lsChangeInfo.containsKey(lsInfo.getKey());
    }

    public Long checkListLoading(LsCacheInfo lsInfo) throws Exception {
        Long lockedValue = null;
        Long currTime = System.currentTimeMillis();
        Long oldTime = lsChangeInfo.putIfAbsent(lsInfo.getKey(), currTime);
        if (oldTime == null) {
            lockedValue = currTime;
        } else if (currTime - oldTime >= 30000L && lsChangeInfo.replace(lsInfo.getKey(), oldTime, currTime)) {
            lockedValue = currTime;
        }
        return lockedValue;
    }

    public boolean endListLoading(LsCacheInfo lsInfo, Object value) throws Exception {
        return lsChangeInfo.remove(lsInfo.getKey(), value);
    }
}

