package com.lenovo.vctl.dal.dao.id.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.springframework.stereotype.Component;


/**
 * 
 * @author songkun1
 *
 */


@Component("assignedOrSequenceIdGenerator")
public class AssignedOrSequenceIdGenerator extends IdGenerator{
	String entityName = null;
    private static final Log log = LogFactory.getLog(IdGenerator.class);
    /**
     * @return 根据Sequence名字，返回唯一的Sequence id.类似于Oracle的sequence机制
     * @param session:
     *            这个参数没有用到
     * @param arg1:
     *            这个参数没有用到
     * 
     */
    public Serializable generate(SessionImplementor session, Object arg1) throws HibernateException {
    	if(arg1 != null){
    	  	Field[] fields = arg1.getClass().getDeclaredFields();
    	  	if(fields != null)
	    	  	for(Field field : fields){
	    	  		if(field == null)continue;
	    	  		PropertyDescriptor pd = null;
					try {
						pd = new PropertyDescriptor(field.getName(), arg1.getClass());
					} catch (IntrospectionException e) {
					}
					if(pd == null)continue;
	    	  		Method method = pd.getReadMethod();
	    	  		if(method == null)continue;
	    	  		Annotation[] annos = method.getDeclaredAnnotations();
	    	  		if(annos != null){
	    	  			for(Annotation anno : annos){
	    	  				if(anno != null && anno.annotationType().equals(javax.persistence.Id.class)){
	    	  					method.setAccessible(true);
								try {
									Object defaultId = method.invoke(arg1, null);
									if(defaultId != null && (Long)defaultId > 0){
										return (Long)defaultId;
									}
								} catch (Exception e) {
									e.printStackTrace();
								}
	    	  					break;
	    	  				}
	    	  			}
	    	  		}
	    	  	}
    	}
    	
        if (StringUtils.isEmpty(sequenceName)) {
            log.warn("Attention : The sequence for idcenter is null\r\n");
            return null;
        }
        Long id = SequenceService.getInstance().nextValue(sequenceName);
        return id;
    }
    
    
	public void configure(Type type, Properties params, Dialect d) throws MappingException {
		super.configure(type, params, d);
		entityName = params.getProperty(ENTITY_NAME);
		if ( entityName == null ) {
			throw new MappingException("no entity name");
		}
	}
    
    public static void main(String[] args) {
		
	}
}
