/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.SimpleFormat;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;

class ReflectionAccessor
implements Accessor {
    private static final FieldAccess[] EMPTY_KEYS = new FieldAccess[0];
    private Class type;
    private Accessor superAccessor;
    private Constructor constructor;
    private FieldAccess priKey;
    private FieldAccess[] secKeys;
    private FieldAccess[] nonKeys;

    private ReflectionAccessor(Class type, Accessor superAccessor) {
        this.type = type;
        this.superAccessor = superAccessor;
        try {
            this.constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(type.getName());
        }
        if (!Modifier.isPublic(this.constructor.getModifiers())) {
            this.setAccessible(this.constructor, String.valueOf(type.getName()) + "()");
        }
    }

    ReflectionAccessor(Catalog catalog, Class type, Accessor superAccessor, FieldInfo priKeyField, List<FieldInfo> secKeyFields, List<FieldInfo> nonKeyFields) {
        this(type, superAccessor);
        this.priKey = priKeyField != null ? this.getField(catalog, priKeyField, true, false) : null;
        this.secKeys = secKeyFields.size() > 0 ? this.getFields(catalog, secKeyFields, false, false) : EMPTY_KEYS;
        this.nonKeys = nonKeyFields.size() > 0 ? this.getFields(catalog, nonKeyFields, false, false) : EMPTY_KEYS;
    }

    ReflectionAccessor(Catalog catalog, Class type, List<FieldInfo> fieldInfos) {
        this(type, null);
        this.priKey = null;
        this.secKeys = EMPTY_KEYS;
        this.nonKeys = this.getFields(catalog, fieldInfos, true, true);
    }

    private FieldAccess[] getFields(Catalog catalog, List<FieldInfo> fieldInfos, boolean isRequiredKeyField, boolean isCompositeKey) {
        int index = 0;
        FieldAccess[] fields = new FieldAccess[fieldInfos.size()];
        for (FieldInfo info : fieldInfos) {
            fields[index] = this.getField(catalog, info, isRequiredKeyField, isCompositeKey);
            ++index;
        }
        return fields;
    }

    private FieldAccess getField(Catalog catalog, FieldInfo fieldInfo, boolean isRequiredKeyField, boolean isCompositeKey) {
        Class<?> fieldCls;
        Field field;
        try {
            field = this.type.getDeclaredField(fieldInfo.getName());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            this.setAccessible(field, field.getName());
        }
        if ((fieldCls = field.getType()).isPrimitive()) {
            assert (SimpleCatalog.isSimpleType(fieldCls));
            return new PrimitiveAccess(field, SimpleCatalog.getSimpleFormat(fieldCls));
        }
        if (isRequiredKeyField) {
            Format format = catalog.getFormat(fieldCls, false);
            if (isCompositeKey && !SimpleCatalog.isSimpleType(fieldCls)) {
                throw new IllegalArgumentException("Composite key class has non-simple type field: " + this.type.getName() + '.' + field.getName());
            }
            return new KeyObjectAccess(field, format);
        }
        return new ObjectAccess(field);
    }

    private void setAccessible(AccessibleObject object, String memberName) {
        try {
            object.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to access non-public member: " + this.type.getName() + '.' + memberName + ". Please configure the Java Security Manager setting: " + " ReflectPermission suppressAccessChecks", e);
        }
    }

    @Override
    public Object newInstance() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object newArray(int len) {
        return Array.newInstance(this.type, len);
    }

    @Override
    public boolean isPriKeyFieldNullOrZero(Object o) {
        try {
            if (this.priKey != null) {
                return this.priKey.isNullOrZero(o);
            }
            if (this.superAccessor != null) {
                return this.superAccessor.isPriKeyFieldNullOrZero(o);
            }
            throw new IllegalStateException("No primary key field");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writePriKeyField(Object o, EntityOutput output) {
        block4: {
            try {
                if (this.priKey != null) {
                    this.priKey.write(o, output);
                    break block4;
                }
                if (this.superAccessor != null) {
                    this.superAccessor.writePriKeyField(o, output);
                    break block4;
                }
                throw new IllegalStateException("No primary key field");
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void readPriKeyField(Object o, EntityInput input) {
        block4: {
            try {
                if (this.priKey != null) {
                    this.priKey.read(o, input);
                    break block4;
                }
                if (this.superAccessor != null) {
                    this.superAccessor.readPriKeyField(o, input);
                    break block4;
                }
                throw new IllegalStateException("No primary key field");
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void writeSecKeyFields(Object o, EntityOutput output) {
        try {
            if (this.priKey != null && !this.priKey.isPrimitive) {
                output.registerPriKeyObject(this.priKey.field.get(o));
            }
            if (this.superAccessor != null) {
                this.superAccessor.writeSecKeyFields(o, output);
            }
            int i = 0;
            while (i < this.secKeys.length) {
                this.secKeys[i].write(o, output);
                ++i;
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void readSecKeyFields(Object o, EntityInput input, int startField, int endField, int superLevel) {
        try {
            if (this.priKey != null && !this.priKey.isPrimitive) {
                input.registerPriKeyObject(this.priKey.field.get(o));
            }
            if (superLevel != 0 && this.superAccessor != null) {
                this.superAccessor.readSecKeyFields(o, input, startField, endField, superLevel - 1);
            } else if (superLevel > 0) {
                throw new IllegalStateException("Superclass does not exist");
            }
            if (superLevel <= 0) {
                int i = startField;
                while (i <= endField && i < this.secKeys.length) {
                    this.secKeys[i].read(o, input);
                    ++i;
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeNonKeyFields(Object o, EntityOutput output) {
        try {
            if (this.superAccessor != null) {
                this.superAccessor.writeNonKeyFields(o, output);
            }
            int i = 0;
            while (i < this.nonKeys.length) {
                this.nonKeys[i].write(o, output);
                ++i;
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void readNonKeyFields(Object o, EntityInput input, int startField, int endField, int superLevel) {
        try {
            if (superLevel != 0 && this.superAccessor != null) {
                this.superAccessor.readNonKeyFields(o, input, startField, endField, superLevel - 1);
            } else if (superLevel > 0) {
                throw new IllegalStateException("Superclass does not exist");
            }
            if (superLevel <= 0) {
                int i = startField;
                while (i <= endField && i < this.nonKeys.length) {
                    this.nonKeys[i].read(o, input);
                    ++i;
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object getField(Object o, int field, int superLevel, boolean isSecField) {
        if (superLevel > 0) {
            return this.superAccessor.getField(o, field, superLevel - 1, isSecField);
        }
        try {
            Field fld = isSecField ? this.secKeys[field].field : this.nonKeys[field].field;
            return fld.get(o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setField(Object o, int field, int superLevel, boolean isSecField, Object value) {
        if (superLevel > 0) {
            this.superAccessor.setField(o, field, superLevel - 1, isSecField, value);
            return;
        }
        try {
            Field fld = isSecField ? this.secKeys[field].field : this.nonKeys[field].field;
            fld.set(o, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static abstract class FieldAccess {
        Field field;
        boolean isPrimitive;

        FieldAccess(Field field) {
            this.field = field;
            this.isPrimitive = field.getType().isPrimitive();
        }

        abstract void write(Object var1, EntityOutput var2) throws IllegalAccessException;

        abstract void read(Object var1, EntityInput var2) throws IllegalAccessException;

        boolean isNullOrZero(Object o) throws IllegalAccessException {
            return this.field.get(o) == null;
        }
    }

    private static class KeyObjectAccess
    extends FieldAccess {
        private Format format;

        KeyObjectAccess(Field field, Format format) {
            super(field);
            this.format = format;
        }

        @Override
        void write(Object o, EntityOutput out) throws IllegalAccessException {
            out.writeKeyObject(this.field.get(o), this.format);
        }

        @Override
        void read(Object o, EntityInput in) throws IllegalAccessException {
            this.field.set(o, in.readKeyObject(this.format));
        }
    }

    private static class ObjectAccess
    extends FieldAccess {
        ObjectAccess(Field field) {
            super(field);
        }

        @Override
        void write(Object o, EntityOutput out) throws IllegalAccessException {
            out.writeObject(this.field.get(o), null);
        }

        @Override
        void read(Object o, EntityInput in) throws IllegalAccessException {
            this.field.set(o, in.readObject());
        }
    }

    private static class PrimitiveAccess
    extends FieldAccess {
        private SimpleFormat format;

        PrimitiveAccess(Field field, SimpleFormat format) {
            super(field);
            this.format = format;
        }

        @Override
        void write(Object o, EntityOutput out) throws IllegalAccessException {
            this.format.writePrimitiveField(o, out, this.field);
        }

        @Override
        void read(Object o, EntityInput in) throws IllegalAccessException {
            this.format.readPrimitiveField(o, in, this.field);
        }

        @Override
        boolean isNullOrZero(Object o) throws IllegalAccessException {
            return this.field.getLong(o) == 0L;
        }
    }
}

