/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.EntityValueAdapter;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import java.util.Map;
import java.util.SortedMap;

public class PrimaryIndex<PK, E>
extends BasicIndex<PK, E> {
    private Class<E> entityClass;
    private EntityBinding entityBinding;
    private SortedMap<PK, E> map;
    private PersistKeyAssigner keyAssigner;

    public PrimaryIndex(Database database, Class<PK> keyClass, EntryBinding<PK> keyBinding, Class<E> entityClass, EntityBinding<E> entityBinding) throws DatabaseException {
        super(database, keyClass, keyBinding, new EntityValueAdapter<E>(entityClass, entityBinding, false));
        this.entityClass = entityClass;
        this.entityBinding = entityBinding;
        if (entityBinding instanceof PersistEntityBinding) {
            this.keyAssigner = ((PersistEntityBinding)entityBinding).getKeyAssigner();
        }
    }

    public Database getDatabase() {
        return this.db;
    }

    public Class<PK> getKeyClass() {
        return this.keyClass;
    }

    public EntryBinding<PK> getKeyBinding() {
        return this.keyBinding;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public EntityBinding<E> getEntityBinding() {
        return this.entityBinding;
    }

    public E put(E entity) throws DatabaseException {
        return this.put(null, entity);
    }

    public E put(Transaction txn, E entity) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.assignKey(entity, keyEntry);
        boolean autoCommit = false;
        Environment env = this.db.getEnvironment();
        if (this.transactional && txn == null && DbCompat.getThreadTransaction(env) == null) {
            txn = env.beginTransaction(null, null);
            autoCommit = true;
        }
        boolean failed = true;
        Cursor cursor = this.db.openCursor(txn, null);
        LockMode lockMode = this.locking ? LockMode.RMW : null;
        try {
            OperationStatus status;
            do {
                if ((status = cursor.getSearchKey(keyEntry, dataEntry, lockMode)) == OperationStatus.SUCCESS) {
                    Object existing = this.entityBinding.entryToObject(keyEntry, dataEntry);
                    this.entityBinding.objectToData(entity, dataEntry);
                    cursor.put(keyEntry, dataEntry);
                    failed = false;
                    Object e = existing;
                    return e;
                }
                this.entityBinding.objectToData(entity, dataEntry);
            } while ((status = cursor.putNoOverwrite(keyEntry, dataEntry)) == OperationStatus.KEYEXIST);
            failed = false;
            return null;
        }
        finally {
            cursor.close();
            if (autoCommit) {
                if (failed) {
                    txn.abort();
                } else {
                    txn.commit();
                }
            }
        }
    }

    public void putNoReturn(E entity) throws DatabaseException {
        this.putNoReturn(null, entity);
    }

    public void putNoReturn(Transaction txn, E entity) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.assignKey(entity, keyEntry);
        this.entityBinding.objectToData(entity, dataEntry);
        this.db.put(txn, keyEntry, dataEntry);
    }

    public boolean putNoOverwrite(E entity) throws DatabaseException {
        return this.putNoOverwrite(null, entity);
    }

    public boolean putNoOverwrite(Transaction txn, E entity) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.assignKey(entity, keyEntry);
        this.entityBinding.objectToData(entity, dataEntry);
        OperationStatus status = this.db.putNoOverwrite(txn, keyEntry, dataEntry);
        return status == OperationStatus.SUCCESS;
    }

    private void assignKey(E entity, DatabaseEntry keyEntry) throws DatabaseException {
        if (this.keyAssigner != null) {
            if (!this.keyAssigner.assignPrimaryKey(entity, keyEntry)) {
                this.entityBinding.objectToKey(entity, keyEntry);
            }
        } else {
            this.entityBinding.objectToKey(entity, keyEntry);
        }
    }

    @Override
    public E get(PK key) throws DatabaseException {
        return this.get((Transaction)null, key, (LockMode)null);
    }

    @Override
    public E get(Transaction txn, PK key, LockMode lockMode) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationStatus status = this.db.get(txn, keyEntry, dataEntry, lockMode);
        if (status == OperationStatus.SUCCESS) {
            return this.entityBinding.entryToObject(keyEntry, dataEntry);
        }
        return null;
    }

    @Override
    public Map<PK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<PK, E> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap<PK, E>(this.db, this.keyBinding, this.entityBinding, true);
        }
        return this.map;
    }

    @Override
    boolean isUpdateAllowed() {
        return true;
    }
}

