/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.DataValueAdapter;
import java.util.Map;
import java.util.SortedMap;

class KeysIndex<SK, PK>
extends BasicIndex<SK, PK> {
    private EntryBinding pkeyBinding;
    private SortedMap<SK, PK> map;

    KeysIndex(Database db, Class<SK> keyClass, EntryBinding keyBinding, Class<PK> pkeyClass, EntryBinding pkeyBinding) throws DatabaseException {
        super(db, keyClass, keyBinding, new DataValueAdapter<PK>(pkeyClass, pkeyBinding));
        this.pkeyBinding = pkeyBinding;
    }

    @Override
    public PK get(SK key) throws DatabaseException {
        return this.get((Transaction)null, key, (LockMode)null);
    }

    @Override
    public PK get(Transaction txn, SK key, LockMode lockMode) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry pkeyEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationStatus status = this.db.get(txn, keyEntry, pkeyEntry, lockMode);
        if (status == OperationStatus.SUCCESS) {
            return (PK)this.pkeyBinding.entryToObject(pkeyEntry);
        }
        return null;
    }

    @Override
    public Map<SK, PK> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<SK, PK> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap<SK, PK>(this.db, this.keyBinding, this.pkeyBinding, true);
        }
        return this.map;
    }

    @Override
    boolean isUpdateAllowed() {
        return false;
    }
}

