/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TracerFormatter
extends Formatter {
    private Date date = new Date();
    private DateFormat formatter = TracerFormatter.makeDateFormat();

    private synchronized String getDate(long millis) {
        this.date.setTime(millis);
        return this.formatter.format(this.date);
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        String dateVal = this.getDate(record.getMillis());
        sb.append(dateVal);
        sb.append(" ");
        sb.append(record.getLevel().getLocalizedName());
        sb.append(" ");
        sb.append(this.formatMessage(record));
        sb.append("\n");
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static DateFormat makeDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS:z");
    }
}

