/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DatabaseException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;

public class PropUtil {
    public static boolean getBoolean(Properties props, String propName) {
        String value = props.getProperty(propName);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static Properties validateProps(Properties props, Set allowedProps, String apiMethod) throws DatabaseException {
        if (props == null) {
            return new Properties();
        }
        if (props.size() > 0) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                PropUtil.validateProp(propName, allowedProps, apiMethod);
            }
        }
        return props;
    }

    public static void validateProp(String propName, Set allowedProps, String apiMethod) throws DatabaseException {
        if (!allowedProps.contains(propName)) {
            throw new DatabaseException(String.valueOf(propName) + " is not a valid property for " + apiMethod);
        }
    }

    public static long microsToMillis(long micros) {
        return (micros + 999L) / 1000L;
    }
}

