/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.txn.LockConflict;
import com.sleepycat.je.txn.LockUpgrade;

public class LockType {
    public static final LockType READ = new LockType(0, false, "READ");
    public static final LockType WRITE = new LockType(1, true, "WRITE");
    public static final LockType RANGE_READ = new LockType(2, false, "RANGE_READ");
    public static final LockType RANGE_WRITE = new LockType(3, true, "RANGE_WRITE");
    public static final LockType RANGE_INSERT = new LockType(4, false, "RANGE_INSERT");
    public static final LockType NONE = new LockType(5, false, "NONE");
    public static final LockType RESTART = new LockType(6, false, "RESTART");
    private static LockConflict[][] conflictMatrix;
    private static LockUpgrade[][] upgradeMatrix;
    private int index;
    private boolean write;
    private String name;
    private boolean causesRestart;

    static {
        RANGE_READ.setCausesRestart();
        RANGE_WRITE.setCausesRestart();
        conflictMatrix = new LockConflict[][]{{LockConflict.ALLOW, LockConflict.BLOCK, LockConflict.ALLOW, LockConflict.BLOCK, LockConflict.ALLOW}, {LockConflict.BLOCK, LockConflict.BLOCK, LockConflict.BLOCK, LockConflict.BLOCK, LockConflict.ALLOW}, {LockConflict.ALLOW, LockConflict.BLOCK, LockConflict.ALLOW, LockConflict.BLOCK, LockConflict.BLOCK}, {LockConflict.BLOCK, LockConflict.BLOCK, LockConflict.BLOCK, LockConflict.BLOCK, LockConflict.BLOCK}, {LockConflict.ALLOW, LockConflict.ALLOW, LockConflict.RESTART, LockConflict.RESTART, LockConflict.ALLOW}};
        upgradeMatrix = new LockUpgrade[][]{{LockUpgrade.EXISTING, LockUpgrade.WRITE_PROMOTE, LockUpgrade.RANGE_READ_IMMED, LockUpgrade.RANGE_WRITE_PROMOTE, LockUpgrade.ILLEGAL}, {LockUpgrade.EXISTING, LockUpgrade.EXISTING, LockUpgrade.RANGE_WRITE_IMMED, LockUpgrade.RANGE_WRITE_IMMED, LockUpgrade.ILLEGAL}, {LockUpgrade.EXISTING, LockUpgrade.RANGE_WRITE_PROMOTE, LockUpgrade.EXISTING, LockUpgrade.RANGE_WRITE_PROMOTE, LockUpgrade.ILLEGAL}, {LockUpgrade.EXISTING, LockUpgrade.EXISTING, LockUpgrade.EXISTING, LockUpgrade.EXISTING, LockUpgrade.ILLEGAL}, {LockUpgrade.ILLEGAL, LockUpgrade.ILLEGAL, LockUpgrade.ILLEGAL, LockUpgrade.ILLEGAL, LockUpgrade.EXISTING}};
    }

    private LockType(int index, boolean write, String name) {
        this.index = index;
        this.write = write;
        this.name = name;
    }

    public final boolean isWriteLock() {
        return this.write;
    }

    private void setCausesRestart() {
        this.causesRestart = true;
    }

    final boolean getCausesRestart() {
        return this.causesRestart;
    }

    LockConflict getConflict(LockType requestedType) {
        return conflictMatrix[this.index][requestedType.index];
    }

    LockUpgrade getUpgrade(LockType requestedType) {
        LockUpgrade upgrade = upgradeMatrix[this.index][requestedType.index];
        assert (!upgrade.getIllegal()) : String.valueOf(this.toString()) + " to " + requestedType;
        return upgrade;
    }

    public String toString() {
        return this.name;
    }
}

