/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.recovery.DirtyINMap;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INLogContext;
import com.sleepycat.je.tree.INLogItem;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class Checkpointer
extends DaemonThread
implements EnvConfigObserver {
    private static final boolean MULTI_LOG = true;
    public static TestHook maxFlushLevelHook = null;
    public static TestHook beforeFlushHook = null;
    private EnvironmentImpl envImpl;
    private long checkpointId;
    private long logSizeBytesInterval;
    private long logFileMax;
    private long timeInterval;
    private long lastCheckpointMillis;
    private boolean highPriority;
    private volatile Map<DatabaseImpl, Integer> highestFlushLevels;
    private long nCheckpoints;
    private long lastCheckpointStart;
    private long lastCheckpointEnd;
    private FlushStats flushStats;

    public Checkpointer(EnvironmentImpl envImpl, long waitTime, String name) throws DatabaseException {
        super(waitTime, name, envImpl);
        this.envImpl = envImpl;
        this.logSizeBytesInterval = envImpl.getConfigManager().getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        this.logFileMax = envImpl.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX);
        this.timeInterval = waitTime;
        this.lastCheckpointMillis = 0L;
        this.nCheckpoints = 0L;
        this.flushStats = new FlushStats();
        this.highestFlushLevels = Collections.emptyMap();
        this.envConfigUpdate(envImpl.getConfigManager(), null);
        envImpl.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) throws DatabaseException {
        this.highPriority = cm.getBoolean(EnvironmentParams.CHECKPOINTER_HIGH_PRIORITY);
    }

    public void initIntervals(long lastCheckpointEnd, long lastCheckpointMillis) {
        this.lastCheckpointEnd = lastCheckpointEnd;
        this.lastCheckpointMillis = lastCheckpointMillis;
    }

    public int getHighestFlushLevel(DatabaseImpl db) {
        return Checkpointer.getHighestFlushLevelInternal(db, this.highestFlushLevels);
    }

    private static int getHighestFlushLevelInternal(DatabaseImpl db, Map<DatabaseImpl, Integer> highestFlushLevels) {
        Integer val = highestFlushLevels.get(db);
        return val != null ? val : -1;
    }

    public static long getWakeupPeriod(DbConfigManager configManager) throws IllegalArgumentException, DatabaseException {
        long wakeupPeriod = PropUtil.microsToMillis(configManager.getLong(EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL));
        long bytePeriod = configManager.getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        if (wakeupPeriod == 0L && bytePeriod == 0L) {
            throw new IllegalArgumentException(String.valueOf(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL.getName()) + " and " + EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL.getName() + " cannot both be 0. ");
        }
        if (bytePeriod == 0L) {
            return wakeupPeriod;
        }
        return 0L;
    }

    public synchronized void setCheckpointId(long lastCheckpointId) {
        this.checkpointId = lastCheckpointId;
    }

    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setNCheckpoints(this.nCheckpoints);
        stat.setLastCheckpointStart(this.lastCheckpointStart);
        stat.setLastCheckpointEnd(this.lastCheckpointEnd);
        stat.setLastCheckpointId(this.checkpointId);
        stat.setNFullINFlush(this.flushStats.nFullINFlush);
        stat.setNFullBINFlush(this.flushStats.nFullBINFlush);
        stat.setNDeltaINFlush(this.flushStats.nDeltaINFlush);
        if (config.getClear()) {
            this.nCheckpoints = 0L;
            this.flushStats.nFullINFlush = 0L;
            this.flushStats.nFullBINFlush = 0L;
            this.flushStats.nDeltaINFlush = 0L;
        }
    }

    public synchronized void clearEnv() {
        this.envImpl = null;
    }

    @Override
    protected long nDeadlockRetries() throws DatabaseException {
        return this.envImpl.getConfigManager().getInt(EnvironmentParams.CHECKPOINTER_RETRY);
    }

    @Override
    protected void onWakeup() throws DatabaseException {
        if (this.envImpl.isClosed()) {
            return;
        }
        this.doCheckpoint(CheckpointConfig.DEFAULT, false, "daemon");
    }

    public void wakeupAfterWrite() {
        long nextLsn;
        if (this.logSizeBytesInterval != 0L && DbLsn.getNoCleaningDistance(nextLsn = this.envImpl.getFileManager().getNextLsn(), this.lastCheckpointEnd, this.logFileMax) >= this.logSizeBytesInterval) {
            this.wakeup();
        }
    }

    private boolean isRunnable(CheckpointConfig config) throws DatabaseException {
        long useBytesInterval = 0L;
        long useTimeInterval = 0L;
        long nextLsn = -1L;
        boolean runnable = false;
        try {
            if (config.getForce()) {
                boolean bl = runnable = true;
                return bl;
            }
            if (config.getKBytes() != 0) {
                useBytesInterval = config.getKBytes() << 10;
            } else if (config.getMinutes() != 0) {
                useTimeInterval = config.getMinutes() * 60 * 1000;
            } else if (this.logSizeBytesInterval != 0L) {
                useBytesInterval = this.logSizeBytesInterval;
            } else {
                useTimeInterval = this.timeInterval;
            }
            if (useBytesInterval != 0L) {
                nextLsn = this.envImpl.getFileManager().getNextLsn();
                if (DbLsn.getNoCleaningDistance(nextLsn, this.lastCheckpointEnd, this.logFileMax) >= useBytesInterval) {
                    runnable = true;
                }
            } else if (useTimeInterval != 0L) {
                long lastUsedLsn = this.envImpl.getFileManager().getLastUsedLsn();
                if (System.currentTimeMillis() - this.lastCheckpointMillis >= useTimeInterval && DbLsn.compareTo(lastUsedLsn, this.lastCheckpointEnd) != 0) {
                    runnable = true;
                }
            }
            boolean bl = runnable;
            return bl;
        }
        finally {
            StringBuffer sb = new StringBuffer();
            sb.append("size interval=").append(useBytesInterval);
            if (nextLsn != -1L) {
                sb.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
            }
            if (this.lastCheckpointEnd != -1L) {
                sb.append(" lastCkpt=");
                sb.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
            }
            sb.append(" time interval=").append(useTimeInterval);
            sb.append(" force=").append(config.getForce());
            sb.append(" runnable=").append(runnable);
            Tracer.trace(Level.FINEST, this.envImpl, sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doCheckpoint(CheckpointConfig config, boolean flushAll, String invokingSource) throws DatabaseException {
        if (this.envImpl.isReadOnly()) {
            return;
        }
        if (!this.isRunnable(config)) {
            return;
        }
        boolean flushExtraLevel = false;
        Cleaner cleaner = this.envImpl.getCleaner();
        FileSelector.CheckpointStartCleanerState cleanerState = cleaner.getFilesAtCheckpointStart();
        if (!cleanerState.isEmpty()) {
            flushExtraLevel = true;
        }
        this.lastCheckpointMillis = System.currentTimeMillis();
        this.flushStats.resetPerRunCounters();
        ++this.checkpointId;
        ++this.nCheckpoints;
        boolean success = false;
        boolean traced = false;
        LogManager logManager = this.envImpl.getLogManager();
        DirtyINMap dirtyMap = new DirtyINMap(this.envImpl);
        try {
            try {
                long checkpointStart = -1L;
                long firstActiveLsn = -1L;
                Evictor evictor = this.envImpl.getEvictor();
                synchronized (evictor) {
                    SingleItemEntry startEntry = new SingleItemEntry(LogEntryType.LOG_CKPT_START, new CheckpointStart(this.checkpointId, invokingSource));
                    checkpointStart = logManager.log(startEntry, ReplicationContext.NO_REPLICATE);
                    firstActiveLsn = this.envImpl.getTxnManager().getFirstActiveLsn();
                    if (firstActiveLsn == -1L) {
                        firstActiveLsn = checkpointStart;
                    } else if (DbLsn.compareTo(checkpointStart, firstActiveLsn) < 0) {
                        firstActiveLsn = checkpointStart;
                    }
                    if (this.envImpl.isReplicated()) {
                        this.envImpl.getReplicator().preCheckpointEndFlush();
                    }
                    this.highestFlushLevels = dirtyMap.selectDirtyINsForCheckpoint(flushAll, flushExtraLevel);
                }
                dirtyMap.addCostToMemoryBudget();
                TestHookExecute.doHookIfSet(beforeFlushHook);
                boolean allowDeltas = !config.getMinimizeRecoveryTime();
                Checkpointer.flushDirtyNodes(this.envImpl, dirtyMap, this.highestFlushLevels, allowDeltas, checkpointStart, this.highPriority, this.flushStats);
                dirtyMap.flushMapLNs(checkpointStart);
                dirtyMap.flushRoot(checkpointStart);
                this.envImpl.getUtilizationProfile().flushFileUtilization(this.envImpl.getUtilizationTracker().getTrackedFiles());
                DbTree dbTree = this.envImpl.getDbTree();
                CheckpointEnd ckptEnd = new CheckpointEnd(invokingSource, checkpointStart, this.envImpl.getRootLsn(), firstActiveLsn, this.envImpl.getNodeSequence().getLastLocalNodeId(), this.envImpl.getNodeSequence().getLastReplicatedNodeId(), dbTree.getLastLocalDbId(), dbTree.getLastReplicatedDbId(), this.envImpl.getTxnManager().getLastLocalTxnId(), this.envImpl.getTxnManager().getLastReplicatedTxnId(), this.checkpointId);
                SingleItemEntry endEntry = new SingleItemEntry(LogEntryType.LOG_CKPT_END, ckptEnd);
                this.trace(this.envImpl, invokingSource, true);
                traced = true;
                this.lastCheckpointEnd = logManager.logForceFlush(endEntry, true, ReplicationContext.NO_REPLICATE);
                this.lastCheckpointStart = checkpointStart;
                success = true;
                cleaner.updateFilesAtCheckpointEnd(cleanerState);
            }
            catch (DatabaseException e) {
                Tracer.trace(this.envImpl, "Checkpointer", "doCheckpoint", "checkpointId=" + this.checkpointId, e);
                throw e;
            }
        }
        finally {
            dirtyMap.removeCostFromMemoryBudget();
            this.highestFlushLevels = Collections.emptyMap();
            if (!traced) {
                this.trace(this.envImpl, invokingSource, success);
            }
        }
    }

    private void trace(EnvironmentImpl envImpl, String invokingSource, boolean success) {
        StringBuffer sb = new StringBuffer();
        sb.append("Checkpoint ").append(this.checkpointId);
        sb.append(": source=").append(invokingSource);
        sb.append(" success=").append(success);
        sb.append(" nFullINFlushThisRun=");
        sb.append(this.flushStats.nFullINFlushThisRun);
        sb.append(" nDeltaINFlushThisRun=");
        sb.append(this.flushStats.nDeltaINFlushThisRun);
        Tracer.trace(Level.CONFIG, envImpl, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncDatabase(EnvironmentImpl envImpl, DatabaseImpl dbImpl, boolean flushLog) throws DatabaseException {
        if (envImpl.isReadOnly()) {
            return;
        }
        DirtyINMap dirtyMap = new DirtyINMap(envImpl);
        FlushStats fstats = new FlushStats();
        try {
            try {
                Map<DatabaseImpl, Integer> highestFlushLevels;
                Evictor evictor = envImpl.getEvictor();
                synchronized (evictor) {
                    highestFlushLevels = dirtyMap.selectDirtyINsForDbSync(dbImpl);
                }
                dirtyMap.addCostToMemoryBudget();
                Checkpointer.flushDirtyNodes(envImpl, dirtyMap, highestFlushLevels, false, 0L, false, fstats);
                if (flushLog) {
                    envImpl.getLogManager().flush();
                }
            }
            catch (DatabaseException e) {
                Tracer.trace(envImpl, "Checkpointer", "syncDatabase", "of " + dbImpl.getDebugName(), e);
                throw e;
            }
        }
        finally {
            dirtyMap.removeCostFromMemoryBudget();
        }
    }

    public static void setMaxFlushLevelHook(TestHook hook) {
        maxFlushLevelHook = hook;
    }

    public static void setBeforeFlushHook(TestHook hook) {
        beforeFlushHook = hook;
    }

    private static void flushDirtyNodes(EnvironmentImpl envImpl, DirtyINMap dirtyMap, Map<DatabaseImpl, Integer> highestFlushLevels, boolean allowDeltas, long checkpointStart, boolean highPriority, FlushStats fstats) throws DatabaseException {
        LogManager logManager = envImpl.getLogManager();
        DbTree dbTree = envImpl.getDbTree();
        LocalUtilizationTracker localTracker = new LocalUtilizationTracker(envImpl);
        while (dirtyMap.getNumLevels() > 0) {
            CheckpointReference targetRef;
            Integer currentLevel = dirtyMap.getLowestLevelSet();
            int currentLevelVal = currentLevel;
            if (currentLevelVal == 131072) {
                dirtyMap.flushMapLNs(checkpointStart);
            }
            while ((targetRef = dirtyMap.removeNextNode(currentLevel)) != null) {
                DatabaseImpl db = null;
                try {
                    int maxFlushLevel;
                    db = dbTree.getDb(targetRef.dbId);
                    if (db == null || db.isDeleted() || currentLevelVal > (maxFlushLevel = Checkpointer.getHighestFlushLevelInternal(db, highestFlushLevels))) continue;
                    envImpl.getEvictor().doCriticalEviction(true);
                    Checkpointer.flushIN(envImpl, db, logManager, targetRef, dirtyMap, currentLevelVal, maxFlushLevel, allowDeltas, checkpointStart, highPriority, fstats, localTracker, true);
                    envImpl.sleepAfterBackgroundIO();
                }
                finally {
                    dbTree.releaseDb(db);
                }
            }
            dirtyMap.removeLevel(currentLevel);
        }
        logManager.transferToUtilizationTracker(localTracker);
    }

    private static void flushIN(EnvironmentImpl envImpl, DatabaseImpl db, LogManager logManager, CheckpointReference targetRef, DirtyINMap dirtyMap, int currentLevel, int maxFlushLevel, boolean allowDeltas, long checkpointStart, boolean highPriority, FlushStats fstats, LocalUtilizationTracker localTracker, boolean allowLogSubtree) throws DatabaseException {
        assert (currentLevel < maxFlushLevel || TestHookExecute.doHookIfSet(maxFlushLevelHook));
        Tree tree = db.getTree();
        boolean targetWasRoot = false;
        if (targetRef.isDbRoot) {
            RootFlusher flusher = new RootFlusher(db, logManager, targetRef.nodeId);
            tree.withRootLatchedExclusive(flusher);
            boolean flushed = flusher.getFlushed();
            targetWasRoot = flusher.stillRoot();
            if (flushed) {
                DbTree dbTree = envImpl.getDbTree();
                dbTree.modifyDbRoot(db);
                ++fstats.nFullINFlushThisRun;
                ++fstats.nFullINFlush;
            }
        }
        if (!targetWasRoot) {
            SearchResult result = tree.getParentINForChildIN(targetRef.nodeId, targetRef.containsDuplicates, false, targetRef.mainTreeKey, targetRef.dupTreeKey, false, CacheMode.UNCHANGED, -1, null, false);
            if (result.parent != null) {
                CheckpointReference parentRef;
                boolean bottomLevelTarget;
                IN parent = result.parent;
                boolean mustLogParent = false;
                boolean bl = db.getSortedDuplicates() ? parent.getLevel() == 2 : (bottomLevelTarget = (parent.getLevel() & 0xFFFF) == 2);
                Provisional provisional = currentLevel >= maxFlushLevel ? Provisional.NO : (bottomLevelTarget ? Provisional.YES : Provisional.BEFORE_CKPT_END);
                boolean logSubtree = bottomLevelTarget && allowLogSubtree;
                boolean logSiblingsWithParentLatchHeld = logSubtree && highPriority && !db.isDurableDeferredWrite();
                boolean logTargetWithOtherSiblings = false;
                TreeMap<Long, Integer> siblingsToLog = null;
                try {
                    if (result.exactParentFound) {
                        IN renewedTarget = (IN)parent.getTarget(result.index);
                        if (renewedTarget == null) {
                            mustLogParent |= true;
                        } else if (logSiblingsWithParentLatchHeld) {
                            logTargetWithOtherSiblings = true;
                        } else {
                            mustLogParent |= Checkpointer.logSiblings(envImpl, dirtyMap, parent, Collections.singleton(result.index), allowDeltas, checkpointStart, highPriority, provisional, fstats, localTracker);
                        }
                    } else {
                        logSubtree = false;
                        if (result.childNotResident && parent.getLevel() > currentLevel) {
                            mustLogParent |= true;
                        }
                    }
                    if (logSubtree) {
                        siblingsToLog = new TreeMap<Long, Integer>();
                        int index = 0;
                        while (index < parent.getNEntries()) {
                            Node child = parent.getTarget(index);
                            if (child != null) {
                                Long childId = child.getNodeId();
                                if (logTargetWithOtherSiblings && targetRef.nodeId == childId || dirtyMap.containsNode(child.getLevel(), childId)) {
                                    siblingsToLog.put(childId, index);
                                }
                            }
                            ++index;
                        }
                        if (logSiblingsWithParentLatchHeld) {
                            mustLogParent |= Checkpointer.logSiblings(envImpl, dirtyMap, parent, siblingsToLog.values(), allowDeltas, checkpointStart, highPriority, provisional, fstats, localTracker);
                            siblingsToLog = null;
                        }
                    }
                    if (mustLogParent) {
                        assert (Checkpointer.checkParentChildRelationship(result, currentLevel)) : Checkpointer.dumpParentChildInfo(result, parent, targetRef.nodeId, currentLevel, tree);
                        dirtyMap.addIN(parent, true);
                    }
                }
                finally {
                    parent.releaseLatch();
                }
                if (siblingsToLog != null) {
                    assert (logSubtree);
                    assert (!logSiblingsWithParentLatchHeld);
                    Iterator iterator = siblingsToLog.keySet().iterator();
                    while (iterator.hasNext()) {
                        long childId = (Long)iterator.next();
                        assert (targetRef.nodeId != childId);
                        CheckpointReference childRef = dirtyMap.removeNode(currentLevel, childId);
                        if (childRef == null) continue;
                        Checkpointer.flushIN(envImpl, db, logManager, childRef, dirtyMap, currentLevel, maxFlushLevel, allowDeltas, checkpointStart, highPriority, fstats, localTracker, false);
                    }
                }
                if (logSubtree && parent.getLevel() <= maxFlushLevel && (parentRef = dirtyMap.removeNode(parent.getLevel(), parent.getNodeId())) != null) {
                    Checkpointer.flushIN(envImpl, db, logManager, parentRef, dirtyMap, parent.getLevel(), maxFlushLevel, allowDeltas, checkpointStart, highPriority, fstats, localTracker, false);
                }
            }
        }
    }

    private static boolean checkParentChildRelationship(SearchResult result, int childLevel) {
        if (result.childNotResident && !result.exactParentFound) {
            return true;
        }
        int parentLevel = result.parent.getLevel();
        boolean isMapTree = (childLevel & 0x20000) != 0;
        boolean isMainTree = (childLevel & 0x10000) != 0;
        boolean checkOk = false;
        if (isMapTree || isMainTree) {
            if (parentLevel == childLevel + 1) {
                checkOk = true;
            }
        } else if (childLevel == 1) {
            if (parentLevel == 2) {
                checkOk = true;
            }
        } else if (parentLevel == 65537 || parentLevel == childLevel + 1) {
            checkOk = true;
        }
        return checkOk;
    }

    private static String dumpParentChildInfo(SearchResult result, IN parent, long childNodeId, int currentLevel, Tree tree) throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        sb.append(" result=").append(result);
        sb.append(" parent node=").append(parent.getNodeId());
        sb.append(" level=").append(parent.getLevel());
        sb.append(" child node=").append(childNodeId);
        sb.append(" level=").append(currentLevel);
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean logSiblings(EnvironmentImpl envImpl, DirtyINMap dirtyMap, IN parent, Collection<Integer> indicesToLog, boolean allowDeltas, long checkpointStart, boolean highPriority, Provisional provisional, FlushStats fstats, LocalUtilizationTracker localTracker) throws DatabaseException {
        logManager = envImpl.getLogManager();
        context = new INLogContext();
        context.nodeDb = parent.getDatabase();
        context.backgroundIO = true;
        context.allowDeltas = allowDeltas;
        context.proactiveMigration = highPriority == false;
        mustLogParent = false;
        itemList = new ArrayList<INLogItem>();
        try {
            for (int index : indicesToLog) {
                child = (IN)parent.getTarget(index);
                dirtyMap.removeNode(child.getLevel(), child.getNodeId());
                child.latch(CacheMode.UNCHANGED);
                item = new INLogItem();
                itemList.add(item);
                envImpl.lazyCompress(child, localTracker);
                if (child.getDirty()) {
                    if (child.getDatabase().isDurableDeferredWrite()) {
                        child.logDirtyChildren();
                    }
                    item.provisional = provisional;
                    item.repContext = ReplicationContext.NO_REPLICATE;
                    item.parent = parent;
                    item.parentIndex = index;
                    child.beforeLog(logManager, item, context);
                    continue;
                }
                itemList.remove(itemList.size() - 1);
                child.releaseLatch();
                mustLogParent = true;
            }
            itemArray = new LogItem[itemList.size()];
            logManager.multiLog(itemList.toArray(itemArray), context);
            for (INLogItem item : itemList) {
                child = (IN)parent.getTarget(item.parentIndex);
                child.afterLog(logManager, item, context);
                logThisParent = true;
                if (allowDeltas && item.newLsn == -1L) {
                    ++fstats.nDeltaINFlushThisRun;
                    ++fstats.nDeltaINFlush;
                    if (DbLsn.compareTo(child.getLastFullVersion(), checkpointStart) < 0) {
                        logThisParent = false;
                    }
                }
                if (logThisParent) {
                    mustLogParent = true;
                }
                if (item.newLsn == -1L) continue;
                ++fstats.nFullINFlushThisRun;
                ++fstats.nFullINFlush;
                if (child instanceof BIN) {
                    ++fstats.nFullBINFlush;
                    ++fstats.nFullBINFlushThisRun;
                }
                parent.updateEntry(item.parentIndex, item.newLsn);
            }
            var21_20 = mustLogParent;
            return var21_20;
        }
        finally {
            ** for (item : itemList)
        }
lbl-1000:
        // 1 sources

        {
            child = (IN)parent.getTarget(item.parentIndex);
            child.releaseLatch();
            continue;
        }
lbl61:
        // 1 sources

        return var21_20;
    }

    public static class CheckpointReference {
        DatabaseId dbId;
        long nodeId;
        boolean containsDuplicates;
        boolean isDbRoot;
        byte[] mainTreeKey;
        byte[] dupTreeKey;

        public CheckpointReference(DatabaseId dbId, long nodeId, boolean containsDuplicates, boolean isDbRoot, byte[] mainTreeKey, byte[] dupTreeKey) {
            this.dbId = dbId;
            this.nodeId = nodeId;
            this.containsDuplicates = containsDuplicates;
            this.isDbRoot = isDbRoot;
            this.mainTreeKey = mainTreeKey;
            this.dupTreeKey = dupTreeKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CheckpointReference)) {
                return false;
            }
            CheckpointReference other = (CheckpointReference)o;
            return this.nodeId == other.nodeId;
        }

        public int hashCode() {
            return (int)this.nodeId;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("db=").append(this.dbId);
            sb.append(" nodeId=").append(this.nodeId);
            return sb.toString();
        }
    }

    public static class FlushStats {
        public long nFullINFlush;
        public long nFullBINFlush;
        public long nDeltaINFlush;
        public long nFullINFlushThisRun;
        public long nFullBINFlushThisRun;
        public long nDeltaINFlushThisRun;

        void resetPerRunCounters() {
            this.nFullINFlushThisRun = 0L;
            this.nFullBINFlushThisRun = 0L;
            this.nDeltaINFlushThisRun = 0L;
        }
    }

    private static class RootFlusher
    implements WithRootLatched {
        private DatabaseImpl db;
        private boolean flushed;
        private boolean stillRoot;
        private LogManager logManager;
        private long targetNodeId;

        RootFlusher(DatabaseImpl db, LogManager logManager, long targetNodeId) {
            this.db = db;
            this.flushed = false;
            this.logManager = logManager;
            this.targetNodeId = targetNodeId;
            this.stillRoot = false;
        }

        @Override
        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null) {
                return null;
            }
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            rootIN.latch(CacheMode.UNCHANGED);
            try {
                if (rootIN.getNodeId() == this.targetNodeId) {
                    if (rootIN.getDatabase().isDurableDeferredWrite()) {
                        rootIN.logDirtyChildren();
                    }
                    this.stillRoot = true;
                    if (rootIN.getDirty()) {
                        long newLsn = rootIN.log(this.logManager);
                        root.setLsn(newLsn);
                        this.flushed = true;
                    }
                }
            }
            finally {
                rootIN.releaseLatch();
            }
            return null;
        }

        boolean getFlushed() {
            return this.flushed;
        }

        boolean stillRoot() {
            return this.stillRoot;
        }
    }
}

