/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.utilint.Adler32;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;

class ChecksumValidator {
    private static final boolean DEBUG = false;
    private Checksum cksum = Adler32.makeChecksum();

    ChecksumValidator() {
    }

    void reset() {
        this.cksum.reset();
    }

    void update(EnvironmentImpl env, ByteBuffer buf, int length, boolean anticipateChecksumErrors) throws DbChecksumException {
        if (buf == null) {
            throw new DbChecksumException(anticipateChecksumErrors ? null : env, "null buffer given to checksum validation, probably  result of 0's in log file. " + anticipateChecksumErrors);
        }
        int bufStart = buf.position();
        if (buf.hasArray()) {
            this.cksum.update(buf.array(), bufStart + buf.arrayOffset(), length);
        } else {
            int i = bufStart;
            while (i < length + bufStart) {
                this.cksum.update(buf.get(i));
                ++i;
            }
        }
    }

    void validate(EnvironmentImpl env, long expectedChecksum, long lsn) throws DbChecksumException {
        if (expectedChecksum != this.cksum.getValue()) {
            throw new DbChecksumException(env, "Location " + DbLsn.getNoFormatString(lsn) + " expected " + expectedChecksum + " got " + this.cksum.getValue());
        }
    }

    void validate(EnvironmentImpl env, long expectedChecksum, long fileNum, long fileOffset, boolean anticipateChecksumErrors) throws DbChecksumException {
        if (expectedChecksum != this.cksum.getValue()) {
            long problemLsn = DbLsn.makeLsn(fileNum, fileOffset);
            throw new DbChecksumException(anticipateChecksumErrors ? null : env, "Location " + DbLsn.getNoFormatString(problemLsn) + " expected " + expectedChecksum + " got " + this.cksum.getValue());
        }
    }
}

