/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;

class DbEnvState {
    private static final boolean DEBUG = false;
    private String name;
    public static final DbEnvState INIT = new DbEnvState("initialized");
    public static final DbEnvState OPEN = new DbEnvState("open");
    public static final DbEnvState CLOSED = new DbEnvState("closed");
    public static final DbEnvState INVALID = new DbEnvState("invalid");
    public static final DbEnvState[] VALID_FOR_OPEN = new DbEnvState[]{INIT, CLOSED};
    public static final DbEnvState[] VALID_FOR_CLOSE = new DbEnvState[]{INIT, OPEN, INVALID};
    public static final DbEnvState[] VALID_FOR_REMOVE = new DbEnvState[]{INIT, CLOSED};

    DbEnvState(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    void checkState(DbEnvState[] validPrevStates, DbEnvState newState) throws DatabaseException {
        boolean transitionOk = false;
        int i = 0;
        while (i < validPrevStates.length) {
            if (this == validPrevStates[i]) {
                transitionOk = true;
                break;
            }
            ++i;
        }
        if (!transitionOk) {
            throw new DatabaseException("Can't go from environment state " + this.toString() + " to " + newState.toString());
        }
    }
}

