/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;

public class JoinCursor {
    private JoinConfig config;
    private Database priDb;
    private Cursor priCursor;
    private Cursor[] secCursors;
    private DatabaseEntry[] cursorScratchEntries;
    private DatabaseEntry scratchEntry;

    JoinCursor(Locker locker, Database primaryDb, final Cursor[] cursors, JoinConfig configParam) throws DatabaseException {
        this.priDb = primaryDb;
        this.config = configParam != null ? configParam.cloneConfig() : JoinConfig.DEFAULT;
        this.scratchEntry = new DatabaseEntry();
        this.cursorScratchEntries = new DatabaseEntry[cursors.length];
        Cursor[] sortedCursors = new Cursor[cursors.length];
        System.arraycopy(cursors, 0, sortedCursors, 0, cursors.length);
        if (!this.config.getNoSort()) {
            final int[] counts = new int[cursors.length];
            int i = 0;
            while (i < cursors.length) {
                counts[i] = cursors[i].countInternal(LockMode.READ_UNCOMMITTED);
                assert (counts[i] >= 0);
                ++i;
            }
            Arrays.sort(sortedCursors, new Comparator<Cursor>(){

                @Override
                public int compare(Cursor o1, Cursor o2) {
                    int count1 = -1;
                    int count2 = -1;
                    int i = 0;
                    while (i < cursors.length && (count1 < 0 || count2 < 0)) {
                        if (cursors[i] == o1) {
                            count1 = counts[i];
                        } else if (cursors[i] == o2) {
                            count2 = counts[i];
                        }
                        ++i;
                    }
                    if (!($assertionsDisabled || count1 >= 0 && count2 >= 0)) {
                        throw new AssertionError();
                    }
                    return count1 - count2;
                }
            });
        }
        try {
            this.priCursor = new Cursor(this.priDb, locker, null);
            this.secCursors = new Cursor[cursors.length];
            int i = 0;
            while (i < cursors.length) {
                this.secCursors[i] = new Cursor(sortedCursors[i], true);
                ++i;
            }
        }
        catch (DatabaseException e) {
            this.close(e);
        }
    }

    public void close() throws DatabaseException {
        if (this.priCursor == null) {
            throw new DatabaseException("Already closed");
        }
        this.close(null);
    }

    private void close(DatabaseException firstException) throws DatabaseException {
        if (this.priCursor != null) {
            block8: {
                try {
                    this.priCursor.close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block8;
                    firstException = e;
                }
            }
            this.priCursor = null;
        }
        int i = 0;
        while (i < this.secCursors.length) {
            if (this.secCursors[i] != null) {
                block9: {
                    try {
                        this.secCursors[i].close();
                    }
                    catch (DatabaseException e) {
                        if (firstException != null) break block9;
                        firstException = e;
                    }
                }
                this.secCursors[i] = null;
            }
            ++i;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    Cursor[] getSortedCursors() {
        return this.secCursors;
    }

    public Database getDatabase() {
        return this.priDb;
    }

    public JoinConfig getConfig() {
        return this.config.cloneConfig();
    }

    public OperationStatus getNext(DatabaseEntry key, LockMode lockMode) throws DatabaseException {
        this.priCursor.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", false);
        this.priCursor.trace(Level.FINEST, "JoinCursor.getNext(key): ", lockMode);
        return this.retrieveNext(key, null, lockMode);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.priCursor.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.priCursor.trace(Level.FINEST, "JoinCursor.getNext(key,data): ", lockMode);
        return this.retrieveNext(key, data, lockMode);
    }

    private OperationStatus retrieveNext(DatabaseEntry keyParam, DatabaseEntry dataParam, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        DatabaseEntry candidateKey;
        block0: while (true) {
            Cursor secCursor = this.secCursors[0];
            candidateKey = this.cursorScratchEntries[0];
            if (candidateKey == null) {
                this.cursorScratchEntries[0] = candidateKey = new DatabaseEntry();
                status = secCursor.getCurrentInternal(this.scratchEntry, candidateKey, lockMode);
            } else {
                status = secCursor.retrieveNext(this.scratchEntry, candidateKey, lockMode, GetMode.NEXT_DUP);
            }
            if (status != OperationStatus.SUCCESS) {
                return status;
            }
            int i = 1;
            while (i < this.secCursors.length) {
                secCursor = this.secCursors[i];
                DatabaseEntry secKey = this.cursorScratchEntries[i];
                if (secKey == null) {
                    this.cursorScratchEntries[i] = secKey = new DatabaseEntry();
                    status = secCursor.getCurrentInternal(secKey, this.scratchEntry, lockMode);
                    assert (status == OperationStatus.SUCCESS);
                }
                this.scratchEntry.setData(secKey.getData(), secKey.getOffset(), secKey.getSize());
                status = secCursor.search(this.scratchEntry, candidateKey, lockMode, CursorImpl.SearchMode.BOTH);
                if (status != OperationStatus.SUCCESS) continue block0;
                ++i;
            }
            break;
        }
        if (dataParam != null && (status = this.priCursor.search(candidateKey, dataParam, lockMode, CursorImpl.SearchMode.SET)) != OperationStatus.SUCCESS) {
            throw new DatabaseException("Secondary corrupt");
        }
        keyParam.setData(candidateKey.getData(), candidateKey.getOffset(), candidateKey.getSize());
        return OperationStatus.SUCCESS;
    }
}

