/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.memcached.notify.listener;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.client.CacheClient;
import com.lenovo.vctl.dal.cache.exception.CacheException;
import com.lenovo.vctl.dal.cache.listener.Listener;
import com.lenovo.vctl.dal.cache.memcached.channel.source.MemcachedSource;
import com.lenovo.vctl.dal.cache.memcached.client.MemCachedClientImpl;
import com.lenovo.vctl.dal.cache.memcached.config.helper.CacheConfigHelper;
import com.lenovo.vctl.dal.cache.memcached.notify.model.Message;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;

public class NotifyListenerImpl
implements Listener {
    private static Logger logger;
    private static CacheClient cachedClient;
    public static final String QUEUE_NAME = "listener";
    private static String locahostIp;

    static {
        block3: {
            logger = Logger.getLogger(NotifyListenerImpl.class);
            cachedClient = null;
            MemcachedSource source = CacheConfigHelper.getDefaultQueueMemcachedSource();
            if (source != null) {
                cachedClient = new MemCachedClientImpl(source);
            }
            try {
                locahostIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.error((Object)e.getMessage());
            }
        }
        locahostIp = "";
    }

    @Override
    public void afterListener(Cache cache, Object key, Object value, String operateMethod) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("afterListener cache :         " + cache.getRegion() + " key : " + ObjectUtils.toString((Object)key, (String)"") + " value : " + ObjectUtils.toString((Object)value, (String)"") + " method:         " + operateMethod));
            }
            if (cachedClient != null) {
                Message message = new Message();
                message.setIpAddress(locahostIp);
                message.setKeys(ObjectUtils.toString((Object)key, (String)""));
                message.setMethodName(operateMethod);
                message.setRegionName(cache.getRegion());
                message.setTime(System.currentTimeMillis());
                cachedClient.set(QUEUE_NAME, message.toEventStr());
            }
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void beforeListener(Cache cache, Object key, Object value, String operateMethod) {
    }

    @Override
    public void afterListener(Cache cache, Object[] key, Object[] value, String operateMethod) {
    }

    @Override
    public void beforeListener(Cache cache, Object[] key, Object[] value, String operateMethod) {
    }

    public static void main(String[] args) {
        try {
            System.out.println(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

