/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.memcached.config.helper;

import com.lenovo.vctl.dal.cache.config.model.KeyPatternItem;
import com.lenovo.vctl.dal.cache.config.model.QueueItem;
import com.lenovo.vctl.dal.cache.config.model.RegionItem;
import com.lenovo.vctl.dal.cache.memcached.channel.source.MemcachedSource;
import com.lenovo.vctl.dal.cache.memcached.config.CacheConfig;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class CacheConfigHelper {
    private static Logger logger = Logger.getLogger(CacheConfigHelper.class);

    public static Map<String, KeyPatternItem> getKeyKeyPatternItems(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem == null) {
                logger.error((Object)("don't find the " + regionName + " RegionItem in " + CacheConfig.CONFIG_FILE));
                return null;
            }
            return regionItem.getKeyPatternMap();
        }
        logger.error((Object)"region name must have a value");
        return null;
    }

    public static Map<String, KeyPatternItem> getDefaultKeyKeyPatternItems() {
        RegionItem regionItem = CacheConfig.getInstance().getDefaultRegionItem();
        if (regionItem == null) {
            logger.error((Object)("cannot find the default RegionItem in " + CacheConfig.CONFIG_FILE));
            return null;
        }
        return regionItem.getKeyPatternMap();
    }

    public static MemcachedSource getMemcachedSource(String name) {
        return StringUtils.isNotEmpty((String)name) ? CacheConfig.getInstance().getMemcachedSource(name) : null;
    }

    public static String getQueueSourceName(String queueName) {
        if (StringUtils.isBlank((String)queueName)) {
            return null;
        }
        QueueItem item = CacheConfig.getInstance().getQueueItem(queueName);
        return item != null ? item.getDatasource() : null;
    }

    public static MemcachedSource getDefaultQueueMemcachedSource() {
        QueueItem item = CacheConfig.getInstance().getQueueItem("default");
        return item == null ? null : CacheConfigHelper.getMemcachedSource(item.getDatasource());
    }

    public static MemcachedSource getDynamicMemcachedSource() {
        return CacheConfig.getInstance().getDynamicMemcachedSource();
    }

    public static String getStrategyClassName(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem != null) {
                return regionItem.getStrategyClass();
            }
            logger.error((Object)("don't find regionName config: " + regionName));
            return null;
        }
        logger.error((Object)"regionName is null or empty");
        return null;
    }

    public static String getListenerClass(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem != null) {
                return regionItem.getListenerClass();
            }
            logger.error((Object)("don't find regionName config: " + regionName));
            return null;
        }
        logger.error((Object)"regionName is null or empty");
        return null;
    }

    public static int getListLimitLen(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            if (regionItem != null) {
                return regionItem.getLimitLen();
            }
            logger.error((Object)("don't find regionName config: " + regionName));
            return 0;
        }
        logger.error((Object)"regionName is null or empty");
        return 0;
    }

    public static boolean isExistRegion(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            return regionItem != null;
        }
        return false;
    }

    public static boolean isLocalCache(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            return regionItem == null ? false : regionItem.isLocalCache();
        }
        return false;
    }

    public static boolean isRemoteCache(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            return regionItem == null ? false : regionItem.isRemoteCache();
        }
        return false;
    }

    public static boolean isHasClassInfo(String regionName) {
        if (StringUtils.isNotEmpty((String)regionName)) {
            RegionItem regionItem = CacheConfig.getInstance().getRegionItem(regionName);
            return regionItem == null ? true : regionItem.isHasClassInfo();
        }
        return true;
    }
}

