/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.memcached.client;

import com.lenovo.vctl.dal.cache.client.CacheClient;
import com.lenovo.vctl.dal.cache.memcached.channel.MemcachedChannel;
import com.lenovo.vctl.dal.cache.memcached.channel.source.MemcachedSource;
import com.lenovo.vctl.dal.cache.memcached.exception.NestedIOException;
import com.lenovo.vctl.dal.cache.memcached.handler.ErrorHandler;
import com.lenovo.vctl.dal.cache.memcached.handler.NativeHandler;
import com.lenovo.vctl.dal.cache.memcached.io.GetInputStreamWrapper;
import com.lenovo.vctl.dal.cache.memcached.io.IncrOrDecrInputStreamWrapper;
import com.lenovo.vctl.dal.cache.memcached.io.SetInputStreamWrapper;
import com.lenovo.vctl.dal.cache.memcached.stream.ContextObjectInputStream;
import com.lenovo.vctl.dal.cache.memcached.util.MemcachedUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MemCachedClientImpl
implements CacheClient {
    public static final String VALUE = "VALUE";
    public static final String STATS = "STAT";
    public static final String ITEM = "ITEM";
    public static final String DELETED = "DELETED";
    public static final String NOTFOUND = "NOT_FOUND";
    public static final String STORED = "STORED";
    public static final String NOTSTORED = "NOT_STORED";
    public static final String OK = "OK";
    public static final String END = "END";
    public static final String ERROR = "ERROR";
    public static final String CLIENT_ERROR = "CLIENT_ERROR";
    public static final String SERVER_ERROR = "SERVER_ERROR";
    public static final byte[] B_END = "END\r\n".getBytes();
    public static final byte[] B_NOTFOUND = "NOT_FOUND\r\n".getBytes();
    public static final byte[] B_DELETED = "DELETED\r\r".getBytes();
    public static final byte[] B_STORED = "STORED\r\r".getBytes();
    public static final int MARKER_BYTE = 1;
    public static final int MARKER_BOOLEAN = 8192;
    public static final int MARKER_INTEGER = 4;
    public static final int MARKER_LONG = 16384;
    public static final int MARKER_CHARACTER = 16;
    public static final int MARKER_STRING = 32;
    public static final int MARKER_STRINGBUFFER = 64;
    public static final int MARKER_FLOAT = 128;
    public static final int MARKER_SHORT = 256;
    public static final int MARKER_DOUBLE = 512;
    public static final int MARKER_DATE = 1024;
    public static final int MARKER_STRINGBUILDER = 2048;
    public static final int MARKER_BYTEARR = 4096;
    public static final int F_COMPRESSED = 2;
    public static final int F_SERIALIZED = 8;
    private static Logger log = Logger.getLogger(MemCachedClientImpl.class);
    private MemcachedSource source;
    private ErrorHandler errorHandler;
    private boolean sanitizeKeys;
    private boolean primitiveAsString;
    private boolean compressEnable = false;
    private long compressThreshold = 128L;
    private String defaultEncoding;
    private ClassLoader classLoader = null;

    public MemCachedClientImpl() {
    }

    public MemCachedClientImpl(MemcachedSource source) {
        this.source = source;
    }

    public void setSource(MemcachedSource source) {
        this.source = source;
    }

    @Override
    public boolean remove(String key) {
        return this.delete(key, null);
    }

    @Override
    public boolean delete(String key) {
        return this.delete(key, null);
    }

    @Override
    public boolean delete(String key, Date expiry) {
        String line;
        MemcachedChannel channel;
        block17: {
            if (key == null) {
                log.error((Object)"null value for key passed to delete()");
                return false;
            }
            try {
                key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                }
                log.error((Object)"failed to sanitize your key!", (Throwable)e);
                return false;
            }
            channel = null;
            try {
                channel = this.source.getMemcachedChannel();
            }
            catch (Exception e1) {
                log.error((Object)("error : " + e1.getMessage()));
                e1.printStackTrace();
            }
            if (channel == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
                }
                return false;
            }
            StringBuilder command = new StringBuilder("delete ").append(key);
            if (expiry != null) {
                command.append(" " + expiry.getTime() / 1000L);
            }
            command.append("\r\n");
            channel.write(command.toString().getBytes());
            channel.flush();
            line = channel.readLine();
            if (!DELETED.equals(line)) break block17;
            if (log.isDebugEnabled()) {
                log.info((Object)("deletion of key: " + key + " from cache was a success"));
            }
            this.closeMemcachedChannel(channel, key);
            return true;
        }
        try {
            if (NOTFOUND.equals(line)) {
                if (log.isDebugEnabled()) {
                    log.info((Object)("deletion of key: " + key + " from cache failed as the key was not found"));
                }
            } else {
                log.error((Object)("error deleting key: " + key));
                log.error((Object)("server response: " + line));
            }
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            log.error((Object)"exception thrown while writing bytes to server on delete");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.closeMemcachedChannel(channel, key);
        return false;
    }

    @Override
    public boolean flushAll() {
        return false;
    }

    @Override
    public Object get(String key) {
        boolean asString = false;
        if (StringUtils.isEmpty((String)key)) {
            log.error((Object)"key is null for get()");
            return null;
        }
        try {
            key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
            }
            log.error((Object)"failed to sanitize your key!", (Throwable)e);
            return null;
        }
        MemcachedChannel channel = null;
        try {
            channel = this.source.getMemcachedChannel();
        }
        catch (Exception e1) {
            log.error((Object)("error : " + e1.getMessage()));
            e1.printStackTrace();
        }
        if (channel == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
            }
            return null;
        }
        try {
            String line;
            StringBuffer sb = new StringBuffer();
            sb.append("get ").append(key).append("\r\n");
            channel.write(sb.toString().getBytes());
            channel.flush();
            Object o = null;
            GetInputStreamWrapper getInputStreamWrapper = new GetInputStreamWrapper(channel);
            while ((line = getInputStreamWrapper.readKeys(key)).startsWith(VALUE)) {
                String[] info = line.split(" ");
                int flag = Integer.parseInt(info[2]);
                int length = Integer.parseInt(info[3]);
                byte[] buf = new byte[length];
                getInputStreamWrapper.read(buf);
                getInputStreamWrapper.clearEOL();
                if ((flag & 2) == 2) {
                    try {
                        int count;
                        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                        byte[] tmp = new byte[2048];
                        while ((count = gzi.read(tmp)) != -1) {
                            bos.write(tmp, 0, count);
                        }
                        buf = bos.toByteArray();
                        gzi.close();
                    }
                    catch (IOException e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                        }
                        log.error((Object)("IOException thrown while trying to uncompress input stream for key: " + key));
                        log.error((Object)e.getMessage(), (Throwable)e);
                        throw new NestedIOException("IOException thrown while trying to uncompress input stream for key: " + key, e);
                    }
                }
                if ((flag & 8) != 8) {
                    if (this.primitiveAsString || asString) {
                        log.info((Object)"retrieving object and stuffing into a string.");
                        o = new String(buf, this.defaultEncoding);
                        continue;
                    }
                    try {
                        o = NativeHandler.decode(buf, flag);
                        continue;
                    }
                    catch (Exception e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                        }
                        log.error((Object)("++++ Exception thrown while trying to deserialize for key: " + key), (Throwable)e);
                        throw new NestedIOException(e);
                    }
                }
                ContextObjectInputStream ois = new ContextObjectInputStream(new ByteArrayInputStream(buf), this.classLoader);
                try {
                    o = ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                    }
                    log.error((Object)("ClassNotFoundException thrown while trying to deserialize for key: " + key), (Throwable)e);
                    throw new NestedIOException("+++ failed while trying to deserialize for key: " + key, e);
                }
            }
            if (!END.equals(line)) {
                log.error((Object)("server error:" + StringUtils.defaultIfEmpty((String)line, (String)"")));
            }
            this.closeMemcachedChannel(channel, key);
            return o;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
            }
            log.error((Object)("++++ exception thrown while trying to get object from cache for key: " + key));
            log.error((Object)e.getMessage(), (Throwable)e);
            this.closeMemcachedChannel(channel, key);
            return null;
        }
    }

    @Override
    public boolean replace(String key, Object value) {
        return false;
    }

    @Override
    public boolean replace(String key, Object value, Date expiry) {
        return false;
    }

    @Override
    public boolean set(String key, Object value) {
        return this.set(key, value, null);
    }

    @Override
    public boolean set(String key, Object value, Date expiry) {
        String line;
        byte[] val;
        MemcachedChannel channel;
        block37: {
            ByteArrayOutputStream bos;
            if (expiry == null) {
                expiry = new Date(0L);
            }
            String cmdName = "set";
            try {
                key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                log.error((Object)"failed to sanitize your key!", (Throwable)e);
                return false;
            }
            if (value == null) {
                log.error((Object)"trying to store a null value to cache");
                return false;
            }
            channel = null;
            try {
                channel = this.source.getMemcachedChannel();
            }
            catch (Exception e1) {
                log.error((Object)("error : " + e1.getMessage()));
                e1.printStackTrace();
            }
            if (channel == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
                }
                return false;
            }
            boolean asString = false;
            int flags = 0;
            if (NativeHandler.isHandled(value)) {
                if (asString) {
                    try {
                        log.info((Object)("storing data as a string for key: " + key + " for class: " + value.getClass().getName()));
                        val = value.toString().getBytes(this.defaultEncoding);
                    }
                    catch (UnsupportedEncodingException ue) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnSet(this, ue, key);
                        }
                        log.error((Object)("invalid encoding type used: " + this.defaultEncoding), (Throwable)ue);
                        this.closeMemcachedChannel(channel, key);
                        return false;
                    }
                } else {
                    try {
                        flags |= NativeHandler.getMarkerFlag(value);
                        val = NativeHandler.encode(value);
                    }
                    catch (Exception e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnSet(this, e, key);
                        }
                        log.error((Object)"Failed to native handle obj", (Throwable)e);
                        this.closeMemcachedChannel(channel, key);
                        return false;
                    }
                }
            } else {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("serializing for key: " + key + " for class: " + value.getClass().getName()));
                    }
                    bos = new ByteArrayOutputStream();
                    new ObjectOutputStream(bos).writeObject(value);
                    val = bos.toByteArray();
                    flags |= 8;
                }
                catch (IOException e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnSet(this, e, key);
                    }
                    log.error((Object)"failed to serialize obj", (Throwable)e);
                    log.error((Object)value.toString());
                    this.closeMemcachedChannel(channel, key);
                    return false;
                }
            }
            if (this.compressEnable && (long)val.length > this.compressThreshold) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"trying to compress data");
                        log.debug((Object)("++++ size prior to compression: " + val.length));
                    }
                    bos = new ByteArrayOutputStream(val.length);
                    GZIPOutputStream gos = new GZIPOutputStream(bos);
                    gos.write(val, 0, val.length);
                    gos.finish();
                    val = bos.toByteArray();
                    flags |= 2;
                    if (log.isDebugEnabled()) {
                        log.info((Object)("compression succeeded, size after: " + val.length));
                    }
                }
                catch (IOException e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnSet(this, e, key);
                    }
                    log.error((Object)("IOException while compressing stream: " + e.getMessage()));
                    log.error((Object)"storing data uncompressed");
                }
            }
            String cmd = String.format("%s %s %d %d %d\r\n", cmdName, key, flags, expiry.getTime() / 1000L, val.length);
            channel.write(cmd.getBytes());
            channel.write(val);
            channel.write("\r\n".getBytes());
            channel.flush();
            SetInputStreamWrapper setInputStreamWrapper = new SetInputStreamWrapper(channel);
            line = setInputStreamWrapper.readLine();
            if (log.isDebugEnabled()) {
                log.debug((Object)("memcache cmd (result code): " + cmd + " (" + line + ")"));
            }
            if (!STORED.equals(line)) break block37;
            if (log.isDebugEnabled()) {
                log.debug((Object)("data successfully stored for key: " + key));
            }
            this.closeMemcachedChannel(channel, key);
            return true;
        }
        try {
            if (NOTSTORED.equals(line)) {
                log.info((Object)("data not stored in cache for key: " + key));
            } else {
                log.error((Object)("error storing data in cache for key: " + key + " -- length: " + val.length));
                log.error((Object)("server response: " + line));
            }
        }
        catch (Exception e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            log.error((Object)"exception thrown while writing bytes to server on set");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.closeMemcachedChannel(channel, key);
        return false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void closeMemcachedChannel(MemcachedChannel channel, String key) {
        block4: {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnSet(this, e, key);
                    }
                    if (!log.isDebugEnabled()) break block4;
                    e.printStackTrace(System.err);
                }
            }
        }
        channel = null;
    }

    @Override
    public boolean isDynamic() {
        return this.source.isDynamic();
    }

    @Override
    public Object[] getMultiArray(String[] keys) {
        String cleanKey;
        if (keys == null || keys.length == 0) {
            log.error((Object)"missing keys for getMulti()");
            return null;
        }
        Object[] rets = new Object[keys.length];
        boolean asString = false;
        StringBuilder cmdString = new StringBuilder().append("get");
        int i = 0;
        while (i < keys.length) {
            block12: {
                String key = keys[i];
                if (key == null) {
                    log.error((Object)"null key, so skipping");
                } else {
                    cleanKey = key;
                    try {
                        cleanKey = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                        }
                        log.error((Object)"failed to sanitize your key!", (Throwable)e);
                        break block12;
                    }
                    cmdString.append(" ").append(cleanKey);
                }
            }
            ++i;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(keys.length);
        this.doMulti(asString, cmdString, ret);
        int i2 = 0;
        while (i2 < keys.length) {
            block13: {
                cleanKey = keys[i2];
                try {
                    cleanKey = MemcachedUtils.sanitizeKey(this.sanitizeKeys, keys[i2]);
                }
                catch (UnsupportedEncodingException e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, keys[i2]);
                    }
                    log.error((Object)"failed to sanitize your key!", (Throwable)e);
                    break block13;
                }
                if (ret.containsKey(cleanKey)) {
                    rets[i2] = ret.get(cleanKey);
                }
            }
            ++i2;
        }
        return rets;
    }

    private void doMulti(boolean asString, StringBuilder cmdString, Map<String, Object> ret) {
        if (cmdString == null || cmdString.toString().length() == 0 || ret == null) {
            return;
        }
        MemcachedChannel channel = null;
        try {
            channel = this.source.getMemcachedChannel();
        }
        catch (Exception e1) {
            log.error((Object)("error : " + e1.getMessage()));
            e1.printStackTrace();
        }
        if (channel == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), cmdString.toString());
            }
            return;
        }
        try {
            String line;
            channel.write(cmdString.append("\r\n").toString().getBytes());
            channel.flush();
            GetInputStreamWrapper getInputStreamWrapper = new GetInputStreamWrapper(channel);
            while ((line = getInputStreamWrapper.readKeys("")).startsWith(VALUE)) {
                Object o = null;
                String[] info = line.split(" ");
                String key = info[1];
                int flag = Integer.parseInt(info[2]);
                int length = Integer.parseInt(info[3]);
                byte[] buf = new byte[length];
                getInputStreamWrapper.read(buf);
                getInputStreamWrapper.clearEOL();
                if ((flag & 2) == 2) {
                    try {
                        int count;
                        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                        byte[] tmp = new byte[2048];
                        while ((count = gzi.read(tmp)) != -1) {
                            bos.write(tmp, 0, count);
                        }
                        buf = bos.toByteArray();
                        gzi.close();
                    }
                    catch (IOException e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                        }
                        log.error((Object)("IOException thrown while trying to uncompress input stream for key: " + key));
                        log.error((Object)e.getMessage(), (Throwable)e);
                        throw new NestedIOException("IOException thrown while trying to uncompress input stream for key: " + key, e);
                    }
                }
                if ((flag & 8) != 8) {
                    if (this.primitiveAsString || asString) {
                        log.info((Object)"retrieving object and stuffing into a string.");
                        o = new String(buf, this.defaultEncoding);
                    } else {
                        try {
                            o = NativeHandler.decode(buf, flag);
                        }
                        catch (Exception e) {
                            if (this.errorHandler != null) {
                                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                            }
                            log.error((Object)("++++ Exception thrown while trying to deserialize for key: " + key), (Throwable)e);
                            throw new NestedIOException(e);
                        }
                    }
                } else {
                    ContextObjectInputStream ois = new ContextObjectInputStream(new ByteArrayInputStream(buf), this.classLoader);
                    try {
                        o = ois.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
                        }
                        log.error((Object)("ClassNotFoundException thrown while trying to deserialize for key: " + key), (Throwable)e);
                        throw new NestedIOException("+++ failed while trying to deserialize for key: " + key, e);
                    }
                }
                ret.put(key, o);
            }
            if (!END.equals(line)) {
                log.error((Object)("server error: " + StringUtils.defaultIfEmpty((String)line, (String)"")));
            }
            this.closeMemcachedChannel(channel, cmdString.toString());
            return;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, cmdString.toString());
            }
            log.error((Object)("++++ exception thrown while trying to get object from cache for key: " + cmdString.toString()));
            log.error((Object)e.getMessage(), (Throwable)e);
            this.closeMemcachedChannel(channel, cmdString.toString());
            this.closeMemcachedChannel(channel, cmdString.toString());
            return;
        }
    }

    @Override
    public long decr(String key, long inc) {
        String cmdName = "decr";
        try {
            key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            log.error((Object)"failed to sanitize your key!", (Throwable)e);
            return -1L;
        }
        MemcachedChannel channel = null;
        try {
            channel = this.source.getMemcachedChannel();
        }
        catch (Exception e1) {
            log.error((Object)("error : " + e1.getMessage()));
            e1.printStackTrace();
        }
        if (channel == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
            }
            return -1L;
        }
        String cmd = String.format("%s %s %d\r\n", cmdName, key, inc);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("memcache incr/decr command: " + cmd));
            }
            channel.write(cmd.getBytes());
            channel.flush();
            IncrOrDecrInputStreamWrapper inputStreamWrapper = new IncrOrDecrInputStreamWrapper(channel);
            String line = inputStreamWrapper.readLine();
            this.closeMemcachedChannel(channel, cmd.toString());
            if (line.matches("\\d+")) {
                try {
                    return Long.parseLong(line);
                }
                catch (Exception ex) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)ex, key);
                    }
                    log.error((Object)String.format("Failed to parse Long value for key: %s", key));
                }
            } else if (NOTFOUND.equals(line)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("key not found to incr/decr for key: " + key));
                }
            } else {
                log.error((Object)("error incr/decr key: " + key));
                log.error((Object)("server response: " + line));
            }
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
            }
            log.error((Object)"++++ exception thrown while writing bytes to server on incr/decr");
            log.error((Object)e.getMessage(), (Throwable)e);
            this.closeMemcachedChannel(channel, cmd.toString());
        }
        return -1L;
    }

    @Override
    public long incr(String key, long inc) {
        String cmdName = "incr";
        try {
            key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            log.error((Object)"failed to sanitize your key!", (Throwable)e);
            return -1L;
        }
        MemcachedChannel channel = null;
        try {
            channel = this.source.getMemcachedChannel();
        }
        catch (Exception e1) {
            log.error((Object)("error : " + e1.getMessage()));
            e1.printStackTrace();
        }
        if (channel == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
            }
            return -1L;
        }
        String cmd = String.format("%s %s %d\r\n", cmdName, key, inc);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("memcache incr/decr command: " + cmd));
            }
            channel.write(cmd.getBytes());
            channel.flush();
            IncrOrDecrInputStreamWrapper inputStreamWrapper = new IncrOrDecrInputStreamWrapper(channel);
            String line = inputStreamWrapper.readLine();
            this.closeMemcachedChannel(channel, cmd.toString());
            if (line.matches("\\d+")) {
                try {
                    return Long.parseLong(line);
                }
                catch (Exception ex) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)ex, key);
                    }
                    log.error((Object)String.format("Failed to parse Long value for key: %s", key));
                }
            } else if (NOTFOUND.equals(line)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("key not found to incr/decr for key: " + key));
                }
            } else {
                log.error((Object)("error incr/decr key: " + key));
                log.error((Object)("server response: " + line));
            }
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((CacheClient)this, (Throwable)e, key);
            }
            log.error((Object)"++++ exception thrown while writing bytes to server on incr/decr");
            log.error((Object)e.getMessage(), (Throwable)e);
            this.closeMemcachedChannel(channel, cmd.toString());
        }
        return -1L;
    }

    @Override
    public boolean prepend(String key, String value) {
        block23: {
            byte[] val;
            String cmdName = "prepend";
            try {
                key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                log.error((Object)"failed to sanitize your key!", (Throwable)e);
                return false;
            }
            if (value == null) {
                log.error((Object)"trying to store a null value to cache");
                return false;
            }
            MemcachedChannel channel = null;
            try {
                channel = this.source.getMemcachedChannel();
            }
            catch (Exception e1) {
                log.error((Object)("error : " + e1.getMessage()));
                e1.printStackTrace();
            }
            if (channel == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
                }
                return false;
            }
            int flags = 0;
            try {
                flags |= NativeHandler.getMarkerFlag(value);
                val = NativeHandler.encode((Object)value);
            }
            catch (Exception e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                log.error((Object)"Failed to native handle obj", (Throwable)e);
                this.closeMemcachedChannel(channel, key);
                return false;
            }
            try {
                String cmd = String.format("%s %s %d %d %d\r\n", cmdName, key, flags, 0, val.length);
                channel.write(cmd.getBytes());
                channel.write(val);
                channel.write("\r\n".getBytes());
                channel.flush();
                SetInputStreamWrapper setInputStreamWrapper = new SetInputStreamWrapper(channel);
                String line = setInputStreamWrapper.readLine();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("memcache cmd (result code): " + cmd + " (" + line + ")"));
                }
                if (STORED.equals(line)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("data successfully stored for key: " + key));
                    }
                    this.closeMemcachedChannel(channel, key);
                    return true;
                }
                try {
                    if (NOTSTORED.equals(line)) {
                        if (log.isDebugEnabled()) {
                            log.info((Object)("data not stored in cache for key: " + key));
                        }
                        break block23;
                    }
                    log.error((Object)("error storing data in cache for key: " + key + " -- length: " + val.length));
                    log.error((Object)("server response: " + line));
                }
                catch (Exception e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnSet(this, e, key);
                    }
                    log.error((Object)"exception thrown while writing bytes to server on set");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.closeMemcachedChannel(channel, key);
            }
        }
        return false;
    }

    @Override
    public boolean append(String key, String value) {
        block22: {
            byte[] val;
            String cmdName = "append";
            try {
                key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                log.error((Object)"failed to sanitize your key!", (Throwable)e);
                return false;
            }
            if (value == null) {
                log.error((Object)"trying to store a null value to cache");
                return false;
            }
            MemcachedChannel channel = null;
            try {
                channel = this.source.getMemcachedChannel();
            }
            catch (Exception e1) {
                log.error((Object)("error : " + e1.getMessage()));
                e1.printStackTrace();
            }
            if (channel == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
                }
                return false;
            }
            int flags = 0;
            try {
                flags |= NativeHandler.getMarkerFlag(value);
                val = NativeHandler.encode((Object)value);
            }
            catch (Exception e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                log.error((Object)"Failed to native handle obj", (Throwable)e);
                this.closeMemcachedChannel(channel, key);
                return false;
            }
            try {
                String cmd = String.format("%s %s %d %d %d\r\n", cmdName, key, flags, 0, val.length);
                channel.write(cmd.getBytes());
                channel.write(val);
                channel.write("\r\n".getBytes());
                channel.flush();
                SetInputStreamWrapper setInputStreamWrapper = new SetInputStreamWrapper(channel);
                String line = setInputStreamWrapper.readLine();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("memcache cmd (result code): " + cmd + " (" + line + ")"));
                }
                if (STORED.equals(line)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("data successfully stored for key: " + key));
                    }
                    this.closeMemcachedChannel(channel, key);
                    return true;
                }
                try {
                    if (NOTSTORED.equals(line)) {
                        log.info((Object)("data not stored in cache for key: " + key));
                        break block22;
                    }
                    log.error((Object)("error storing data in cache for key: " + key + " -- length: " + val.length));
                    log.error((Object)("server response: " + line));
                }
                catch (Exception e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnSet(this, e, key);
                    }
                    log.error((Object)"exception thrown while writing bytes to server on set");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.closeMemcachedChannel(channel, key);
            }
        }
        return false;
    }

    @Override
    public boolean setList(String key, String values) {
        String line;
        byte[] val;
        MemcachedChannel channel;
        block19: {
            String cmdName = "set";
            try {
                key = MemcachedUtils.sanitizeKey(this.sanitizeKeys, key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                log.error((Object)"failed to sanitize your key!", (Throwable)e);
                return false;
            }
            if (values == null) {
                log.error((Object)"trying to store a null value to cache");
                return false;
            }
            channel = null;
            try {
                channel = this.source.getMemcachedChannel();
            }
            catch (Exception e1) {
                log.error((Object)("error : " + e1.getMessage()));
                e1.printStackTrace();
            }
            if (channel == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, new IOException("no channel to server available"), key);
                }
                return false;
            }
            boolean asString = false;
            int flags = 0;
            try {
                flags |= NativeHandler.getMarkerFlag(values);
                val = NativeHandler.encode((Object)values);
            }
            catch (Exception e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                log.error((Object)"Failed to native handle obj", (Throwable)e);
                this.closeMemcachedChannel(channel, key);
                return false;
            }
            String cmd = String.format("%s %s %d %d %d\r\n", cmdName, key, flags, 0, val.length);
            channel.write(cmd.getBytes());
            channel.write(val);
            channel.write("\r\n".getBytes());
            channel.flush();
            SetInputStreamWrapper setInputStreamWrapper = new SetInputStreamWrapper(channel);
            line = setInputStreamWrapper.readLine();
            if (log.isDebugEnabled()) {
                log.debug((Object)("memcache cmd (result code): " + cmd + " (" + line + ")"));
            }
            if (!STORED.equals(line)) break block19;
            if (log.isDebugEnabled()) {
                log.debug((Object)("data successfully stored for key: " + key));
            }
            this.closeMemcachedChannel(channel, key);
            return true;
        }
        try {
            if (NOTSTORED.equals(line)) {
                log.info((Object)("data not stored in cache for key: " + key));
            } else {
                log.error((Object)("error storing data in cache for key: " + key + " -- length: " + val.length));
                log.error((Object)("server response: " + line));
            }
        }
        catch (Exception e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            log.error((Object)"exception thrown while writing bytes to server on set");
            log.error((Object)e.getMessage(), (Throwable)e);
            this.closeMemcachedChannel(channel, key);
        }
        this.closeMemcachedChannel(channel, key);
        return false;
    }
}

