/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.memcached;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.CacheFactory;
import com.lenovo.vctl.dal.cache.LocalCacheFactory;
import com.lenovo.vctl.dal.cache.client.CacheClient;
import com.lenovo.vctl.dal.cache.impl.CacheImpl;
import com.lenovo.vctl.dal.cache.listener.Listener;
import com.lenovo.vctl.dal.cache.memcached.channel.source.MemcachedSource;
import com.lenovo.vctl.dal.cache.memcached.client.MemCachedClientImpl;
import com.lenovo.vctl.dal.cache.memcached.config.helper.CacheConfigHelper;
import com.lenovo.vctl.dal.cache.memcached.route.RoutingServiceImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CacheFactoryImpl
implements CacheFactory {
    private static Logger logger = Logger.getLogger(CacheFactoryImpl.class);
    private static CacheFactory cacheFactory;
    private Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private MemcachedSource source;
    private MemcachedSource dSource;
    private Lock lock = new ReentrantLock(false);

    private CacheFactoryImpl() {
        this.init();
    }

    private void init() {
        this.source = CacheConfigHelper.getMemcachedSource("default");
        this.dSource = CacheConfigHelper.getDynamicMemcachedSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheFactory getInstance() {
        if (cacheFactory != null) return cacheFactory;
        Class<CacheFactoryImpl> clazz = CacheFactoryImpl.class;
        synchronized (CacheFactoryImpl.class) {
            if (cacheFactory != null) return cacheFactory;
            cacheFactory = new CacheFactoryImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheFactory;
        }
    }

    @Override
    public Cache getCache(String name) {
        Cache cache;
        block14: {
            cache = null;
            if (StringUtils.isEmpty((String)name)) {
                logger.warn((Object)"cache name must have value");
                return null;
            }
            cache = this.caches.get(name);
            if (cache == null) {
                if (!CacheConfigHelper.isExistRegion(name)) {
                    return null;
                }
                this.lock.lock();
                try {
                    cache = this.caches.get(name);
                    if (cache != null) break block14;
                    if (CacheConfigHelper.isRemoteCache(name)) {
                        MemCachedClientImpl cacheClient = new MemCachedClientImpl(this.source);
                        cache = new CacheImpl(name, cacheClient, RoutingServiceImpl.getInstance());
                        if (cache != null) {
                            String listenerClass = CacheConfigHelper.getListenerClass(name);
                            Listener listener = null;
                            if (StringUtils.isNotEmpty((String)listenerClass)) {
                                try {
                                    listener = (Listener)Class.forName(listenerClass).newInstance();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage());
                                    e.printStackTrace(System.err);
                                }
                            }
                            cache.regListener(listener);
                            ((CacheImpl)cache).setEnableLocalCache(CacheConfigHelper.isLocalCache(name));
                            ((CacheImpl)cache).setHasClassInfo(CacheConfigHelper.isHasClassInfo(name));
                            int initLen = CacheConfigHelper.getListLimitLen(name);
                            ((CacheImpl)cache).setLimitLen(initLen);
                        }
                    } else if (CacheConfigHelper.isLocalCache(name)) {
                        cache = LocalCacheFactory.getInstance().getCache(name);
                    }
                    if (cache != null) {
                        this.caches.put(name, cache);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return cache;
    }

    @Override
    public Cache getCache(String name, boolean isDynamic) {
        CacheClient cacheClient;
        Cache cache;
        block18: {
            cache = null;
            if (StringUtils.isEmpty((String)name)) {
                logger.warn((Object)"cache name must have value");
                return null;
            }
            cache = this.caches.get(name);
            if (cache == null) {
                if (!CacheConfigHelper.isExistRegion(name)) {
                    return null;
                }
                this.lock.lock();
                try {
                    cache = this.caches.get(name);
                    if (cache != null) break block18;
                    if (CacheConfigHelper.isRemoteCache(name)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("cache not exist! begin create cache " + name));
                        }
                        cacheClient = new MemCachedClientImpl();
                        if (isDynamic) {
                            ((MemCachedClientImpl)cacheClient).setSource(this.dSource);
                        } else {
                            ((MemCachedClientImpl)cacheClient).setSource(this.source);
                        }
                        cache = new CacheImpl(name, cacheClient, RoutingServiceImpl.getInstance());
                        if (cache != null) {
                            String listenerClass = CacheConfigHelper.getListenerClass(name);
                            Listener listener = null;
                            if (StringUtils.isNotEmpty((String)listenerClass)) {
                                try {
                                    listener = (Listener)Class.forName(listenerClass).newInstance();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage());
                                    e.printStackTrace(System.err);
                                }
                            }
                            cache.regListener(listener);
                            ((CacheImpl)cache).setEnableLocalCache(CacheConfigHelper.isLocalCache(name));
                            ((CacheImpl)cache).setHasClassInfo(CacheConfigHelper.isHasClassInfo(name));
                            int initLen = CacheConfigHelper.getListLimitLen(name);
                            ((CacheImpl)cache).setLimitLen(initLen);
                        }
                    } else if (CacheConfigHelper.isLocalCache(name)) {
                        cache = LocalCacheFactory.getInstance().getCache(name);
                    }
                    if (cache != null) {
                        this.caches.put(name, cache);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (cache != null && cache instanceof CacheImpl && (cacheClient = ((CacheImpl)cache).getClient()).isDynamic() != isDynamic) {
            logger.info((Object)("cacheClient dynamic is : " + cacheClient.isDynamic() + " , request is " + isDynamic));
            throw new RuntimeException("Cache don't match specify Dynamic module");
        }
        return cache;
    }

    @Override
    public void removeCache(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            this.caches.remove(name);
        }
    }
}

