/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.impl;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.ListResult;
import com.lenovo.vctl.dal.cache.exception.CacheException;
import com.lenovo.vctl.dal.cache.exception.NotFoundKeyException;
import com.lenovo.vctl.dal.cache.listener.Listener;
import com.lenovo.vctl.dal.cache.utils.DebugTimeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Element;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class LocalCacheImpl
implements Cache {
    private static Logger logger = Logger.getLogger(LocalCacheImpl.class);
    private net.sf.ehcache.Cache ehCache;
    private String region;
    private Listener listener;
    private int limitLen = 300;
    private int initLen = 100;

    public int getLimitLen() {
        return this.limitLen;
    }

    public void setLimitLen(int limitLen) {
        this.limitLen = limitLen;
    }

    public int getInitLen() {
        return this.initLen;
    }

    public void setInitLen(int initLen) {
        this.initLen = initLen;
    }

    public LocalCacheImpl(net.sf.ehcache.Cache ehCache, String regionName) {
        this.ehCache = ehCache;
        this.region = regionName;
    }

    public net.sf.ehcache.Cache getEhCache() {
        return this.ehCache;
    }

    public void setEhCache(net.sf.ehcache.Cache ehCache) {
        this.ehCache = ehCache;
    }

    @Override
    public boolean delete(String key) throws CacheException {
        return this.ehCache.remove((Serializable)((Object)key));
    }

    @Override
    public boolean remove(String key) throws CacheException {
        return this.ehCache.remove((Serializable)((Object)key));
    }

    @Override
    public Object get(String key) throws CacheException {
        Element element = this.ehCache.get((Serializable)((Object)key));
        return element == null ? null : element.getObjectValue();
    }

    @Override
    public String getRegion() throws CacheException {
        return this.region;
    }

    @Override
    public boolean put(String key, Object value) throws CacheException {
        Element element = new Element((Object)key, value);
        this.ehCache.put(element);
        return true;
    }

    @Override
    public boolean put(String key, Object value, String dispatchKey) throws CacheException {
        return this.put(key, value);
    }

    @Override
    public void regListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public boolean update(String key, Object value) throws CacheException {
        return this.put(key, value);
    }

    @Override
    public boolean save(String key, Object value) throws CacheException {
        return this.put(key, value);
    }

    @Override
    public boolean isDelete(String key) throws CacheException {
        return false;
    }

    @Override
    public Object[] get(String[] key) throws CacheException {
        if (ArrayUtils.isEmpty((Object[])key)) {
            return null;
        }
        Object[] lresult = new Object[key.length];
        int i = 0;
        while (i < key.length) {
            lresult[i] = this.get(key[i]);
            ++i;
        }
        return lresult;
    }

    @Override
    public boolean save(Map<String, Object> objectsMap) throws CacheException {
        return true;
    }

    @Override
    public long decr(String key, long inc) throws CacheException {
        return 0L;
    }

    @Override
    public long incr(String key, long inc) throws CacheException {
        Object o = this.get(key);
        if (o != null && inc != 0L) {
            Long lResult = NumberUtils.toLong((String)o.toString(), (long)0L);
            lResult = lResult + inc;
            this.put(key, lResult);
            return lResult;
        }
        if (o == null) {
            return -1L;
        }
        return NumberUtils.toLong((String)ObjectUtils.toString((Object)o, (String)"0"), (long)0L);
    }

    @Override
    public ListResult ladd(String key, String value) throws NotFoundKeyException {
        try {
            this.remove(key);
            return ListResult.LIST_OK;
        }
        catch (CacheException e) {
            e.printStackTrace(System.err);
            return ListResult.LIST_ERROR;
        }
    }

    @Override
    public List<String> lrange(String key, int beg, int end) throws NotFoundKeyException {
        ArrayList<Object> lResult = null;
        if (beg > end || end == 0) {
            return lResult;
        }
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)"region:  key is empty or null");
            return null;
        }
        Object o = null;
        try {
            Object[] tempArray;
            String resultStr;
            Object[] strings;
            o = this.get(key);
            if (o != null && !ArrayUtils.isEmpty((Object[])(strings = StringUtils.split((String)(resultStr = (String)o), (char)','))) && !ArrayUtils.isEmpty((Object[])(tempArray = (String[])ArrayUtils.subarray((Object[])strings, (int)beg, (int)end)))) {
                lResult = new ArrayList<Object>();
                int i = 0;
                while (i < tempArray.length) {
                    lResult.add(tempArray[i]);
                    ++i;
                }
                if (tempArray.length > this.limitLen) {
                    logger.info((Object)"list too long , begin remove");
                    this.remove(key);
                }
            }
        }
        catch (Exception e) {
            throw new NotFoundKeyException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get time : " + DebugTimeUtils.getDistanceTime()));
        }
        return lResult;
    }

    @Override
    public ListResult radd(String key, String value) throws NotFoundKeyException {
        try {
            this.remove(key);
            return ListResult.LIST_OK;
        }
        catch (CacheException e) {
            e.printStackTrace(System.err);
            return ListResult.LIST_ERROR;
        }
    }

    @Override
    public ListResult removeList(String key) throws CacheException {
        return null;
    }

    @Override
    public ListResult setList(String key, List<Object> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            if (values.size() > this.limitLen) {
                return ListResult.LIST_LIMT;
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < values.size()) {
                Object value = values.get(i);
                if (sb.length() > 0) {
                    sb.append(",").append(ObjectUtils.toString((Object)value, (String)""));
                } else {
                    sb.append(ObjectUtils.toString((Object)value, (String)""));
                }
                ++i;
            }
            try {
                this.put(key, sb.toString());
                return ListResult.LIST_OK;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.info((Object)"value list is empty or null");
        return ListResult.LIST_OK;
    }

    @Override
    public Integer lsize(String key) throws CacheException {
        Integer iResult = -1;
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)"region:  key is empty or null");
            return null;
        }
        Object o = null;
        try {
            String resultStr;
            Object[] strings;
            o = this.get(key);
            if (o != null && !ArrayUtils.isEmpty((Object[])(strings = StringUtils.split((String)(resultStr = (String)o), (char)','))) && !ArrayUtils.isEmpty((Object[])strings)) {
                iResult = strings.length;
            }
        }
        catch (Exception e) {
            throw new NotFoundKeyException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get time : " + DebugTimeUtils.getDistanceTime()));
        }
        return iResult;
    }
}

