/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.exception.CacheException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

public class NullObjectContent {
    private static Logger logger = Logger.getLogger(NullObjectContent.class);
    private static int INITIALCAPACITY = 1500;
    public static Map<String, Integer> content = Collections.synchronizedMap(new LRUMap(INITIALCAPACITY));
    public static Map<String, Integer> puting = new ConcurrentHashMap<String, Integer>(150);
    public static Map<String, Integer> getting = new ConcurrentHashMap<String, Integer>(150);
    private static Integer VALUE = 1;
    private static ExecutorService executorService = Executors.newFixedThreadPool(10);
    private static Cache cache = null;
    public static NullObjectContent _this = new NullObjectContent();

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                executorService.shutdown();
            }
        });
    }

    public static void setNull(String key) {
        content.put(key, VALUE);
        if (!puting.containsKey(key)) {
            try {
                puting.put(key, VALUE);
                RemotePut put = new RemotePut(key);
                executorService.execute(put);
            }
            finally {
                puting.remove(key);
            }
        }
    }

    public static boolean isNull(String key) {
        Boolean b = content.containsKey(key);
        if (!getting.containsKey(key)) {
            try {
                getting.put(key, VALUE);
                RemoteGet get = new RemoteGet(key);
                executorService.execute(get);
            }
            finally {
                getting.remove(key);
            }
        }
        return b;
    }

    public static void remove(String key) {
        block5: {
            try {
                content.remove(key);
                if (cache != null) {
                    cache.remove(key);
                } else if (logger.isTraceEnabled()) {
                    logger.trace((Object)"fix me");
                    logger.trace((Object)"Warn :Global Cache is null ");
                }
            }
            catch (CacheException e) {
                logger.error((Object)e.getMessage());
                if (!logger.isDebugEnabled()) break block5;
                e.printStackTrace();
            }
        }
    }

    private static class RemoteGet
    implements Runnable {
        private String key;

        public RemoteGet(String key) {
            this.key = key;
        }

        @Override
        public void run() {
            block6: {
                try {
                    if (cache == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"global cache is null");
                        }
                        return;
                    }
                    Object o = cache.get(this.key);
                    if (o == null) {
                        content.remove(this.key);
                    } else {
                        content.put(this.key, VALUE);
                    }
                }
                catch (CacheException e) {
                    logger.error((Object)e.getMessage());
                    if (!logger.isDebugEnabled()) break block6;
                    e.printStackTrace();
                }
            }
        }
    }

    private static class RemotePut
    implements Runnable {
        private String key;

        public RemotePut(String key) {
            this.key = key;
        }

        @Override
        public void run() {
            block4: {
                try {
                    if (cache != null) {
                        cache.put(this.key, VALUE);
                    } else {
                        logger.warn((Object)"Warn :Global Cache is null ");
                    }
                }
                catch (CacheException e) {
                    logger.error((Object)e.getMessage());
                    if (!logger.isDebugEnabled()) break block4;
                    e.printStackTrace();
                }
            }
        }
    }
}

